/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum TqrWait {
    NA(0),
    YES(1),
    NO(2),
    NOT_DEFINED(-16);

    private static Map<Integer, TqrWait> valueMap;
    private final int tqrwait;

    private TqrWait(int tqrwait) {
        this.tqrwait = tqrwait;
    }

    public static TqrWait from(int value) {
        TqrWait result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tqrwait() {
        return this.tqrwait;
    }

    static {
        valueMap = new HashMap<Integer, TqrWait>();
        for (TqrWait x : TqrWait.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tqrwait, x);
        }
    }
}

