/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.dataset;

import java.util.HashMap;
import java.util.Map;

public enum CarriageControl {
    ANSI(1),
    MACHINE(2),
    NULL(3),
    NONE(-32),
    NOT_DEFINED(-16);

    private static Map<Integer, CarriageControl> valueMap;
    private final transient int dccarriagecontrol;

    private CarriageControl(int dccarriagecontrol) {
        this.dccarriagecontrol = dccarriagecontrol;
    }

    public static CarriageControl from(int value) {
        CarriageControl result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int dccarriagecontrol() {
        return this.dccarriagecontrol;
    }

    static {
        valueMap = new HashMap<Integer, CarriageControl>();
        for (CarriageControl x : CarriageControl.values()) {
            if (x != NOT_DEFINED) {
                valueMap.put(x.dccarriagecontrol, x);
            }
            valueMap.put(0, NULL);
        }
    }
}

