/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.dataset;

import com.blackhillsoftware.smf.dataset.CarriageControl;

public enum Recfm {
    NULL(RecordType.UNDEFINED, false, false, CarriageControl.NONE),
    F(RecordType.FIXED, false, false, CarriageControl.NONE),
    V(RecordType.VARIABLE, false, false, CarriageControl.NONE),
    U(RecordType.UNDEFINED, false, false, CarriageControl.NONE),
    FB(RecordType.FIXED, true, false, CarriageControl.NONE),
    VB(RecordType.VARIABLE, true, false, CarriageControl.NONE),
    FS(RecordType.FIXED, false, true, CarriageControl.NONE),
    VS(RecordType.VARIABLE, false, true, CarriageControl.NONE),
    FBS(RecordType.FIXED, true, true, CarriageControl.NONE),
    VBS(RecordType.VARIABLE, true, true, CarriageControl.NONE),
    FA(RecordType.FIXED, false, false, CarriageControl.ANSI),
    VA(RecordType.VARIABLE, false, false, CarriageControl.ANSI),
    UA(RecordType.UNDEFINED, false, false, CarriageControl.ANSI),
    FBA(RecordType.FIXED, true, false, CarriageControl.ANSI),
    VBA(RecordType.VARIABLE, true, false, CarriageControl.ANSI),
    FSA(RecordType.FIXED, false, true, CarriageControl.ANSI),
    VSA(RecordType.VARIABLE, false, true, CarriageControl.ANSI),
    FBSA(RecordType.FIXED, true, true, CarriageControl.ANSI),
    VBSA(RecordType.VARIABLE, true, true, CarriageControl.ANSI),
    FM(RecordType.FIXED, false, false, CarriageControl.MACHINE),
    VM(RecordType.VARIABLE, false, false, CarriageControl.MACHINE),
    UM(RecordType.UNDEFINED, false, false, CarriageControl.MACHINE),
    FBM(RecordType.FIXED, true, false, CarriageControl.MACHINE),
    VBM(RecordType.VARIABLE, true, false, CarriageControl.MACHINE),
    FSM(RecordType.FIXED, false, true, CarriageControl.MACHINE),
    VSM(RecordType.VARIABLE, false, true, CarriageControl.MACHINE),
    FBSM(RecordType.FIXED, true, true, CarriageControl.MACHINE),
    VBSM(RecordType.VARIABLE, true, true, CarriageControl.MACHINE),
    NOT_DEFINED(RecordType.UNDEFINED, false, false, CarriageControl.NONE);

    transient RecordType rectype;
    transient boolean blocked;
    transient boolean spanned;
    transient CarriageControl control;
    private static Recfm[] recfmBytes;

    private Recfm(RecordType datasetrecfm, boolean blocked, boolean spanned, CarriageControl control) {
        this.rectype = datasetrecfm;
        this.blocked = blocked;
        this.spanned = spanned;
        this.control = control;
    }

    public RecordType format() {
        return this.rectype;
    }

    public boolean blocked() {
        return this.blocked;
    }

    public boolean spanned() {
        if (this.rectype == RecordType.FIXED) {
            return false;
        }
        return this.spanned;
    }

    public boolean standard() {
        if (this.rectype == RecordType.VARIABLE) {
            return false;
        }
        return this.spanned;
    }

    public CarriageControl controlChars() {
        return this.control;
    }

    public static Recfm fromRecfmByte(int recfmByte) {
        if (recfmByte == 0) {
            return NULL;
        }
        if (recfmBytes[recfmByte] != null) {
            return recfmBytes[recfmByte];
        }
        int reclenType = recfmByte & 0xC0;
        int blocked = recfmByte & 0x10;
        int spanned = recfmByte & 8;
        int ansi = recfmByte & 4;
        int machine = recfmByte & 2;
        Recfm result = NOT_DEFINED;
        if (reclenType == 192) {
            result = ansi == 0 && machine == 0 ? U : (ansi != 0 ? UA : UM);
        } else if (reclenType == 128) {
            result = blocked == 0 ? (spanned == 0 ? (ansi == 0 && machine == 0 ? F : (ansi != 0 ? FA : FM)) : (ansi == 0 && machine == 0 ? FS : (ansi != 0 ? FSA : FSM))) : (spanned == 0 ? (ansi == 0 && machine == 0 ? FB : (ansi != 0 ? FBA : FBM)) : (ansi == 0 && machine == 0 ? FBS : (ansi != 0 ? FBSA : FBSM)));
        } else if (reclenType == 64) {
            result = blocked == 0 ? (spanned == 0 ? (ansi == 0 && machine == 0 ? V : (ansi != 0 ? VA : VM)) : (ansi == 0 && machine == 0 ? VS : (ansi != 0 ? VSA : VSM))) : (spanned == 0 ? (ansi == 0 && machine == 0 ? VB : (ansi != 0 ? VBA : VBM)) : (ansi == 0 && machine == 0 ? VBS : (ansi != 0 ? VBSA : VBSM)));
        }
        Recfm.recfmBytes[recfmByte] = result;
        return Recfm.recfmBytes[recfmByte];
    }

    static {
        recfmBytes = new Recfm[256];
    }

    public static enum RecordType {
        FIXED,
        VARIABLE,
        UNDEFINED;

    }
}

