/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.db2.section.Q8ac;
import com.blackhillsoftware.smf.db2.section.Qbac;
import com.blackhillsoftware.smf.db2.section.Qbga;
import com.blackhillsoftware.smf.db2.section.Qifa;
import com.blackhillsoftware.smf.db2.section.Qlac;
import com.blackhillsoftware.smf.db2.section.Qmda;
import com.blackhillsoftware.smf.db2.section.Qpac;
import com.blackhillsoftware.smf.db2.section.Qpkg;
import com.blackhillsoftware.smf.db2.section.Qtga;
import com.blackhillsoftware.smf.db2.section.Qtxa;
import com.blackhillsoftware.smf.db2.section.Qwa0;
import com.blackhillsoftware.smf.db2.section.Qwa1;
import com.blackhillsoftware.smf.db2.section.Qwac;
import com.blackhillsoftware.smf.db2.section.Qwar;
import com.blackhillsoftware.smf.db2.section.Qwax;
import com.blackhillsoftware.smf.db2.section.Qwda;
import com.blackhillsoftware.smf.db2.section.Qxpk;
import com.blackhillsoftware.smf.db2.section.Qxst;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;

public final class Smf101Record
extends SmfDb2Record {
    public static final int SM101CMP = 128;
    public static final int SM101END = 28;
    private Qwa0 m_qwa0 = null;
    private Qwa1 m_qwa1 = null;
    private List<Qwac> m_Qwac = null;
    private List<Qxst> m_Qxst = null;
    private List<Qlac> m_Qlac = null;
    private List<Qmda> m_Qmda = null;
    private List<Qifa> m_Qifa = null;
    private List<Qwar> m_Qwar = null;
    private List<Qbga> m_Qbga = null;
    private List<Qtga> m_Qtga = null;
    private List<Qwda> m_Qwda = null;
    private List<Qwax> m_Qwax = null;
    private List<Q8ac> m_Q8ac = null;
    private List<Qpkg> m_Qpkg = null;
    private List<Qpac> m_Qpac = null;
    private List<Qxpk> m_Qxpk = null;
    private List<Qbac> m_Qbac = null;
    private List<Qtxa> m_Qtxa = null;

    public Smf101Record(byte[] data) {
        super(data);
        if (this.recordType() != 101) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf101Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 101) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf101Record from(SmfRecord record) {
        return new Smf101Record(record);
    }

    public static Smf101Record from(byte[] data) {
        return new Smf101Record(data);
    }

    public int sm101len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sm101sgd() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sm101flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int sm101rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime sm101tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long sm101tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate sm101dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int sm101dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String sm101sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String sm101ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int sm101stf() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long sm101sq() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public boolean sm101cmp() {
        return Util.ConvertFlag(this.data, this.sm101sq(), 128, Field.sm101sq.length, 0);
    }

    public long sm101buf() {
        return Util.ConvertUnsignedBinary4(this.data, 24, Short.MAX_VALUE);
    }

    public Qwa0 qwa0() {
        if (this.m_qwa0 == null) {
            if (this.ifcid() != 3) {
                throw new NotAvailableException("This method is only supported when (IFCID == 3)");
            }
            this.m_qwa0 = Qwa0.create(this.data, 28, this.qwhs().qwhsnsda() * (Qwa0.Field.qwa01pso.length() + Qwa0.Field.qwa01psl.length() + Qwa0.Field.qwa01psn.length()));
        }
        return this.m_qwa0;
    }

    public Qwa1 qwa1() {
        if (this.m_qwa1 == null) {
            if (this.ifcid() != 239) {
                throw new NotAvailableException("This method is only supported when (IFCID == 239)");
            }
            this.m_qwa1 = Qwa1.create(this.data, 28, this.qwhs().qwhsnsda() * (Qwa1.Field.qwa11pso.length() + Qwa1.Field.qwa11psl.length() + Qwa1.Field.qwa11psn.length()));
        }
        return this.m_qwa1;
    }

    public List<Qwac> qwac() {
        this.m_Qwac = this.db2Sections(this.m_Qwac, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r1o.offset(), Qwac::create, 3);
        return this.m_Qwac;
    }

    public List<Qxst> qxst() {
        this.m_Qxst = this.db2Sections(this.m_Qxst, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r2o.offset(), Qxst::create, 3);
        return this.m_Qxst;
    }

    public List<Qlac> qlac() {
        this.m_Qlac = this.db2Sections(this.m_Qlac, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r5o.offset(), Qlac::create, 3);
        return this.m_Qlac;
    }

    public List<Qmda> qmda() {
        this.m_Qmda = this.db2Sections(this.m_Qmda, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r6o.offset(), Qmda::create, 3);
        return this.m_Qmda;
    }

    public List<Qifa> qifa() {
        this.m_Qifa = this.db2Sections(this.m_Qifa, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r7o.offset(), Qifa::create, 3);
        return this.m_Qifa;
    }

    public List<Qwar> qwar() {
        this.m_Qwar = this.db2Sections(this.m_Qwar, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r8o.offset(), Qwar::create, 3);
        return this.m_Qwar;
    }

    public List<Qbga> qbga() {
        this.m_Qbga = this.db2Sections(this.m_Qbga, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r9o.offset(), Qbga::create, 3);
        return this.m_Qbga;
    }

    public List<Qtga> qtga() {
        this.m_Qtga = this.db2Sections(this.m_Qtga, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01rao.offset(), Qtga::create, 3);
        return this.m_Qtga;
    }

    public List<Qwda> qwda() {
        this.m_Qwda = this.db2Sections(this.m_Qwda, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01rbo.offset(), Qwda::create, 3);
        return this.m_Qwda;
    }

    public List<Qwax> qwax() {
        this.m_Qwax = this.db2Sections(this.m_Qwax, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01rco.offset(), Qwax::create, 3);
        return this.m_Qwax;
    }

    public List<Q8ac> q8ac() {
        this.m_Q8ac = this.db2Sections(this.m_Q8ac, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01rdo.offset(), Q8ac::create, 3);
        return this.m_Q8ac;
    }

    public List<Qpkg> qpkg() {
        this.m_Qpkg = this.db2Sections(this.m_Qpkg, this.data, x -> this.qwa1().getTriplet(x), Qwa1.Field.qwa11r1o.offset(), Qpkg::create, 239);
        return this.m_Qpkg;
    }

    public List<Qpac> qpac() {
        this.m_Qpac = this.db2Sections(this.m_Qpac, this.data, x -> this.qwa1().getTriplet(x), Qwa1.Field.qwa11r2o.offset(), Qpac::create, 239);
        return this.m_Qpac;
    }

    public List<Qxpk> qxpk() {
        this.m_Qxpk = this.db2Sections(this.m_Qxpk, this.data, x -> this.qwa1().getTriplet(x), Qwa1.Field.qwa11r3o.offset(), Qxpk::create, 239);
        return this.m_Qxpk;
    }

    public List<Qbac> qbac() {
        switch (this.ifcid()) {
            case 3: {
                this.m_Qbac = this.db2Sections(this.m_Qbac, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r3o.offset(), Qbac::create);
                return this.m_Qbac;
            }
            case 239: {
                this.m_Qbac = this.db2Sections(this.m_Qbac, this.data, x -> this.qwa1().getTriplet(x), Qwa1.Field.qwa11r4o.offset(), Qbac::create);
                return this.m_Qbac;
            }
        }
        return Collections.emptyList();
    }

    public List<Qtxa> qtxa() {
        switch (this.ifcid()) {
            case 3: {
                this.m_Qtxa = this.db2Sections(this.m_Qtxa, this.data, x -> this.qwa0().getTriplet(x), Qwa0.Field.qwa01r4o.offset(), Qtxa::create);
                return this.m_Qtxa;
            }
            case 239: {
                this.m_Qtxa = this.db2Sections(this.m_Qtxa, this.data, x -> this.qwa1().getTriplet(x), Qwa1.Field.qwa11r5o.offset(), Qtxa::create);
                return this.m_Qtxa;
            }
        }
        return Collections.emptyList();
    }

    static enum Field {
        sm101len(0, 2),
        sm101sgd(2, 2),
        sm101flg(4, 1),
        sm101rty(5, 1),
        sm101tme(6, 4),
        sm101dte(10, 4),
        sm101sid(14, 4),
        sm101ssi(18, 4),
        sm101stf(22, 2),
        sm101sq(24, 4),
        sm101buf(24, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

