/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2.section;

import com.blackhillsoftware.smf.db2.section.Qmdaastr;
import com.blackhillsoftware.smf.db2.section.QmdaastrD;
import com.blackhillsoftware.smf.internal.Util;

public final class QmdaInfo
extends Qmdaastr {
    private QmdaastrD m_extension;
    public static final int QMDAACCM = 142;

    private QmdaInfo(byte[] Data2, int offset, int length, QmdaastrD extension) {
        super(Data2, offset, length, extension);
        this.m_extension = extension;
    }

    public String qmdalocn() {
        return Util.ConvertEbcdicOrUtf8(this.data, 0, 16, false);
    }

    public String qmdanetn() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String qmdalunm() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String qmdacnam() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String qmdactyp() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String qmdacorr() {
        return Util.ConvertEbcdic(this.data, 48, 12);
    }

    public String qmdaauth() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public String qmdaplan() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public String qmdaacct() {
        if (this.data.length <= Field.qmdaacct.offset) {
            return null;
        }
        int offset = Field.qmdaacct.offset;
        int length = Math.min(this.data.length - offset, 142);
        byte[] acct = new byte[length + (this.m_extension == null ? 0 : this.m_extension.qmdaastrLen())];
        System.arraycopy(this.data, offset, acct, 0, length);
        if (this.m_extension != null) {
            System.arraycopy(this.m_extension.qmdaastrVar(), 0, acct, length, this.m_extension.qmdaastrLen());
        }
        for (int i = 0; i < acct.length; ++i) {
            if (acct[i] != -1) continue;
            acct[i] = 107;
        }
        return Util.ConvertEbcdic(acct, 0, acct.length);
    }

    public static QmdaInfo create(byte[] Data2, int offset, int length, QmdaastrD extension) {
        return new QmdaInfo(Data2, offset, length, extension);
    }

    static enum Field {
        qmdalocn(0, 16),
        qmdanetn(16, 8),
        qmdalunm(24, 8),
        qmdacnam(32, 8),
        qmdactyp(40, 8),
        qmdacorr(48, 12),
        qmdaauth(60, 8),
        qmdaplan(68, 8),
        qmdaacct(76, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

