/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import java.util.Arrays;

public class Csrcesrv {
    public static int decompress(byte[] input, byte[] output, int inOffset, int inlength, int outOffset, int outExpected) {
        int outProcessed = Csrcesrv.decompress(input, output, inOffset, inlength, outOffset);
        if (outProcessed != outExpected) {
            throw new RuntimeException("Csrcesrv count mismatch. Expected output bytes: " + Integer.toString(outExpected) + ". Actual output bytes: " + Integer.toString(outProcessed));
        }
        return outProcessed;
    }

    public static int decompress(byte[] input, byte[] output, int inOffset, int inlength, int outOffset) {
        int control = input[inOffset] & 0xFF;
        if (control != 128) {
            throw new RuntimeException("Csrcesrv unrecognized block prefix");
        }
        int inProcessed = 1;
        int outProcessed = 0;
        while (inProcessed < inlength) {
            control = input[inOffset + inProcessed] & 0xFF;
            int flag = control & 0x80;
            int count = control & 0x7F;
            if (flag == 0) {
                System.arraycopy(input, inOffset + inProcessed + 1, output, outOffset + outProcessed, count);
                inProcessed += count + 1;
                outProcessed += count;
                continue;
            }
            Arrays.fill(output, outOffset + outProcessed, outOffset + outProcessed + count, input[inOffset + inProcessed + 1]);
            inProcessed += 2;
            outProcessed += count;
        }
        return outProcessed;
    }
}

