/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.readerbuilder;

import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.readerbuilder.LogstreamBuilderParms;
import com.blackhillsoftware.smf.readerbuilder.ReaderBuilderBase;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;

abstract class LogstreamBuilderCommon<T1 extends LogstreamBuilderCommon<T1, T2>, T2 extends LogstreamBuilderCommon<T1, T2>>
extends ReaderBuilderBase<T1> {
    LogstreamBuilderParms parms;

    <T3 extends LogstreamBuilderCommon<T3, T4>, T4 extends LogstreamBuilderCommon<T3, T4>> LogstreamBuilderCommon(LogstreamBuilderCommon<T3, T4> other) {
        super(other);
        this.parms = other.parms;
    }

    LogstreamBuilderCommon(String lsname) {
        Objects.requireNonNull(lsname);
        if (lsname.length() == 0) {
            throw new IllegalArgumentException("Logstream name cannot be empty");
        }
        this.parms = new LogstreamBuilderParms(lsname);
    }

    public T1 sid(String sid) {
        Objects.requireNonNull(sid);
        if (sid.length() == 0 || sid.length() > 4) {
            throw new IllegalArgumentException("Invalid SID length");
        }
        this.parms.sid = sid;
        return (T1)((LogstreamBuilderCommon)this.self());
    }

    public T1 smep(Duration smep) {
        Objects.requireNonNull(smep);
        if (smep.isNegative() || smep.compareTo(Duration.ofMinutes(120L)) > 0) {
            throw new IllegalArgumentException("Invalid smart end point");
        }
        this.parms.smep = smep;
        return (T1)((LogstreamBuilderCommon)this.self());
    }

    @Override
    protected SmfRecordReader createReader() throws IOException {
        String fromStr = null;
        if (this.parms.fromLocalDateTime != null) {
            fromStr = LogstreamBuilderCommon.dateTimeFormat(this.parms.fromLocalDateTime);
        } else if (this.parms.fromZonedDateTime != null) {
            fromStr = LogstreamBuilderCommon.dateTimeFormat(this.parms.fromZonedDateTime);
        }
        String toStr = null;
        if (this.parms.toLocalDateTime != null) {
            toStr = LogstreamBuilderCommon.dateTimeFormat(this.parms.toLocalDateTime);
        } else if (this.parms.toZonedDateTime != null) {
            toStr = LogstreamBuilderCommon.dateTimeFormat(this.parms.toZonedDateTime);
        }
        StringBuffer options1 = new StringBuffer();
        if (fromStr != null) {
            options1.append("'FROM=(");
            options1.append(fromStr);
            options1.append(")");
        }
        if (toStr != null) {
            if (options1.length() > 0) {
                options1.append(",");
            } else {
                options1.append("'");
            }
            options1.append("TO=(");
            options1.append(toStr);
            options1.append(")");
        }
        if (options1.length() > 0) {
            if (this.parms.fromZonedDateTime != null || this.parms.toZonedDateTime != null) {
                options1.append(",GMT'");
            } else {
                options1.append(",LOCAL'");
            }
        }
        StringBuffer options2 = new StringBuffer();
        if (this.parms.sid != null) {
            options2.append("'SID(");
            options2.append(this.parms.sid);
            options2.append(")");
        }
        if (this.parms.smep != null) {
            if (toStr == null) {
                throw new IllegalArgumentException("A TO time must be specified to use SMEP");
            }
            options2.append(options2.length() == 0 ? "'" : ",");
            options2.append("SMEP(");
            options2.append(String.format("%02d%02d", this.parms.smep.toHours(), this.parms.smep.toMinutes() % 60L));
            options2.append(")");
        }
        if (options2.length() > 0) {
            options2.append("'");
        }
        return SmfRecordReader.fromLogstream(this.parms.lsname, options1.length() > 0 ? options1.toString() : null, options2.length() > 0 ? options2.toString() : null);
    }

    private static String dateTimeFormat(LocalDateTime datetime) {
        return String.format("%4d/%3d,%02d:%02d:%02d", datetime.getYear(), datetime.getDayOfYear(), datetime.getHour(), datetime.getMinute(), datetime.getSecond());
    }

    private static String dateTimeFormat(ZonedDateTime datetime) {
        datetime = datetime.withZoneSameInstant(ZoneOffset.UTC);
        return String.format("%4d/%3d,%02d:%02d:%02d", datetime.getYear(), datetime.getDayOfYear(), datetime.getHour(), datetime.getMinute(), datetime.getSecond());
    }
}

