/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf0;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class Smf0Record
extends SmfRecord {
    public static final int SMFRCD0 = 0;
    public static final int SMF0RS4K_Not_Valid = 128;

    public Smf0Record(byte[] data) {
        super(data);
        if (this.recordType() != 0) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf0Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 0) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf0Record from(SmfRecord record) {
        return new Smf0Record(record);
    }

    public static Smf0Record from(byte[] data) {
        return new Smf0Record(data);
    }

    public int smf0len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf0seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf0flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf0rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf0tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf0tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf0dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf0dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf0sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public Duration smf0jwt() {
        return Util.Binary4Minutes(this.data, 18);
    }

    public double smf0jwtSeconds() {
        return Util.ToSeconds(this.smf0jwt());
    }

    public long smf0jwtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 18);
    }

    public long smf0buf() {
        return Util.ConvertUnsignedBinary4(this.data, 22);
    }

    public long smf0vst() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public int smf0opt() {
        return Util.ConvertUnsignedBinary1(this.data, 30);
    }

    public long smf0rst() {
        return Util.ConvertUnsignedBinary4(this.data, 31);
    }

    public int smf0rsv() {
        return Util.ConvertUnsignedBinary1(this.data, 35);
    }

    public String smf0osl() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf0syn() {
        return Util.ConvertEbcdic(this.data, 44, 8);
    }

    public String smf0syp() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public ZoneOffset smf0tz() {
        return Util.Binary4_CVTTZ(this.data, 60);
    }

    public int smf0tzRawValue() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public Duration smf0mswt() {
        return Util.Binary4Minutes(this.data, 64);
    }

    public double smf0mswtSeconds() {
        return Util.ToSeconds(this.smf0mswt());
    }

    public long smf0mswtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public Duration smf0mtwt() {
        return Util.Binary4Minutes(this.data, 68);
    }

    public double smf0mtwtSeconds() {
        return Util.ToSeconds(this.smf0mtwt());
    }

    public long smf0mtwtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public int smf0tbuf() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public long smf0rs4k() {
        return Util.ConvertUnsignedBinary8(this.data, 74);
    }

    public BigInteger smf0rs4kAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 74);
    }

    public int smf0NumCrypCtrs() {
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf0NumNnpiCtrs() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public int smf0Flags() {
        return Util.ConvertUnsignedBinary1(this.data, 86);
    }

    public boolean smf0rs4kNotValid() {
        return Util.ConvertFlag(this.data, this.smf0Flags(), 128);
    }

    static enum Field {
        smf0len(0, 2),
        smf0seg(2, 2),
        smf0flg(4, 1),
        smf0rty(5, 1),
        smf0tme(6, 4),
        smf0dte(10, 4),
        smf0sid(14, 4),
        smf0jwt(18, 4),
        smf0buf(22, 4),
        smf0vst(26, 4),
        smf0opt(30, 1),
        smf0rst(31, 4),
        smf0rsv(35, 1),
        smf0osl(36, 8),
        smf0syn(44, 8),
        smf0syp(52, 8),
        smf0tz(60, 4),
        smf0mswt(64, 4),
        smf0mtwt(68, 4),
        smf0tbuf(72, 2),
        smf0rs4k(74, 8),
        smf0NumCrypCtrs(82, 2),
        smf0NumNnpiCtrs(84, 2),
        smf0Flags(86, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

