/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf11;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf11.Device;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public final class Smf11Record
extends SmfRecord {
    public Smf11Record(byte[] data) {
        super(data);
        if (this.recordType() != 11) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf11Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 11) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf11Record from(SmfRecord record) {
        return new Smf11Record(record);
    }

    public static Smf11Record from(byte[] data) {
        return new Smf11Record(data);
    }

    List<Device> Devices() {
        ArrayList<Device> result = new ArrayList<Device>();
        for (int i = 0; i < (this.smf11ln() - Field.smf11ln.length()) / 8; ++i) {
            result.add(Device.create(this.data, Field.smf11ln.offset() + Field.smf11ln.length() + i * 8, 8));
        }
        return result;
    }

    public int smf11len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf11seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf11flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf11rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf11tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf11tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf11dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf11dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf11sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf11ln() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    static enum Field {
        smf11len(0, 2),
        smf11seg(2, 2),
        smf11flg(4, 1),
        smf11rty(5, 1),
        smf11tme(6, 4),
        smf11dte(10, 4),
        smf11sid(14, 4),
        smf11ln(18, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

