/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.ConnectionInitiation;
import com.blackhillsoftware.smf.smf119.ConnectionTermination;
import com.blackhillsoftware.smf.smf119.ConnectionTerminationATTLSSection;
import com.blackhillsoftware.smf.smf119.ConnectionTerminationAppldataSection;
import com.blackhillsoftware.smf.smf119.ConnectionTerminationIPFilterSection;
import com.blackhillsoftware.smf.smf119.ConnectionTerminationTelnetSection;
import com.blackhillsoftware.smf.smf119.IdentificationSection;
import com.blackhillsoftware.smf.smf119.SelfDefiningSection;
import com.blackhillsoftware.smf.smf119.TN3270SNASessionInitiation;
import com.blackhillsoftware.smf.smf119.TN3270SNASessionPerformanceBuckets;
import com.blackhillsoftware.smf.smf119.TN3270SNASessionTermination;
import com.blackhillsoftware.smf.smf119.TN3270SNASessionTerminationHostname;
import com.blackhillsoftware.smf.smf119.TN3270SNASessionTerminationRoundTripPerformance;
import com.blackhillsoftware.smf.smf119.ZertDetailCertificateDN;
import com.blackhillsoftware.smf.smf119.ZertDetailCommonSection;
import com.blackhillsoftware.smf.smf119.ZertDetailIPFilterSection;
import com.blackhillsoftware.smf.smf119.ZertDetailIPSecSection;
import com.blackhillsoftware.smf.smf119.ZertDetailPolicyEnforcementSection;
import com.blackhillsoftware.smf.smf119.ZertDetailSSHSection;
import com.blackhillsoftware.smf.smf119.ZertDetailTLSSection;
import com.blackhillsoftware.smf.smf119.ZertSummaryCertificateDN;
import com.blackhillsoftware.smf.smf119.ZertSummaryCommonSection;
import com.blackhillsoftware.smf.smf119.ZertSummaryIPSecSection;
import com.blackhillsoftware.smf.smf119.ZertSummarySSHSection;
import com.blackhillsoftware.smf.smf119.ZertSummaryTLSSection;
import com.blackhillsoftware.smf.smf119.values.Smf119Subtype;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Smf119Record
extends SmfRecord {
    private static final int SDSOFFSET = 24;
    private SelfDefiningSection m_SelfDefiningSection = null;
    private IdentificationSection m_IdentificationSection = null;
    private ConnectionInitiation m_ConnectionInitiation = null;
    private ConnectionTermination m_ConnectionTermination = null;
    private ConnectionTerminationTelnetSection m_ConnectionTerminationTelnetSection = null;
    private ConnectionTerminationATTLSSection m_ConnectionTerminationATTLSSection = null;
    private ConnectionTerminationAppldataSection m_ConnectionTerminationAppldataSection = null;
    private ConnectionTerminationIPFilterSection m_ConnectionTerminationIPFilterSection = null;
    private ZertDetailCommonSection m_ZertDetailCommonSection = null;
    private ZertDetailIPFilterSection m_ZertDetailIPFilterSection = null;
    private ZertDetailTLSSection m_ZertDetailTLSSection = null;
    private ZertDetailSSHSection m_ZertDetailSSHSection = null;
    private ZertDetailIPSecSection m_ZertDetailIPSecSection = null;
    private List<ZertDetailCertificateDN> m_ZertDetailCertificateDN = null;
    private ZertDetailPolicyEnforcementSection m_ZertDetailPolicyEnforcementSection = null;
    private ZertSummaryCommonSection m_ZertSummaryCommonSection = null;
    private ZertSummaryTLSSection m_ZertSummaryTLSSection = null;
    private ZertSummarySSHSection m_ZertSummarySSHSection = null;
    private ZertSummaryIPSecSection m_ZertSummaryIPSecSection = null;
    private List<ZertSummaryCertificateDN> m_ZertSummaryCertificateDN = null;
    private TN3270SNASessionInitiation m_TN3270SNASessionInitiation = null;
    private TN3270SNASessionTermination m_TN3270SNASessionTermination = null;
    private TN3270SNASessionTerminationHostname m_TN3270SNASessionTerminationHostname = null;
    private TN3270SNASessionTerminationRoundTripPerformance m_TN3270SNASessionTerminationRoundTripPerformance = null;
    private TN3270SNASessionPerformanceBuckets m_TN3270SNASessionPerformanceBuckets = null;
    public static final int SMF119HDSUB = 64;
    public static final int SMF119HDSP4 = 16;
    public static final int SMF119HDSP3 = 8;
    public static final int SMF119HDSP2 = 4;
    public static final int SMF119HDVS2 = 2;

    public Smf119Record(byte[] data) {
        super(data);
        if (this.recordType() != 119) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf119Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 119) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf119Record from(SmfRecord record) {
        return new Smf119Record(record);
    }

    public static Smf119Record from(byte[] data) {
        return new Smf119Record(data);
    }

    public SelfDefiningSection selfDefiningSection() {
        if (this.m_SelfDefiningSection == null) {
            this.m_SelfDefiningSection = SelfDefiningSection.create(this.data, 24, 20);
        }
        return this.m_SelfDefiningSection;
    }

    public IdentificationSection identificationSection() {
        if (this.m_IdentificationSection == null) {
            this.m_IdentificationSection = IdentificationSection.create(this.data, this.selfDefiningSection().smf119idoff(), this.selfDefiningSection().smf119idlen());
        }
        return this.m_IdentificationSection;
    }

    private Triplet triplet(int tripletNumber) {
        if (tripletNumber > this.selfDefiningSection().smf119sdTrn() - 1) {
            return Triplet.ZEROS;
        }
        return Triplet.get422Triplet(this.data, 24 + SelfDefiningSection.Field.smf119idoff.offset() + tripletNumber * 8);
    }

    public ConnectionInitiation connectionInitiation() {
        if (this.subType() != 1) {
            return null;
        }
        this.m_ConnectionInitiation = Util.sectionFromTriplet(this.m_ConnectionInitiation, this.data, this.triplet(1), ConnectionInitiation::create);
        return this.m_ConnectionInitiation;
    }

    public ConnectionTermination connectionTermination() {
        if (this.subType() != 2) {
            return null;
        }
        this.m_ConnectionTermination = Util.sectionFromTriplet(this.m_ConnectionTermination, this.data, this.triplet(1), ConnectionTermination::create);
        return this.m_ConnectionTermination;
    }

    public ConnectionTerminationTelnetSection connectionTerminationTelnetSection() {
        if (this.subType() != 2) {
            return null;
        }
        this.m_ConnectionTerminationTelnetSection = Util.sectionFromTriplet(this.m_ConnectionTerminationTelnetSection, this.data, this.triplet(2), ConnectionTerminationTelnetSection::create);
        return this.m_ConnectionTerminationTelnetSection;
    }

    public ConnectionTerminationATTLSSection connectionTerminationATTLSSection() {
        if (this.subType() != 2) {
            return null;
        }
        this.m_ConnectionTerminationATTLSSection = Util.sectionFromTriplet(this.m_ConnectionTerminationATTLSSection, this.data, this.triplet(3), ConnectionTerminationATTLSSection::create);
        return this.m_ConnectionTerminationATTLSSection;
    }

    public ConnectionTerminationAppldataSection connectionTerminationAppldataSection() {
        if (this.subType() != 2) {
            return null;
        }
        this.m_ConnectionTerminationAppldataSection = Util.sectionFromTriplet(this.m_ConnectionTerminationAppldataSection, this.data, this.triplet(4), ConnectionTerminationAppldataSection::create);
        return this.m_ConnectionTerminationAppldataSection;
    }

    public ConnectionTerminationIPFilterSection connectionTerminationIPFilterSection() {
        if (this.subType() != 2) {
            return null;
        }
        this.m_ConnectionTerminationIPFilterSection = Util.sectionFromTriplet(this.m_ConnectionTerminationIPFilterSection, this.data, this.triplet(5), ConnectionTerminationIPFilterSection::create);
        return this.m_ConnectionTerminationIPFilterSection;
    }

    public ZertDetailCommonSection zertDetailCommonSection() {
        if (this.subType() != 11) {
            return null;
        }
        this.m_ZertDetailCommonSection = Util.sectionFromTriplet(this.m_ZertDetailCommonSection, this.data, this.triplet(1), ZertDetailCommonSection::create);
        return this.m_ZertDetailCommonSection;
    }

    public ZertDetailIPFilterSection zertDetailIPFilterSection() {
        if (this.subType() != 11) {
            return null;
        }
        this.m_ZertDetailIPFilterSection = Util.sectionFromTriplet(this.m_ZertDetailIPFilterSection, this.data, this.triplet(2), ZertDetailIPFilterSection::create);
        return this.m_ZertDetailIPFilterSection;
    }

    public ZertDetailTLSSection zertDetailTLSSection() {
        if (this.subType() != 11) {
            return null;
        }
        this.m_ZertDetailTLSSection = Util.sectionFromTriplet(this.m_ZertDetailTLSSection, this.data, this.triplet(3), ZertDetailTLSSection::create);
        return this.m_ZertDetailTLSSection;
    }

    public ZertDetailSSHSection zertDetailSSHSection() {
        if (this.subType() != 11) {
            return null;
        }
        this.m_ZertDetailSSHSection = Util.sectionFromTriplet(this.m_ZertDetailSSHSection, this.data, this.triplet(4), ZertDetailSSHSection::create);
        return this.m_ZertDetailSSHSection;
    }

    public ZertDetailIPSecSection zertDetailIpSecSection() {
        ZertDetailIPSecSection result;
        if (this.subType() != 11) {
            return null;
        }
        if (this.m_ZertDetailIPSecSection != null) {
            return this.m_ZertDetailIPSecSection;
        }
        Triplet triplet = this.triplet(5);
        if (triplet.getCount() == 0) {
            return null;
        }
        this.m_ZertDetailIPSecSection = result = ZertDetailIPSecSection.create(this.data, triplet.getOffset(), triplet.getLength(), this.zertDetailCommonSection().smf119scSaIPv6());
        return this.m_ZertDetailIPSecSection;
    }

    public List<ZertDetailCertificateDN> zertDetailCertificateDN() {
        int length;
        int offset;
        if (this.subType() != 11) {
            return null;
        }
        if (this.m_ZertDetailCertificateDN != null) {
            return this.m_ZertDetailCertificateDN;
        }
        Triplet triplet = this.triplet(6);
        int sectionend = offset + triplet.getLength();
        ArrayList<ZertDetailCertificateDN> result = new ArrayList<ZertDetailCertificateDN>();
        for (offset = triplet.getOffset(); offset < sectionend; offset += length) {
            length = ZertDetailCertificateDN.smf119scDnLen(this.data, offset);
            if (offset + length > sectionend) {
                throw new IndexOutOfBoundsException("ZertDetailCertificateDN entry length exceeds section length");
            }
            result.add(ZertDetailCertificateDN.create(this.data, offset, length));
        }
        this.m_ZertDetailCertificateDN = Collections.unmodifiableList(result);
        return this.m_ZertDetailCertificateDN;
    }

    public ZertSummaryCommonSection zertSummaryCommonSection() {
        if (this.subType() != 12) {
            return null;
        }
        this.m_ZertSummaryCommonSection = Util.sectionFromTriplet(this.m_ZertSummaryCommonSection, this.data, this.triplet(1), ZertSummaryCommonSection::create);
        return this.m_ZertSummaryCommonSection;
    }

    public ZertSummaryTLSSection zertSummaryTLSSection() {
        if (this.subType() != 12) {
            return null;
        }
        this.m_ZertSummaryTLSSection = Util.sectionFromTriplet(this.m_ZertSummaryTLSSection, this.data, this.triplet(2), ZertSummaryTLSSection::create);
        return this.m_ZertSummaryTLSSection;
    }

    public ZertSummarySSHSection zertSummarySSHSection() {
        if (this.subType() != 12) {
            return null;
        }
        this.m_ZertSummarySSHSection = Util.sectionFromTriplet(this.m_ZertSummarySSHSection, this.data, this.triplet(3), ZertSummarySSHSection::create);
        return this.m_ZertSummarySSHSection;
    }

    public ZertSummaryIPSecSection zertSummaryIPSecSection() {
        ZertSummaryIPSecSection result;
        if (this.subType() != 12) {
            return null;
        }
        if (this.m_ZertSummaryIPSecSection != null) {
            return this.m_ZertSummaryIPSecSection;
        }
        Triplet triplet = this.triplet(4);
        if (triplet.getCount() == 0) {
            return null;
        }
        this.m_ZertSummaryIPSecSection = result = ZertSummaryIPSecSection.create(this.data, triplet.getOffset(), triplet.getLength(), this.zertDetailCommonSection().smf119scSaIPv6());
        return this.m_ZertSummaryIPSecSection;
    }

    public List<ZertSummaryCertificateDN> zertSummaryCertificateDN() {
        int length;
        int offset;
        if (this.m_ZertSummaryCertificateDN != null) {
            return this.m_ZertSummaryCertificateDN;
        }
        Triplet triplet = this.triplet(5);
        int sectionend = offset + triplet.getLength();
        ArrayList<ZertSummaryCertificateDN> result = new ArrayList<ZertSummaryCertificateDN>();
        for (offset = triplet.getOffset(); offset < sectionend; offset += length) {
            length = ZertSummaryCertificateDN.smf119ssDnLen(this.data, offset);
            if (offset + length > sectionend) {
                throw new IndexOutOfBoundsException("ZertSummaryCertificateDN entry length exceeds section length");
            }
            result.add(ZertSummaryCertificateDN.create(this.data, offset, length));
        }
        this.m_ZertSummaryCertificateDN = Collections.unmodifiableList(result);
        return this.m_ZertSummaryCertificateDN;
    }

    public TN3270SNASessionInitiation tn3270SNASessionInitiation() {
        if (this.subType() != 20) {
            return null;
        }
        this.m_TN3270SNASessionInitiation = Util.sectionFromTriplet(this.m_TN3270SNASessionInitiation, this.data, this.triplet(1), TN3270SNASessionInitiation::create);
        return this.m_TN3270SNASessionInitiation;
    }

    public TN3270SNASessionTermination tn3270SNASessionTermination() {
        if (this.subType() != 21) {
            return null;
        }
        this.m_TN3270SNASessionTermination = Util.sectionFromTriplet(this.m_TN3270SNASessionTermination, this.data, this.triplet(1), TN3270SNASessionTermination::create);
        return this.m_TN3270SNASessionTermination;
    }

    public TN3270SNASessionTerminationHostname tn3270SNASessionTerminationHostname() {
        if (this.subType() != 21) {
            return null;
        }
        this.m_TN3270SNASessionTerminationHostname = Util.sectionFromTriplet(this.m_TN3270SNASessionTerminationHostname, this.data, this.triplet(2), TN3270SNASessionTerminationHostname::create);
        return this.m_TN3270SNASessionTerminationHostname;
    }

    public TN3270SNASessionTerminationRoundTripPerformance tn3270SNASessionTerminationRoundTripPerformance() {
        if (this.subType() != 21) {
            return null;
        }
        this.m_TN3270SNASessionTerminationRoundTripPerformance = Util.sectionFromTriplet(this.m_TN3270SNASessionTerminationRoundTripPerformance, this.data, this.triplet(3), TN3270SNASessionTerminationRoundTripPerformance::create);
        return this.m_TN3270SNASessionTerminationRoundTripPerformance;
    }

    public TN3270SNASessionPerformanceBuckets tn3270SNASessionPerformanceBuckets() {
        if (this.subType() != 21) {
            return null;
        }
        this.m_TN3270SNASessionPerformanceBuckets = Util.sectionFromTriplet(this.m_TN3270SNASessionPerformanceBuckets, this.data, this.triplet(4), TN3270SNASessionPerformanceBuckets::create);
        return this.m_TN3270SNASessionPerformanceBuckets;
    }

    public int smf119hdLength() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf119hdSegDesc() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf119hdFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf119hdsub() {
        return Util.ConvertFlag(this.data, this.smf119hdFlags(), 64);
    }

    public boolean smf119hdSp4() {
        return Util.ConvertFlag(this.data, this.smf119hdFlags(), 16);
    }

    public boolean smf119hdSp3() {
        return Util.ConvertFlag(this.data, this.smf119hdFlags(), 8);
    }

    public boolean smf119hdSp2() {
        return Util.ConvertFlag(this.data, this.smf119hdFlags(), 4);
    }

    public boolean smf119hdVs2() {
        return Util.ConvertFlag(this.data, this.smf119hdFlags(), 2);
    }

    public int smf119hdType() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf119hdTime() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf119hdTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf119hdDate() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf119hdDateRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf119hdSid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf119hdSsi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public Smf119Subtype smf119hdSubtype() {
        int value = Util.ConvertUnsignedBinary2(this.data, 22);
        return Smf119Subtype.from(value);
    }

    public int smf119hdSubtypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    static enum Field {
        smf119hdLength(0, 2),
        smf119hdSegDesc(2, 2),
        smf119hdFlags(4, 1),
        smf119hdType(5, 1),
        smf119hdTime(6, 4),
        smf119hdDate(10, 4),
        smf119hdSid(14, 4),
        smf119hdSsi(18, 4),
        smf119hdSubtype(22, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

