/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.IPProtocol;
import com.blackhillsoftware.smf.smf119.zert.SummaryEvent;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;

public final class ZertSummaryCommonSection
extends SmfData {
    public static final int SMF119SS_SAIPv6 = 128;
    public static final int SMF119SS_SAServer = 64;
    public static final int SMF119SS_SAClient = 32;
    public static final int SMF119SS_SAEEConn = 16;
    public static final int SMF119SS_SAActive_FTP = 8;
    public static final int SMF119SS_SAATTLS_Optimized = 4;
    public static final int SMF119SS_SATCPIP_INTVAL = 2;
    public static final int SMF119SS_SASecProto_TLS = 128;
    public static final int SMF119SS_SASecProto_SSH = 64;
    public static final int SMF119SS_SASecProto_IPSec = 32;
    public static final int SMF119SS_SASecProto_None = 0;

    private ZertSummaryCommonSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf119ssSaIntervalDuration() {
        return Util.Binary8StckInterval(this.data, 0);
    }

    public double smf119ssSaIntervalDurationSeconds() {
        return Util.ToSeconds(this.smf119ssSaIntervalDuration());
    }

    public long smf119ssSaIntervalDurationRawValue() {
        return Util.ConvertSignedBinary8(this.data, 0);
    }

    public SummaryEvent smf119ssSaEventType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 8);
        return SummaryEvent.from(value);
    }

    public int smf119ssSaEventTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf119ssSaFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf119ssSaIPv6() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 128);
    }

    public boolean smf119ssSaServer() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 64);
    }

    public boolean smf119ssSaClient() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 32);
    }

    public boolean smf119ssSaEEConn() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 16);
    }

    public boolean smf119ssSaActiveFtp() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 8);
    }

    public boolean smf119ssSaAttlsOptimized() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 4);
    }

    public boolean smf119ssSaTcpipIntval() {
        return Util.ConvertFlag(this.data, this.smf119ssSaFlags(), 2);
    }

    public int smf119ssSaSecProtos() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean smf119ssSaSecProtoTls() {
        return Util.ConvertFlag(this.data, this.smf119ssSaSecProtos(), 128);
    }

    public boolean smf119ssSaSecProtoSsh() {
        return Util.ConvertFlag(this.data, this.smf119ssSaSecProtos(), 64);
    }

    public boolean smf119ssSaSecProtoIPSec() {
        return Util.ConvertFlag(this.data, this.smf119ssSaSecProtos(), 32);
    }

    public String smf119ssSaJobname() {
        return Util.ConvertEbcdic(this.data, 11, 8);
    }

    public String smf119ssSaUserID() {
        return Util.ConvertEbcdic(this.data, 19, 8);
    }

    public IPProtocol smf119ssSaIpProto() {
        int value = Util.ConvertUnsignedBinary1(this.data, 27);
        return IPProtocol.from(value);
    }

    public int smf119ssSaIpProtoRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public InetAddress smf119ssSaSrvIp() {
        return this.smf119ssSaIPv6() ? this.smf119ssSaSrvIpIPv6() : this.smf119ssSaSrvIpIPv4();
    }

    public BigInteger smf119ssSaSrvIpRawValue() {
        return Util.ConvertBigInteger(this.data, 28, 16);
    }

    private InetAddress smf119ssSaSrvIpIPv4() {
        return Util.ConvertInetV4Address(this.data, 28);
    }

    private BigInteger smf119ssSaSrvIpIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 28, 4);
    }

    private InetAddress smf119ssSaSrvIpIPv6() {
        return Util.ConvertInetV6Address(this.data, 28);
    }

    private BigInteger smf119ssSaSrvIpIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 28, 16);
    }

    public InetAddress smf119ssSaCltIp() {
        return this.smf119ssSaIPv6() ? this.smf119ssSaCLtIpIPv6() : this.smf119ssSaCltIpIPv4();
    }

    public BigInteger smf119ssSaCltIpRawValue() {
        return Util.ConvertBigInteger(this.data, 44, 16);
    }

    private InetAddress smf119ssSaCltIpIPv4() {
        return Util.ConvertInetV4Address(this.data, 44);
    }

    private BigInteger smf119ssSaCltIpIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 44, 4);
    }

    private InetAddress smf119ssSaCLtIpIPv6() {
        return Util.ConvertInetV6Address(this.data, 44);
    }

    private BigInteger smf119ssSaCLtIpIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 44, 16);
    }

    public int smf119ssSaSrvPortStart() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int smf119ssSaSrvPortEnd() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public String smf119ssSaSessionID() {
        return Util.ConvertEbcdic(this.data, 64, 42);
    }

    public long smf119ssSaInitLifeConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smf119ssSaInitLifePartialConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf119ssSaInitLifeShortConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf119ssSaInitActiveConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf119ssSaInitLifeInBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 124);
    }

    public BigInteger smf119ssSaInitLifeInBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 124);
    }

    public long smf119ssSaInitLifeOutBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 132);
    }

    public BigInteger smf119ssSaInitLifeOutBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 132);
    }

    public long smf119ssSaInitLifeInSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 140);
    }

    public BigInteger smf119ssSaInitLifeInSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 140);
    }

    public long smf119ssSaInitLifeOutSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 148);
    }

    public BigInteger smf119ssSaInitLifeOutSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 148);
    }

    public long smf119ssSaEndLifeConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long smf119ssSaEndLifePartialConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long smf119ssSaEndLifeShortConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long smf119ssSaEndActiveConnCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long smf119ssSaEndLifeInBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 172);
    }

    public BigInteger smf119ssSaEndLifeInBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 172);
    }

    public long smf119ssSaEndLifeOutBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 180);
    }

    public BigInteger smf119ssSaEndLifeOutBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 180);
    }

    public long smf119ssSaEndLifeInSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 188);
    }

    public BigInteger smf119ssSaEndLifeInSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 188);
    }

    public long smf119ssSaEndLifeOutSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 196);
    }

    public BigInteger smf119ssSaEndLifeOutSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public boolean smf119ssSASecProtoNone() {
        return Util.ConvertEquateValue(this.data, this.smf119ssSaSecProtos(), 0);
    }

    public static ZertSummaryCommonSection create(byte[] Data2, int offset, int length) {
        return new ZertSummaryCommonSection(Data2, offset, length);
    }

    static enum Field {
        smf119ssSaIntervalDuration(0, 8),
        smf119ssSaEventType(8, 1),
        smf119ssSaFlags(9, 1),
        smf119ssSaSecProtos(10, 1),
        smf119ssSaJobname(11, 8),
        smf119ssSaUserID(19, 8),
        smf119ssSaIpProto(27, 1),
        smf119ssSaSrvIp(28, 16),
        smf119ssSaSrvIpIPv4(28, 4),
        smf119ssSaSrvIpIPv6(28, 16),
        smf119ssSaCltIp(44, 16),
        smf119ssSaCltIpIPv4(44, 4),
        smf119ssSaCLtIpIPv6(44, 16),
        smf119ssSaSrvPortStart(60, 2),
        smf119ssSaSrvPortEnd(62, 2),
        smf119ssSaSessionID(64, 42),
        smf119ssSaInitLifeConnCnt(108, 4),
        smf119ssSaInitLifePartialConnCnt(112, 4),
        smf119ssSaInitLifeShortConnCnt(116, 4),
        smf119ssSaInitActiveConnCnt(120, 4),
        smf119ssSaInitLifeInBytes(124, 8),
        smf119ssSaInitLifeOutBytes(132, 8),
        smf119ssSaInitLifeInSegDG(140, 8),
        smf119ssSaInitLifeOutSegDG(148, 8),
        smf119ssSaEndLifeConnCnt(156, 4),
        smf119ssSaEndLifePartialConnCnt(160, 4),
        smf119ssSaEndLifeShortConnCnt(164, 4),
        smf119ssSaEndActiveConnCnt(168, 4),
        smf119ssSaEndLifeInBytes(172, 8),
        smf119ssSaEndLifeOutBytes(180, 8),
        smf119ssSaEndLifeInSegDG(188, 8),
        smf119ssSaEndLifeOutSegDG(196, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

