/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.IPSecAuthMethod;
import com.blackhillsoftware.smf.smf119.zert.IPSecAuthProto;
import com.blackhillsoftware.smf.smf119.zert.IPSecDHGroup;
import com.blackhillsoftware.smf.smf119.zert.IPSecEncapsulationMode;
import com.blackhillsoftware.smf.smf119.zert.IPSecPseudoRandFunc;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import java.math.BigInteger;
import java.net.InetAddress;

public final class ZertSummaryIPSecSection
extends SmfData {
    private boolean ipV6 = false;

    private ZertSummaryIPSecSection(byte[] Data2, int offset, int length, boolean ipV6) {
        super(Data2, offset, length);
        this.ipV6 = ipV6;
    }

    public int smf119ssIPSecIkeMajVer() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf119ssIPSecIkeMinVer() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public InetAddress smf119ssIPSecIkeTunLclEndpt() {
        return this.ipV6 ? this.smf119ssIPSecIkeTunLclEpIPv6() : this.smf119ssIPSecIkeTunLclEpIPv4();
    }

    public BigInteger smf119ssIPSecIkeTunLclEndptRawValue() {
        return Util.ConvertBigInteger(this.data, 2, 16);
    }

    private InetAddress smf119ssIPSecIkeTunLclEpIPv4() {
        return Util.ConvertInetV4Address(this.data, 2);
    }

    private BigInteger smf119ssIPSecIkeTunLclEpIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 2, 4);
    }

    private InetAddress smf119ssIPSecIkeTunLclEpIPv6() {
        return Util.ConvertInetV6Address(this.data, 2);
    }

    private BigInteger smf119ssIPSecIkeTunLclEpIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 2, 16);
    }

    public InetAddress smf119ssIPSecIkeTunRmtEndpt() {
        return this.ipV6 ? this.smf119ssIPSecIkeTunRmtEPIPv6() : this.smf119ssIPSecIkeTunRmtEPIPv4();
    }

    public BigInteger smf119ssIPSecIkeTunRmtEndptRawValue() {
        return Util.ConvertBigInteger(this.data, 18, 16);
    }

    private InetAddress smf119ssIPSecIkeTunRmtEPIPv4() {
        return Util.ConvertInetV4Address(this.data, 18);
    }

    private BigInteger smf119ssIPSecIkeTunRmtEPIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 18, 4);
    }

    private InetAddress smf119ssIPSecIkeTunRmtEPIPv6() {
        return Util.ConvertInetV6Address(this.data, 18);
    }

    private BigInteger smf119ssIPSecIkeTunRmtEPIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 18, 16);
    }

    public IPSecAuthMethod smf119ssIPSecIkeTunLclAuthMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 34);
        return IPSecAuthMethod.from(value);
    }

    public int smf119ssIPSecIkeTunLclAuthMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public IPSecAuthMethod smf119ssIPSecIkeTunRmtAuthMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 36);
        return IPSecAuthMethod.from(value);
    }

    public int smf119ssIPSecIkeTunRmtAuthMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public MessageAuthAlgorithm smf119ssIPSecIkeTunAuthAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 38);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119ssIPSecIkeTunAuthAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public EncryptionAlgorithm smf119ssIPSecIkeTunEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 40);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119ssIPSecIkeTunEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public IPSecDHGroup smf119ssIPSecIkeTunDHGroup() {
        int value = Util.ConvertUnsignedBinary2(this.data, 42);
        return IPSecDHGroup.from(value);
    }

    public int smf119ssIPSecIkeTunDHGroupRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public IPSecPseudoRandFunc smf119ssIPSecIkeTunPseudoRandFunc() {
        int value = Util.ConvertUnsignedBinary2(this.data, 44);
        return IPSecPseudoRandFunc.from(value);
    }

    public int smf119ssIPSecIkeTunPseudoRandFuncRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public SignatureMethod smf119ssIPSecLclCertSignMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 46);
        return SignatureMethod.from(value);
    }

    public int smf119ssIPSecLclCertSignMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public CertEncryptionMethod smf119ssIPSecLclCertEncMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 48);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssIPSecLclCertEncMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public CertDigestAlgorithm smf119ssIPSecLclCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 50);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssIPSecLclCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public KeyType smf119ssIPSecLclCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 52);
        return KeyType.from(value);
    }

    public int smf119ssIPSecLclCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf119ssIPSecLclCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public SignatureMethod smf119ssIPSecRmtCertSignMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 56);
        return SignatureMethod.from(value);
    }

    public int smf119ssIPSecRmtCertSignMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public CertEncryptionMethod smf119ssIPSecRmtCertEncMeth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 58);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssIPSecRmtCertEncMethRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public CertDigestAlgorithm smf119ssIPSecRmtCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 60);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssIPSecRmtCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public KeyType smf119ssIPSecRmtCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 62);
        return KeyType.from(value);
    }

    public int smf119ssIPSecRmtCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int smf119ssIPSecRmtCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public IPSecDHGroup smf119ssIPSecPfsGroup() {
        int value = Util.ConvertUnsignedBinary2(this.data, 66);
        return IPSecDHGroup.from(value);
    }

    public int smf119ssIPSecPfsGroupRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public IPSecEncapsulationMode smf119ssIPSecEncapMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 68);
        return IPSecEncapsulationMode.from(value);
    }

    public int smf119ssIPSecEncapModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public IPSecAuthProto smf119ssIPSecAuthProto() {
        int value = Util.ConvertUnsignedBinary1(this.data, 69);
        return IPSecAuthProto.from(value);
    }

    public int smf119ssIPSecAuthProtoRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 69);
    }

    public MessageAuthAlgorithm smf119ssIPSecAuthAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 70);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119ssIPSecAuthAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public EncryptionAlgorithm smf119ssIPSecEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 72);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119ssIPSecEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public static ZertSummaryIPSecSection create(byte[] Data2, int offset, int length, boolean ipV6) {
        return new ZertSummaryIPSecSection(Data2, offset, length, ipV6);
    }

    static enum Field {
        smf119ssIPSecIkeMajVer(0, 1),
        smf119ssIPSecIkeMinVer(1, 1),
        smf119ssIPSecIkeTunLclEndpt(2, 16),
        smf119ssIPSecIkeTunLclEpIPv4(2, 4),
        smf119ssIPSecIkeTunLclEpIPv6(2, 16),
        smf119ssIPSecIkeTunRmtEndpt(18, 16),
        smf119ssIPSecIkeTunRmtEPIPv4(18, 4),
        smf119ssIPSecIkeTunRmtEPIPv6(18, 16),
        smf119ssIPSecIkeTunLclAuthMeth(34, 2),
        smf119ssIPSecIkeTunRmtAuthMeth(36, 2),
        smf119ssIPSecIkeTunAuthAlg(38, 2),
        smf119ssIPSecIkeTunEncAlg(40, 2),
        smf119ssIPSecIkeTunDHGroup(42, 2),
        smf119ssIPSecIkeTunPseudoRandFunc(44, 2),
        smf119ssIPSecLclCertSignMeth(46, 2),
        smf119ssIPSecLclCertEncMeth(48, 2),
        smf119ssIPSecLclCertDigestAlg(50, 2),
        smf119ssIPSecLclCertKeyType(52, 2),
        smf119ssIPSecLclCertKeyLen(54, 2),
        smf119ssIPSecRmtCertSignMeth(56, 2),
        smf119ssIPSecRmtCertEncMeth(58, 2),
        smf119ssIPSecRmtCertDigestAlg(60, 2),
        smf119ssIPSecRmtCertKeyType(62, 2),
        smf119ssIPSecRmtCertKeyLen(64, 2),
        smf119ssIPSecPfsGroup(66, 2),
        smf119ssIPSecEncapMode(68, 2),
        smf119ssIPSecAuthProto(69, 1),
        smf119ssIPSecAuthAlg(70, 2),
        smf119ssIPSecEncAlg(72, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

