/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum DnType {
    IPSec_LCL_SDN(1),
    IPSec_LCL_IDN(2),
    IPSec_RMT_SDN(3),
    IPSec_RMT_IDN(4),
    TLS_SRV_SDN(5),
    TLS_SRV_IDN(6),
    TLS_CLI_SDN(7),
    TLS_CLI_IDN(8),
    SSH_SRV_SDN(9),
    SSH_SRV_IDN(10),
    SSH_CLI_SDN(11),
    SSH_CLI_IDN(12),
    NOT_DEFINED(-16);

    private static Map<Integer, DnType> valueMap;
    private final int dntype;

    private DnType(int dntype) {
        this.dntype = dntype;
    }

    public static DnType from(int value) {
        DnType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int dntype() {
        return this.dntype;
    }

    static {
        valueMap = new HashMap<Integer, DnType>();
        for (DnType x : DnType.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.dntype, x);
        }
    }
}

