/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum TLSKexAlgorithm {
    UNKNOWN(0),
    NONE(1),
    RSA(2),
    RSA_EXPORT(3),
    RSA_PSK(4),
    DH_RSA(5),
    DH_RSA_EXPORT(6),
    DH_DSS(7),
    DH_ANON(8),
    DH_ANON_EXPORT(9),
    DH_DSS_EXPORT(10),
    DHE_RSA(11),
    DHE_RSA_EXPORT(12),
    DHE_DSS(13),
    DHE_DSS_EXPORT(14),
    DHE_PSK(15),
    ECDH_ECDSA(16),
    ECDH_RSA(17),
    ECDH_ANON(18),
    ECDHE_ECDSA(19),
    ECDHE_RSA(20),
    ECDHE_PSK(21),
    KRB5(22),
    KRB5_EXPORT(23),
    PSK(24),
    SRP_SHA_RSA(25),
    SRP_SHA_DSS(26),
    SRP_SHA(27),
    ECDHE(28),
    DHE(29),
    NOT_DEFINED(-16);

    private static Map<Integer, TLSKexAlgorithm> valueMap;
    private final int tlskexalgorithm;

    private TLSKexAlgorithm(int tlskexalgorithm) {
        this.tlskexalgorithm = tlskexalgorithm;
    }

    public static TLSKexAlgorithm from(int value) {
        TLSKexAlgorithm result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tlskexalgorithm() {
        return this.tlskexalgorithm;
    }

    static {
        valueMap = new HashMap<Integer, TLSKexAlgorithm>();
        for (TLSKexAlgorithm x : TLSKexAlgorithm.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tlskexalgorithm, x);
        }
    }
}

