/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.zert;

import java.util.HashMap;
import java.util.Map;

public enum TLSProtocolVersion {
    UNKNOWN(0),
    SSLV2(512),
    SSLV3(768),
    TLSV1(769),
    TLSV1_1(770),
    TLSV1_2(771),
    TLSV1_3(772),
    NOT_DEFINED(-16);

    private static Map<Integer, TLSProtocolVersion> valueMap;
    private final int tlsprotocolversion;

    private TLSProtocolVersion(int tlsprotocolversion) {
        this.tlsprotocolversion = tlsprotocolversion;
    }

    public static TLSProtocolVersion from(int value) {
        TLSProtocolVersion result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tlsprotocolversion() {
        return this.tlsprotocolversion;
    }

    static {
        valueMap = new HashMap<Integer, TLSProtocolVersion>();
        for (TLSProtocolVersion x : TLSProtocolVersion.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tlsprotocolversion, x);
        }
    }
}

