/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf14.CompressionType;
import com.blackhillsoftware.smf.smf14.ExtendedInformationSegment;
import java.math.BigInteger;

public final class CompressedFormatDatasetSection
extends ExtendedInformationSegment {
    public static final int SMF14LBD = 128;
    public static final int SMF14CRJ = 64;
    public static final int SMF14ZEDCNAC = 32;
    public static final int SMF14ZEDCNAD = 16;
    public static final int SMF14T36 = 36;

    private CompressedFormatDatasetSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf14xf1() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf14lbd() {
        return Util.ConvertFlag(this.data, this.smf14xf1(), 128);
    }

    public boolean smf14crj() {
        return Util.ConvertFlag(this.data, this.smf14xf1(), 64);
    }

    public boolean smf14zedcnac() {
        return Util.ConvertFlag(this.data, this.smf14xf1(), 32);
    }

    public boolean smf14zedcnad() {
        return Util.ConvertFlag(this.data, this.smf14xf1(), 16);
    }

    public int smf14xf2() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public long smf14cdl() {
        return Util.ConvertUnsignedBinary8(this.data, 2);
    }

    public BigInteger smf14cdlAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 2);
    }

    public long smf14udl() {
        return Util.ConvertUnsignedBinary8(this.data, 10);
    }

    public BigInteger smf14udlAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 10);
    }

    public long smf14cds() {
        return Util.ConvertUnsignedBinary8(this.data, 18);
    }

    public BigInteger smf14cdsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 18);
    }

    public long smf14uds() {
        return Util.ConvertUnsignedBinary8(this.data, 26);
    }

    public BigInteger smf14udsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 26);
    }

    public long smf14cis() {
        return Util.ConvertUnsignedBinary4(this.data, 34);
    }

    public int smf14tkl() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public byte[] smf14tkn() {
        if (this.data.length >= 76) {
            byte[] result = new byte[36];
            System.arraycopy(this.data, 40, result, 0, 36);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(40) + " Data length: " + Integer.toString(36));
    }

    public CompressionType smf14cmptype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 76);
        return CompressionType.from(value);
    }

    public int smf14cmptypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 76);
    }

    public static CompressedFormatDatasetSection create(byte[] Data2, int offset, int length) {
        return new CompressedFormatDatasetSection(Data2, offset, length);
    }

    static enum Field {
        smf14xf1(0, 1),
        smf14xf2(1, 1),
        smf14cdl(2, 8),
        smf14udl(10, 8),
        smf14cds(18, 8),
        smf14uds(26, 8),
        smf14cis(34, 4),
        smf14tkl(38, 2),
        smf14tkn(40, 36),
        smf14cmptype(76, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

