/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class TapeEncryptionData
extends SmfData {
    private TapeEncryptionData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf14kl1() {
        return Util.ConvertEbcdic(this.data, 0, 64);
    }

    public String smf14cd1() {
        return Util.ConvertEbcdic(this.data, 64, 1);
    }

    public String smf14kl2() {
        return Util.ConvertEbcdic(this.data, 65, 64);
    }

    public String smf14cd2() {
        return Util.ConvertEbcdic(this.data, 129, 1);
    }

    public Duration smf14ket() {
        return Util.Binary4x100S(this.data, 130);
    }

    public double smf14ketSeconds() {
        return Util.ToSeconds(this.smf14ket());
    }

    public long smf14ketRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 130);
    }

    public static TapeEncryptionData create(byte[] Data2, int offset, int length) {
        return new TapeEncryptionData(Data2, offset, length);
    }

    static enum Field {
        smf14kl1(0, 64),
        smf14cd1(64, 1),
        smf14kl2(65, 64),
        smf14cd2(129, 1),
        smf14ket(130, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

