/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf14;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class UcbSection
extends SmfData {
    public static final int UCB1FEA0 = 128;
    public static final int UCB1FEA1 = 64;
    public static final int UCB1FEA2 = 32;
    public static final int UCB1FEA3 = 16;
    public static final int UCB1FEA4 = 8;
    public static final int UCB1FEA5 = 4;
    public static final int UCB1FEA6 = 2;
    public static final int UCB1FEA7 = 1;
    public static final int UCB2OPT0 = 128;
    public static final int UCB2OPT1 = 64;
    public static final int UCB2OPT2 = 32;
    public static final int UCB2OPT3 = 16;
    public static final int UCB2OPT4 = 8;
    public static final int UCB2OPT5 = 4;
    public static final int UCB2OPT6 = 2;
    public static final int UCB2OPT7 = 1;
    public static final int UCB3TAPE = 128;
    public static final int UCB3COMM = 64;
    public static final int UCB3CTC = 65;
    public static final int UCB3DACC = 32;
    public static final int UCB3DISP = 16;
    public static final int UCB3UREC = 8;
    public static final int UCB3CHAR = 4;

    private UcbSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smfucbdv() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smfucbch() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smfucbua() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public String smfsrtev() {
        return Util.ConvertEbcdic(this.data, 2, 6);
    }

    public long smfucbty() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public int ucbtbyt1() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset);
    }

    public boolean ucb1fea0() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 128);
    }

    public boolean ucb1fea1() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 64);
    }

    public boolean ucb1fea2() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 32);
    }

    public boolean ucb1fea3() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 16);
    }

    public boolean ucb1fea4() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 8);
    }

    public boolean ucb1fea5() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 4);
    }

    public boolean ucb1fea6() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 2);
    }

    public boolean ucb1fea7() {
        return Util.ConvertFlag(this.data, this.ucbtbyt1(), 1);
    }

    public int ucbtbyt2() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset + 1);
    }

    public boolean ucb2opt0() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 128);
    }

    public boolean ucb2opt1() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 64);
    }

    public boolean ucb2opt2() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 32);
    }

    public boolean ucb2opt3() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 16);
    }

    public boolean ucb2opt4() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 8);
    }

    public boolean ucb2opt5() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 4);
    }

    public boolean ucb2opt6() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 2);
    }

    public boolean ucb2opt7() {
        return Util.ConvertFlag(this.data, this.ucbtbyt2(), 1);
    }

    public int ucbdvcls() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset + 2);
    }

    public int ucbtbyt3() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset + 2);
    }

    public boolean ucb3tape() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 128);
    }

    public boolean ucb3comm() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 64);
    }

    public boolean ucb3ctc() {
        return Util.ConvertEquateValue(this.data, this.ucbdvcls(), 65);
    }

    public boolean ucb3dacc() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 32);
    }

    public boolean ucb3disp() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 16);
    }

    public boolean ucb3urec() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 8);
    }

    public boolean ucb3char() {
        return Util.ConvertFlag(this.data, this.ucbdvcls(), 4);
    }

    public int ucbuntyp() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset + 3);
    }

    public int ucbtbyt4() {
        return Util.ConvertUnsignedBinary1(this.data, Field.smfucbty.offset + 3);
    }

    public int smfsrtes() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public int smf14nex() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public long smfexcp() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public int smfsrtef() {
        if (!this.ucb3tape()) {
            throw new NotAvailableException("This method is only supported when ucb3tape() == true ");
        }
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int smfsrteq() {
        if (!this.ucb3tape()) {
            throw new NotAvailableException("This method is only supported when ucb3tape() == true ");
        }
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf14nta() {
        if (!this.ucb3dacc()) {
            throw new NotAvailableException("This method is only supported when ucb3dacc() == true");
        }
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public static UcbSection create(byte[] Data2, int offset, int length) {
        return new UcbSection(Data2, offset, length);
    }

    static enum Field {
        smfucbdv(0, 2),
        smfucbch(0, 1),
        smfucbua(1, 1),
        smfsrtev(2, 6),
        smfucbty(8, 4),
        smfsrtes(12, 1),
        smf14nex(13, 1),
        smfexcp(16, 4),
        smfsrtef(20, 2),
        smfsrteq(22, 2),
        smf14nta(20, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

