/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;

public final class DataSection
extends SmfData {
    public static final int ICERCTF = 0;
    public static final int ICERCTV = 32;
    public static final int ICERCTVS = 64;
    public static final int ICEBLKST = 0;
    public static final int ICEPEER = 8;
    public static final int ICEVALE = 16;
    public static final int ICECONV = 24;
    public static final int ICEVOKED = 4;
    public static final int ICEINMEM = 2;
    public static final int ICESORT = 128;
    public static final int ICEMERG = 64;
    public static final int ICECOPY = 32;
    public static final int ICETOOL = 16;
    public static final int ICEAUTH = 8;
    public static final int ICEMOWRK = 4;
    public static final int ICEJOIN1 = 2;
    public static final int ICEJOIN2 = 1;
    public static final int ICEIOE15 = 128;
    public static final int ICEIOE32 = 64;
    public static final int ICEIOE35 = 32;
    public static final int ICEIOSIN = 16;
    public static final int ICEIOINN = 8;
    public static final int ICEIOOUT = 4;
    public static final int ICEIOOFL = 2;
    public static final int ICECSALT = 128;
    public static final int ICECSINR = 64;
    public static final int ICECSINC = 32;
    public static final int ICECSOMI = 16;
    public static final int ICECSORC = 8;
    public static final int ICECSSUM = 4;
    public static final int ICECSOFL = 2;
    public static final int ICEJOINM = 1;
    public static final int ICESYSAB = 128;
    public static final int ICEUSRAB = 64;
    public static final int ICEUABND = 8;
    public static final int ICERC16 = 4;
    public static final int ICERC20 = 2;
    public static final int ICEHSSRT = 128;
    public static final int ICEDSSRT = 64;
    public static final int ICEWDS = 32;
    public static final int ICELSSM = 16;
    public static final int ICELSIO = 8;
    public static final int ICEQUALS = 4;
    public static final int ICEBLK31 = 2;
    public static final int ICEMOSRT = 1;
    public static final int ICEWKDYN = 128;
    public static final int ICEWKCW = 64;
    public static final int ICEUCSM = 128;
    public static final int ICEUCIO = 64;
    public static final int ICEIEXCP = 128;
    public static final int ICEIVSAM = 64;
    public static final int ICEIBSAM = 32;
    public static final int ICEOEXCP = 128;
    public static final int ICEOVSAM = 64;
    public static final int ICEOBSAM = 32;
    public static final int ICEFSZN = 128;
    public static final int ICEFSZEN = 64;
    public static final int ICEFSZUN = 32;
    public static final int ICEFSZNO = 16;
    public static final int ICESZMAX = 128;
    public static final int ICEZSRTF = 128;

    private DataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String icestpnm() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public long icercds() {
        return Util.ConvertUnsignedBinary4(this.data, 10);
    }

    public long icebytes() {
        return Util.ConvertUnsignedBinary4(this.data, 14);
    }

    public Duration icecput() {
        return Util.Binary4x100S(this.data, 18);
    }

    public double icecputSeconds() {
        return Util.ToSeconds(this.icecput());
    }

    public long icecputRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 18);
    }

    public int icelen() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int iceiblk() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int iceoblk() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int icekeyln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public long icewblk() {
        return Util.ConvertUnsignedBinary4(this.data, 30);
    }

    public int iceflbyt() {
        return Util.ConvertUnsignedBinary1(this.data, 34);
    }

    public boolean icerctf() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 0, 96);
    }

    public boolean icerctv() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 32, 96);
    }

    public boolean icerctvs() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 64, 96);
    }

    public boolean iceblkst() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 0, 24);
    }

    public boolean icepeer() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 8, 24);
    }

    public boolean icevale() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 16, 24);
    }

    public boolean iceconv() {
        return Util.ConvertEquateValue(this.data, this.iceflbyt(), 24, 24);
    }

    public boolean icevoked() {
        return Util.ConvertFlag(this.data, this.iceflbyt(), 4);
    }

    public boolean iceinmem() {
        return Util.ConvertFlag(this.data, this.iceflbyt(), 2);
    }

    public int icendyna() {
        return Util.ConvertUnsignedBinary1(this.data, 35);
    }

    public int iceflby2() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    public boolean icesort() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 128);
    }

    public boolean icemerg() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 64);
    }

    public boolean icecopy() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 32);
    }

    public boolean icetool() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 16);
    }

    public boolean iceauth() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 8);
    }

    public boolean icemowrk() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 4);
    }

    public boolean icejoin1() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 2);
    }

    public boolean icejoin2() {
        return Util.ConvertFlag(this.data, this.iceflby2(), 1);
    }

    public int iceiotyp() {
        return Util.ConvertUnsignedBinary1(this.data, 37);
    }

    public boolean iceioe15() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 128);
    }

    public boolean iceioe32() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 64);
    }

    public boolean iceioe35() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 32);
    }

    public boolean iceiosin() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 16);
    }

    public boolean iceioinn() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 8);
    }

    public boolean iceioout() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 4);
    }

    public boolean iceioofl() {
        return Util.ConvertFlag(this.data, this.iceiotyp(), 2);
    }

    public int icecsflg() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public boolean icecsalt() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 128);
    }

    public boolean icecsinr() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 64);
    }

    public boolean icecsinc() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 32);
    }

    public boolean icecsomi() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 16);
    }

    public boolean icecsorc() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 8);
    }

    public boolean icecssum() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 4);
    }

    public boolean icecsofl() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 2);
    }

    public boolean icejoinm() {
        return Util.ConvertFlag(this.data, this.icecsflg(), 1);
    }

    public LocalTime icetimes() {
        return Util.Binary4x100STime(this.data, 40);
    }

    public long icetimesRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public LocalDate icedates() {
        return Util.SMFDate(this.data, 44);
    }

    public int icedatesRawValue() {
        return Util.ConvertPacked4(this.data, 44);
    }

    public LocalTime icetimee() {
        return Util.Binary4x100STime(this.data, 48);
    }

    public long icetimeeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public LocalDate icedatee() {
        return Util.SMFDate(this.data, 52);
    }

    public int icedateeRawValue() {
        return Util.ConvertPacked4(this.data, 52);
    }

    public int icercbyt() {
        return Util.ConvertUnsignedBinary1(this.data, 56);
    }

    public boolean icesysab() {
        return Util.ConvertFlag(this.data, this.icercbyt(), 128);
    }

    public boolean iceusrab() {
        return Util.ConvertFlag(this.data, this.icercbyt(), 64);
    }

    public boolean iceuabnd() {
        return Util.ConvertFlag(this.data, this.icercbyt(), 8);
    }

    public boolean icerc16() {
        return Util.ConvertFlag(this.data, this.icercbyt(), 4);
    }

    public boolean icerc20() {
        return Util.ConvertFlag(this.data, this.icercbyt(), 2);
    }

    public int icerc() {
        return Util.ConvertUnsignedBinary1(this.data, 57);
    }

    public int iceresn() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public long iceavlr() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public int icedsa() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int iceflby3() {
        return Util.ConvertUnsignedBinary1(this.data, 66);
    }

    public boolean icehssrt() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 128);
    }

    public boolean icedssrt() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 64);
    }

    public boolean icewds() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 32);
    }

    public boolean icelssm() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 16);
    }

    public boolean icelsio() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 8);
    }

    public boolean icequals() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 4);
    }

    public boolean iceblk31() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 2);
    }

    public boolean icemosrt() {
        return Util.ConvertFlag(this.data, this.iceflby3(), 1);
    }

    public int icewkflg() {
        return Util.ConvertUnsignedBinary1(this.data, 67);
    }

    public boolean icewkdyn() {
        return Util.ConvertFlag(this.data, this.icewkflg(), 128);
    }

    public boolean icewkcw() {
        return Util.ConvertFlag(this.data, this.icewkflg(), 64);
    }

    public int icewexs() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int icewexe() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public long icewalls() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long icewalle() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public int iceflby4() {
        return Util.ConvertUnsignedBinary1(this.data, 82);
    }

    public boolean iceucsm() {
        return Util.ConvertFlag(this.data, this.iceflby4(), 128);
    }

    public boolean iceucio() {
        return Util.ConvertFlag(this.data, this.iceflby4(), 64);
    }

    public int iceiamb() {
        return Util.ConvertUnsignedBinary1(this.data, 83);
    }

    public boolean iceiexcp() {
        return Util.ConvertFlag(this.data, this.iceiamb(), 128);
    }

    public boolean iceivsam() {
        return Util.ConvertFlag(this.data, this.iceiamb(), 64);
    }

    public boolean iceibsam() {
        return Util.ConvertFlag(this.data, this.iceiamb(), 32);
    }

    public long iceinio() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public int iceoamb() {
        return Util.ConvertUnsignedBinary1(this.data, 91);
    }

    public boolean iceoexcp() {
        return Util.ConvertFlag(this.data, this.iceoamb(), 128);
    }

    public boolean iceovsam() {
        return Util.ConvertFlag(this.data, this.iceoamb(), 64);
    }

    public boolean iceobsam() {
        return Util.ConvertFlag(this.data, this.iceoamb(), 32);
    }

    public long iceoutio() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long iceiblkf() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long icewkio() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration icesrbts() {
        return Util.Binary4x100S(this.data, 104);
    }

    public double icesrbtsSeconds() {
        return Util.ToSeconds(this.icesrbts());
    }

    public long icesrbtsRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration icesrbte() {
        return Util.Binary4x100S(this.data, 108);
    }

    public double icesrbteSeconds() {
        return Util.ToSeconds(this.icesrbte());
    }

    public long icesrbteRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public int icetcbs() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public int icekeynm() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public int icehspmx() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public int icedspsz() {
        return Util.ConvertUnsignedBinary2(this.data, 118);
    }

    public long iceexrcs() {
        return Util.ConvertUnsignedBinary8(this.data, 120);
    }

    public BigInteger iceexrcsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public long iceexbys() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger iceexbysAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long iceexinn() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger iceexinnAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long iceexout() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger iceexoutAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public int icehspn() {
        return Util.ConvertUnsignedBinary2(this.data, 152);
    }

    public long icehspu() {
        return Util.ConvertUnsignedBinary4(this.data, 154);
    }

    public int icedspn() {
        return Util.ConvertUnsignedBinary2(this.data, 158);
    }

    public long icedspu() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public String iceprcnm() {
        return Util.ConvertEbcdic(this.data, 164, 8);
    }

    public String iceidsnm() {
        return Util.ConvertEbcdic(this.data, 172, 44);
    }

    public String iceivols() {
        return Util.ConvertEbcdic(this.data, 216, 6);
    }

    public String iceodsnm() {
        return Util.ConvertEbcdic(this.data, 222, 44);
    }

    public String iceovols() {
        return Util.ConvertEbcdic(this.data, 266, 6);
    }

    public int iceinpds() {
        return Util.ConvertUnsignedBinary2(this.data, 272);
    }

    public int iceinnds() {
        return Util.ConvertUnsignedBinary2(this.data, 274);
    }

    public int iceoutds() {
        return Util.ConvertUnsignedBinary2(this.data, 276);
    }

    public int iceoflds() {
        return Util.ConvertUnsignedBinary2(this.data, 278);
    }

    public long icercinp() {
        return Util.ConvertUnsignedBinary8(this.data, 280);
    }

    public BigInteger icercinpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 280);
    }

    public long icercout() {
        return Util.ConvertUnsignedBinary8(this.data, 288);
    }

    public BigInteger icercoutAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public long icercins() {
        return Util.ConvertUnsignedBinary8(this.data, 296);
    }

    public BigInteger icercinsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public long icercdel() {
        return Util.ConvertUnsignedBinary8(this.data, 304);
    }

    public BigInteger icercdelAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public String icemd15n() {
        return Util.ConvertEbcdic(this.data, 312, 8);
    }

    public long icemd15m() {
        return Util.ConvertUnsignedBinary4(this.data, 320);
    }

    public String icemd15s() {
        return Util.ConvertEbcdic(this.data, 324, 8);
    }

    public String icemd15e() {
        return Util.ConvertEbcdic(this.data, 332, 1);
    }

    public String icemd35n() {
        return Util.ConvertEbcdic(this.data, 336, 8);
    }

    public long icemd35m() {
        return Util.ConvertUnsignedBinary4(this.data, 344);
    }

    public String icemd35s() {
        return Util.ConvertEbcdic(this.data, 348, 8);
    }

    public String icemd35e() {
        return Util.ConvertEbcdic(this.data, 356, 1);
    }

    public String icelcale() {
        return Util.ConvertEbcdic(this.data, 360, 32);
    }

    public long iceesmax() {
        return Util.ConvertUnsignedBinary4(this.data, 392);
    }

    public long iceesold() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long iceesres() {
        return Util.ConvertUnsignedBinary4(this.data, 400);
    }

    public long iceoblkf() {
        return Util.ConvertUnsignedBinary4(this.data, 404);
    }

    public long icefilsz() {
        return Util.ConvertUnsignedBinary8(this.data, 408);
    }

    public BigInteger icefilszAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 408);
    }

    public long iceavgrl() {
        return Util.ConvertUnsignedBinary4(this.data, 416);
    }

    public int icefszfl() {
        return Util.ConvertUnsignedBinary1(this.data, 420);
    }

    public boolean icefszn() {
        return Util.ConvertFlag(this.data, this.icefszfl(), 128);
    }

    public boolean icefszen() {
        return Util.ConvertFlag(this.data, this.icefszfl(), 64);
    }

    public boolean icefszun() {
        return Util.ConvertFlag(this.data, this.icefszfl(), 32);
    }

    public boolean icefszno() {
        return Util.ConvertFlag(this.data, this.icefszfl(), 16);
    }

    public long icemosiz() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public int icemon() {
        return Util.ConvertUnsignedBinary2(this.data, 438);
    }

    public long icemouse() {
        return Util.ConvertUnsignedBinary8(this.data, 440);
    }

    public BigInteger icemouseAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 440);
    }

    public long icemnvlx() {
        return Util.ConvertUnsignedBinary4(this.data, 448);
    }

    public long icemnvly() {
        return Util.ConvertUnsignedBinary4(this.data, 452);
    }

    public long icemnvlz() {
        return Util.ConvertUnsignedBinary4(this.data, 456);
    }

    public int icemnflg() {
        return Util.ConvertUnsignedBinary1(this.data, 460);
    }

    public boolean iceszmax() {
        return Util.ConvertFlag(this.data, this.icemnflg(), 128);
    }

    public int iceinmrg() {
        return Util.ConvertUnsignedBinary2(this.data, 462);
    }

    public Duration icecpuze() {
        return Util.Binary2x100S(this.data, 464);
    }

    public double icecpuzeSeconds() {
        return Util.ToSeconds(this.icecpuze());
    }

    public long icecpuzeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 464);
    }

    public Duration icecpuzp() {
        return Util.Binary2x100S(this.data, 468);
    }

    public double icecpuzpSeconds() {
        return Util.ToSeconds(this.icecpuzp());
    }

    public long icecpuzpRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 468);
    }

    public String icetune() {
        return Util.ConvertEbcdic(this.data, 472, 1);
    }

    public long icedyinc() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public long icedymax() {
        return Util.ConvertUnsignedBinary4(this.data, 480);
    }

    public long icedyold() {
        return Util.ConvertUnsignedBinary4(this.data, 484);
    }

    public long icedyres() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public String icecollk() {
        return Util.ConvertEbcdic(this.data, 496, 64);
    }

    public Duration icetcbt() {
        return Util.Binary4x100S(this.data, 568);
    }

    public double icetcbtSeconds() {
        return Util.ToSeconds(this.icetcbt());
    }

    public long icetcbtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 568);
    }

    public int iceflby5() {
        return Util.ConvertUnsignedBinary1(this.data, 572);
    }

    public boolean icezsrtf() {
        return Util.ConvertFlag(this.data, this.iceflby5(), 128);
    }

    public int icezsrnu() {
        return Util.ConvertUnsignedBinary1(this.data, 573);
    }

    public static DataSection create(byte[] Data2, int offset, int length) {
        return new DataSection(Data2, offset, length);
    }

    static enum Field {
        icestpnm(2, 8),
        icercds(10, 4),
        icebytes(14, 4),
        icecput(18, 4),
        icelen(22, 2),
        iceiblk(24, 2),
        iceoblk(26, 2),
        icekeyln(28, 2),
        icewblk(30, 4),
        iceflbyt(34, 1),
        icendyna(35, 1),
        iceflby2(36, 1),
        iceiotyp(37, 1),
        icecsflg(38, 1),
        icetimes(40, 4),
        icedates(44, 4),
        icetimee(48, 4),
        icedatee(52, 4),
        icercbyt(56, 1),
        icerc(57, 1),
        iceresn(58, 2),
        iceavlr(60, 4),
        icedsa(64, 2),
        iceflby3(66, 1),
        icewkflg(67, 1),
        icewexs(68, 2),
        icewexe(70, 2),
        icewalls(72, 4),
        icewalle(76, 4),
        iceflby4(82, 1),
        iceiamb(83, 1),
        iceinio(84, 4),
        iceoamb(91, 1),
        iceoutio(92, 4),
        iceiblkf(96, 4),
        icewkio(100, 4),
        icesrbts(104, 4),
        icesrbte(108, 4),
        icetcbs(112, 2),
        icekeynm(114, 2),
        icehspmx(116, 2),
        icedspsz(118, 2),
        iceexrcs(120, 8),
        iceexbys(128, 8),
        iceexinn(136, 8),
        iceexout(144, 8),
        icehspn(152, 2),
        icehspu(154, 4),
        icedspn(158, 2),
        icedspu(160, 4),
        iceprcnm(164, 8),
        iceidsnm(172, 44),
        iceivols(216, 6),
        iceodsnm(222, 44),
        iceovols(266, 6),
        iceinpds(272, 2),
        iceinnds(274, 2),
        iceoutds(276, 2),
        iceoflds(278, 2),
        icercinp(280, 8),
        icercout(288, 8),
        icercins(296, 8),
        icercdel(304, 8),
        icemd15n(312, 8),
        icemd15m(320, 4),
        icemd15s(324, 8),
        icemd15e(332, 1),
        icemd35n(336, 8),
        icemd35m(344, 4),
        icemd35s(348, 8),
        icemd35e(356, 1),
        icelcale(360, 32),
        iceesmax(392, 4),
        iceesold(396, 4),
        iceesres(400, 4),
        iceoblkf(404, 4),
        icefilsz(408, 8),
        iceavgrl(416, 4),
        icefszfl(420, 1),
        icemosiz(432, 4),
        icemon(438, 2),
        icemouse(440, 8),
        icemnvlx(448, 4),
        icemnvly(452, 4),
        icemnvlz(456, 4),
        icemnflg(460, 1),
        iceinmrg(462, 2),
        icecpuze(464, 2),
        icecpuzp(468, 2),
        icetune(472, 1),
        icedyinc(476, 4),
        icedymax(480, 4),
        icedyold(484, 4),
        icedyres(488, 4),
        icecollk(496, 64),
        icetcbt(568, 4),
        iceflby5(572, 1),
        icezsrnu(573, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

