/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf17;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf17.Volume;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public final class Smf17Record
extends SmfRecord {
    public static final int SMF17LNV = 8;

    public Smf17Record(byte[] data) {
        super(data);
        if (this.recordType() != 17) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf17Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 17) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf17Record from(SmfRecord record) {
        return new Smf17Record(record);
    }

    public static Smf17Record from(byte[] data) {
        return new Smf17Record(data);
    }

    public List<Volume> volumes() {
        ArrayList<Volume> result = new ArrayList<Volume>();
        for (int i = 0; i < this.smf17nvl(); ++i) {
            result.add(Volume.create(this.data, Field.smf17nvl.offset() + Field.smf17nvl.length() + i * 8, 8));
        }
        return result;
    }

    public int smf17len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf17seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf17flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf17rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf17tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf17tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf17dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf17dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf17sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf17jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf17rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf17rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf17rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf17rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf17uid() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int smf17rin() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public String smf17dsn() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public int smf17nvl() {
        return Util.ConvertUnsignedBinary1(this.data, 91);
    }

    static enum Field {
        smf17len(0, 2),
        smf17seg(2, 2),
        smf17flg(4, 1),
        smf17rty(5, 1),
        smf17tme(6, 4),
        smf17dte(10, 4),
        smf17sid(14, 4),
        smf17jbn(18, 8),
        smf17rst(26, 4),
        smf17rsd(30, 4),
        smf17uid(34, 8),
        smf17rin(42, 2),
        smf17dsn(44, 44),
        smf17nvl(91, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

