/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf2;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf2.GroupAlternateSignature;
import com.blackhillsoftware.smf.smf2.GroupSelfDefiningSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class Smf2GroupRecord
extends SmfRecord {
    private static final int FIRSTGROUP = 128;
    private static final int GROUPHASSUBTYPE = 64;
    private static final int SMF2GRTYPX = 32;
    private static final int OA55526 = 16;
    private static final int SMF2SELFDEFSECTION = 8;
    private static final int SHA1 = 128;
    private static final int SHA256 = 64;
    private static final int SHA384 = 32;
    private static final int SHA512 = 16;
    private static final int RSA = 128;
    private static final int ECDSA = 64;
    private GroupSelfDefiningSection m_selfDefiningSection = null;
    List<GroupAlternateSignature> m_alternateSignatures = null;

    public Smf2GroupRecord(byte[] data) {
        super(data);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf2GroupRecord(SmfRecord record) {
        super(record);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf2GroupRecord from(SmfRecord record) {
        return new Smf2GroupRecord(record);
    }

    public static Smf2GroupRecord from(byte[] data) {
        return new Smf2GroupRecord(data);
    }

    public int smf2glen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf2gseg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf2gflg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf2grty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf2gtme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf2gtmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf2gdte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf2gdteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf2gsid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf2gwid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf2gstp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public String smf2grsid() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public int smf2gflg2() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean firstGroup() {
        return Util.ConvertFlag(this.data, this.smf2gflg2(), 128);
    }

    public boolean groupHasSubtype() {
        return Util.ConvertFlag(this.data, this.smf2gflg2(), 64);
    }

    public boolean typeInSmf2grtypx() {
        return Util.ConvertFlag(this.data, this.smf2gflg2(), 32);
    }

    public boolean hasOA55526() {
        return Util.ConvertFlag(this.data, this.smf2gflg2(), 16);
    }

    public boolean hasSelfDefiningSection() {
        return Util.ConvertFlag(this.data, this.smf2gflg2(), 8);
    }

    public int groupRecordType() {
        return this.typeInSmf2grtypx() ? this.smf2grtypx() : this.smf2grtype();
    }

    @Deprecated
    public int smf2grtype() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public int smf2gstype() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public LocalTime smf2gftme() {
        return Util.Binary4x100STime(this.data, 32);
    }

    public long smf2gftmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public LocalDate smf2gfdte() {
        return Util.SMFDate(this.data, 36);
    }

    public int smf2gfdteRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public long smf2gcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public int smf2ghashmeth() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public boolean smf2ghashmethSha1() {
        return Util.ConvertFlag(this.data, this.smf2ghashmeth(), 128);
    }

    public boolean smf2ghashmethSha256() {
        return Util.ConvertFlag(this.data, this.smf2ghashmeth(), 64);
    }

    public boolean smf2ghashmethSha384() {
        return Util.ConvertFlag(this.data, this.smf2ghashmeth(), 32);
    }

    public boolean smf2ghashmethSha512() {
        return Util.ConvertFlag(this.data, this.smf2ghashmeth(), 16);
    }

    public int smf2gsigtype() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public boolean smf2gsigtypeRsa() {
        return Util.ConvertFlag(this.data, this.smf2gsigtype(), 128);
    }

    public boolean smf2gsigtypeEcdsa() {
        return Util.ConvertFlag(this.data, this.smf2gsigtype(), 64);
    }

    public String smf2gtokenname() {
        return Util.ConvertEbcdic(this.data, 46, 32);
    }

    public int smf2grtypx() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public int smf2gsiglen() {
        return Util.ConvertSignedBinary4(this.data, 80);
    }

    public byte[] smf2gsig() {
        if (this.data.length >= 84 + this.smf2gsiglen()) {
            byte[] result = new byte[this.smf2gsiglen()];
            System.arraycopy(this.data, 84, result, 0, this.smf2gsiglen());
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(84) + " Data length: " + Integer.toString(this.smf2gsiglen()));
    }

    public GroupSelfDefiningSection selfDefiningSection() {
        if (this.m_selfDefiningSection != null || !this.hasSelfDefiningSection()) {
            return this.m_selfDefiningSection;
        }
        int offset = Field.smf2gsig.offset + this.smf2gsiglen();
        int length = GroupSelfDefiningSection.smf2gsdsLen(this.data, offset);
        this.m_selfDefiningSection = GroupSelfDefiningSection.create(this.data, offset, length);
        return this.m_selfDefiningSection;
    }

    public List<GroupAlternateSignature> alternateSignatures() {
        this.m_alternateSignatures = Util.sectionsFromTriplet(this.m_alternateSignatures, this.data, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2gsdsASignOffset() : 0, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2gsdsASignLen() : 0, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2gsdsASignNum() : 0, GroupAlternateSignature::create);
        return this.m_alternateSignatures;
    }

    static enum Field {
        smf2glen(0, 2),
        smf2gseg(2, 2),
        smf2gflg(4, 1),
        smf2grty(5, 1),
        smf2gtme(6, 4),
        smf2gdte(10, 4),
        smf2gsid(14, 4),
        smf2gwid(18, 4),
        smf2gstp(22, 2),
        smf2grsid(24, 4),
        smf2gflg2(28, 1),
        smf2grtype(29, 1),
        smf2gstype(30, 2),
        smf2gftme(32, 4),
        smf2gfdte(36, 4),
        smf2gcnt(40, 4),
        smf2ghashmeth(44, 1),
        smf2gsigtype(45, 1),
        smf2gtokenname(46, 32),
        smf2grtypx(78, 2),
        smf2gsiglen(80, 4),
        smf2gsig(84, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

