/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf2;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf2.IntervalAlternateSignature;
import com.blackhillsoftware.smf.smf2.IntervalSelfDefiningSection;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public final class Smf2IntervalRecord
extends SmfRecord {
    private static final int FIRSTINTERVAL = 128;
    private static final int INTERVALHASSUBTYPE = 64;
    private static final int HALTINTERVAL = 32;
    private static final int NEWINTERVALCRYPTOOPTIONS = 16;
    private static final int SMF2IRTYPX = 8;
    private static final int CLOSEINTERVAL = 4;
    private static final int OA55526 = 2;
    private static final int SMF2SELFDEFSECTION = 1;
    private static final int SHA1 = 128;
    private static final int SHA256 = 64;
    private static final int SHA384 = 32;
    private static final int SHA512 = 16;
    private static final int RSA = 128;
    private static final int ECDSA = 64;
    private IntervalSelfDefiningSection m_selfDefiningSection = null;
    List<IntervalAlternateSignature> m_alternateSignatures = null;

    public Smf2IntervalRecord(byte[] data) {
        super(data);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf2IntervalRecord(SmfRecord record) {
        super(record);
        if (this.recordType() != 2) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf2IntervalRecord from(SmfRecord record) {
        return new Smf2IntervalRecord(record);
    }

    public static Smf2IntervalRecord from(byte[] data) {
        return new Smf2IntervalRecord(data);
    }

    public int smf2ilen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf2iseg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf2iflg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf2irty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf2itme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf2itmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf2idte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf2idteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf2isid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf2iwid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf2istp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public String smf2irsid() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public int smf2iflg2() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean firstInterval() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 128);
    }

    public boolean intervalHasSubtype() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 64);
    }

    public boolean intervalHalt() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 32);
    }

    public boolean intervalNewCryptoOptions() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 16);
    }

    public boolean typeInSmf2irtypx() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 8);
    }

    public boolean intervalClose() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 4);
    }

    public boolean hasOA55526() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 2);
    }

    public boolean hasSelfDefiningSection() {
        return Util.ConvertFlag(this.data, this.smf2iflg2(), 1);
    }

    public int intervalRecordType() {
        return this.typeInSmf2irtypx() ? this.smf2irtypx() : this.smf2irtype();
    }

    @Deprecated
    public int smf2irtype() {
        return Util.ConvertUnsignedBinary1(this.data, 29);
    }

    public int smf2istype() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public LocalTime smf2iftme() {
        return Util.Binary4x100STime(this.data, 32);
    }

    public long smf2iftmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public LocalDate smf2ifdte() {
        return Util.SMFDate(this.data, 36);
    }

    public int smf2ifdteRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public LocalTime smf2iltme() {
        return Util.Binary4x100STime(this.data, 40);
    }

    public long smf2iltmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public LocalDate smf2ildte() {
        return Util.SMFDate(this.data, 44);
    }

    public int smf2ildteRawValue() {
        return Util.ConvertPacked4(this.data, 44);
    }

    public LocalTime smf2intme() {
        return Util.Binary4x100STime(this.data, 48);
    }

    public long smf2intmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public LocalDate smf2indte() {
        return Util.SMFDate(this.data, 52);
    }

    public int smf2indteRawValue() {
        return Util.ConvertPacked4(this.data, 52);
    }

    public long smf2icnt() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public int smf2ihashmeth() {
        return Util.ConvertUnsignedBinary1(this.data, 60);
    }

    public boolean smf2ihashmethSha1() {
        return Util.ConvertFlag(this.data, this.smf2ihashmeth(), 128);
    }

    public boolean smf2ihashmethSha256() {
        return Util.ConvertFlag(this.data, this.smf2ihashmeth(), 64);
    }

    public boolean smf2ihashmethSha384() {
        return Util.ConvertFlag(this.data, this.smf2ihashmeth(), 32);
    }

    public boolean smf2ihashmethSha512() {
        return Util.ConvertFlag(this.data, this.smf2ihashmeth(), 16);
    }

    public int smf2isigtype() {
        return Util.ConvertUnsignedBinary1(this.data, 61);
    }

    public boolean smf2isigtypeRsa() {
        return Util.ConvertFlag(this.data, this.smf2isigtype(), 128);
    }

    public boolean smf2isigtypeEcdsa() {
        return Util.ConvertFlag(this.data, this.smf2isigtype(), 64);
    }

    public String smf2itokenname() {
        return Util.ConvertEbcdic(this.data, 62, 32);
    }

    public int smf2irtypx() {
        return Util.ConvertUnsignedBinary2(this.data, 94);
    }

    public int smf2isiglen() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    public byte[] smf2isig() {
        if (this.data.length >= 100 + this.smf2isiglen()) {
            byte[] result = new byte[this.smf2isiglen()];
            System.arraycopy(this.data, 100, result, 0, this.smf2isiglen());
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(100) + " Data length: " + Integer.toString(this.smf2isiglen()));
    }

    public IntervalSelfDefiningSection selfDefiningSection() {
        if (this.m_selfDefiningSection != null || !this.hasSelfDefiningSection()) {
            return this.m_selfDefiningSection;
        }
        int offset = Field.smf2isig.offset + this.smf2isiglen();
        int length = IntervalSelfDefiningSection.smf2isdsLen(this.data, offset);
        this.m_selfDefiningSection = IntervalSelfDefiningSection.create(this.data, offset, length);
        return this.m_selfDefiningSection;
    }

    public List<IntervalAlternateSignature> alternateSignatures() {
        this.m_alternateSignatures = Util.sectionsFromTriplet(this.m_alternateSignatures, this.data, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2isdsASignOffset() : 0, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2isdsASignLen() : 0, () -> this.hasSelfDefiningSection() ? this.selfDefiningSection().smf2isdsASignNum() : 0, IntervalAlternateSignature::create);
        return this.m_alternateSignatures;
    }

    static enum Field {
        smf2ilen(0, 2),
        smf2iseg(2, 2),
        smf2iflg(4, 1),
        smf2irty(5, 1),
        smf2itme(6, 4),
        smf2idte(10, 4),
        smf2isid(14, 4),
        smf2iwid(18, 4),
        smf2istp(22, 2),
        smf2irsid(24, 4),
        smf2iflg2(28, 1),
        smf2irtype(29, 1),
        smf2istype(30, 2),
        smf2iftme(32, 4),
        smf2ifdte(36, 4),
        smf2iltme(40, 4),
        smf2ildte(44, 4),
        smf2intme(48, 4),
        smf2indte(52, 4),
        smf2icnt(56, 4),
        smf2ihashmeth(60, 1),
        smf2isigtype(61, 1),
        smf2itokenname(62, 32),
        smf2irtypx(94, 2),
        smf2isiglen(96, 4),
        smf2isig(100, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

