/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf21;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf21Record
extends SmfRecord {
    public static final int SMF21DL = 18;
    public static final int SMF21625 = 211;
    public static final int SMF21F62 = 194;
    public static final int SMF21160 = 195;
    public static final int SMF21F16 = 66;
    public static final int SMF21800 = 203;
    public static final int SMF21780 = 131;
    public static final int SMF21556 = 67;
    public static final int SMF21200 = 3;
    public static final int SMF21OUT = 128;
    public static final int SMF21RDB = 64;
    public static final int SMF21NCT = 128;
    public static final int SMF21LS = 64;
    public static final int SMF21LB = 32;
    public static final int SMF21DBV = 16;
    public static final int SMF21MFV = 8;
    public static final int SMF21CBC = 4;

    public Smf21Record(byte[] data) {
        super(data);
        if (this.recordType() != 21) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf21Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 21) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf21Record from(SmfRecord record) {
        return new Smf21Record(record);
    }

    public static Smf21Record from(byte[] data) {
        return new Smf21Record(data);
    }

    public int smf21len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf21seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf21flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf21rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf21tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf21tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf21dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf21dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf21sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf21lgh() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public String smf21vol() {
        return Util.ConvertEbcdic(this.data, 20, 6);
    }

    public int smf21ca() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public long smf21ucb() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public int smf21dev() {
        return Util.ConvertUnsignedBinary1(this.data, 31);
    }

    public int smf21tr() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public int smf21tw() {
        return Util.ConvertUnsignedBinary1(this.data, 33);
    }

    public int smf21sio() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf21pr() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    public int smf21pw() {
        return Util.ConvertUnsignedBinary1(this.data, 37);
    }

    public int smf21nb() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public int smf21erg() {
        return Util.ConvertUnsignedBinary2(this.data, 39);
    }

    public int smf21cln() {
        return Util.ConvertUnsignedBinary2(this.data, 41);
    }

    public int smf21den() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public boolean smf21625() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 211);
    }

    public boolean smf21f62() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 194);
    }

    public boolean smf21160() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 195);
    }

    public boolean smf21f16() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 66);
    }

    public boolean smf21800() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 203);
    }

    public boolean smf21780() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 131);
    }

    public boolean smf21556() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 67);
    }

    public boolean smf21200() {
        return Util.ConvertEquateValue(this.data, this.smf21den(), 3);
    }

    public int smf21bls() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int smf21ofl() {
        return Util.ConvertUnsignedBinary1(this.data, 46);
    }

    public boolean smf21out() {
        return Util.ConvertFlag(this.data, this.smf21ofl(), 128);
    }

    public boolean smf21rdb() {
        return Util.ConvertFlag(this.data, this.smf21ofl(), 64);
    }

    public int smf21tus() {
        return Util.ConvertPacked3(this.data, 47);
    }

    public int smf21trf() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf21trb() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf21twf() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public int smf21br() {
        return Util.ConvertUnsignedBinary3(this.data, 56);
    }

    public int smf21bw() {
        return Util.ConvertUnsignedBinary3(this.data, 59);
    }

    public int smf21fl1() {
        return Util.ConvertUnsignedBinary1(this.data, 62);
    }

    public boolean smf21nct() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 128);
    }

    public boolean smf21ls() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 64);
    }

    public boolean smf21lb() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 32);
    }

    public boolean smf21dbv() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 16);
    }

    public boolean smf21mfv() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 8);
    }

    public boolean smf21cbc() {
        return Util.ConvertFlag(this.data, this.smf21fl1(), 4);
    }

    public int smf21fl2() {
        return Util.ConvertUnsignedBinary1(this.data, 63);
    }

    public long smf21brn() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf21bwn() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf21lst() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf21lbs() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long smf21dbr() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf21dbw() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf21mcr() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf21mcw() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf21mdr() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf21mdw() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    static enum Field {
        smf21len(0, 2),
        smf21seg(2, 2),
        smf21flg(4, 1),
        smf21rty(5, 1),
        smf21tme(6, 4),
        smf21dte(10, 4),
        smf21sid(14, 4),
        smf21lgh(18, 2),
        smf21vol(20, 6),
        smf21ca(26, 2),
        smf21ucb(28, 4),
        smf21dev(31, 1),
        smf21tr(32, 1),
        smf21tw(33, 1),
        smf21sio(34, 2),
        smf21pr(36, 1),
        smf21pw(37, 1),
        smf21nb(38, 1),
        smf21erg(39, 2),
        smf21cln(41, 2),
        smf21den(43, 1),
        smf21bls(44, 2),
        smf21ofl(46, 1),
        smf21tus(47, 3),
        smf21trf(50, 2),
        smf21trb(52, 2),
        smf21twf(54, 2),
        smf21br(56, 3),
        smf21bw(59, 3),
        smf21fl1(62, 1),
        smf21fl2(63, 1),
        smf21brn(64, 4),
        smf21bwn(68, 4),
        smf21lst(72, 4),
        smf21lbs(76, 4),
        smf21dbr(80, 4),
        smf21dbw(84, 4),
        smf21mcr(88, 4),
        smf21mcw(92, 4),
        smf21mdr(96, 4),
        smf21mdw(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

