/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class IdentificationSection
extends SmfData {
    public static final int SMF30PGF = 128;
    public static final int SMF30ID_Len_V1 = 250;
    public static final int SMF30ID_Len_V2 = 278;

    private IdentificationSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf30jbn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf30pgm() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smf30stm() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf30uif() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf30jnm() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public int smf30stn() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public String smf30cls() {
        return Util.ConvertEbcdic(this.data, 42, 1);
    }

    public int smf30jf1() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public boolean smf30pgf() {
        return Util.ConvertFlag(this.data, this.smf30jf1(), 128);
    }

    public int smf30pgn() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int smf30jpt() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public LocalTime smf30ast() {
        return Util.Binary4x100STime(this.data, 48);
    }

    public long smf30astRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public LocalTime smf30pps() {
        return Util.Binary4x100STime(this.data, 52);
    }

    public long smf30ppsRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public LocalTime smf30sit() {
        return Util.Binary4x100STime(this.data, 56);
    }

    public long smf30sitRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public LocalDate smf30std() {
        return Util.SMFDate(this.data, 60);
    }

    public int smf30stdRawValue() {
        return Util.ConvertPacked4(this.data, 60);
    }

    public LocalTime smf30rst() {
        return Util.Binary4x100STime(this.data, 64);
    }

    public long smf30rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public LocalDate smf30rsd() {
        return Util.SMFDate(this.data, 68);
    }

    public int smf30rsdRawValue() {
        return Util.ConvertPacked4(this.data, 68);
    }

    public LocalTime smf30ret() {
        return Util.Binary4x100STime(this.data, 72);
    }

    public long smf30retRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public LocalDate smf30red() {
        return Util.SMFDate(this.data, 76);
    }

    public int smf30redRawValue() {
        return Util.ConvertPacked4(this.data, 76);
    }

    public String smf30usr() {
        return Util.ConvertEbcdic(this.data, 80, 20);
    }

    public String smf30grp() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String smf30rud() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public String smf30tid() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String smf30tsn() {
        return Util.ConvertEbcdic(this.data, 124, 8);
    }

    public String smf30psn() {
        return Util.ConvertEbcdic(this.data, 132, 8);
    }

    public String smf30cl8() {
        return Util.ConvertEbcdic(this.data, 140, 8);
    }

    public ZonedDateTime smf30iss() {
        return Util.Binary8xStckTime(this.data, 148);
    }

    public BigInteger smf30issRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 148);
    }

    public ZonedDateTime smf30iet() {
        return Util.Binary8xStckTime(this.data, 156);
    }

    public BigInteger smf30ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 156);
    }

    public long smf30ssn() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public String smf30exn() {
        return Util.ConvertEbcdic(this.data, 168, 16);
    }

    public int smf30asi() {
        return Util.ConvertUnsignedBinary2(this.data, 184);
    }

    public Token smf30cor() {
        if (this.data.length >= 250) {
            return new Token(this.data, 186, 64);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(186) + " Data length: " + Integer.toString(64));
    }

    public Token smf30Jclid1() {
        if (this.data.length >= 254) {
            return new Token(this.data, 250, 4);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(250) + " Data length: " + Integer.toString(4));
    }

    public Token smf30Jclid2() {
        if (this.data.length >= 258) {
            return new Token(this.data, 254, 4);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(254) + " Data length: " + Integer.toString(4));
    }

    public Token smf30JobToken() {
        if (this.data.length >= 266) {
            return new Token(this.data, 258, 8);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(258) + " Data length: " + Integer.toString(8));
    }

    public ZonedDateTime smf30HoldUntil() {
        return Util.Binary6HiStckeTime(this.data, 266);
    }

    public BigInteger smf30HoldUntilRawValue() {
        return Util.ConvertBigInteger(this.data, 266, 6);
    }

    public ZonedDateTime smf30Deadline() {
        return Util.Binary6HiStckeTime(this.data, 272);
    }

    public BigInteger smf30DeadlineRawValue() {
        return Util.ConvertBigInteger(this.data, 272, 6);
    }

    public static IdentificationSection create(byte[] Data2, int offset, int length) {
        return new IdentificationSection(Data2, offset, length);
    }

    static enum Field {
        smf30jbn(0, 8),
        smf30pgm(8, 8),
        smf30stm(16, 8),
        smf30uif(24, 8),
        smf30jnm(32, 8),
        smf30stn(40, 2),
        smf30cls(42, 1),
        smf30jf1(43, 1),
        smf30pgn(44, 2),
        smf30jpt(46, 2),
        smf30ast(48, 4),
        smf30pps(52, 4),
        smf30sit(56, 4),
        smf30std(60, 4),
        smf30rst(64, 4),
        smf30rsd(68, 4),
        smf30ret(72, 4),
        smf30red(76, 4),
        smf30usr(80, 20),
        smf30grp(100, 8),
        smf30rud(108, 8),
        smf30tid(116, 8),
        smf30tsn(124, 8),
        smf30psn(132, 8),
        smf30cl8(140, 8),
        smf30iss(148, 8),
        smf30iet(156, 8),
        smf30ssn(164, 4),
        smf30exn(168, 16),
        smf30asi(184, 2),
        smf30cor(186, 64),
        smf30Jclid1(250, 4),
        smf30Jclid2(254, 4),
        smf30JobToken(258, 8),
        smf30HoldUntil(266, 6),
        smf30Deadline(272, 6);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

