/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf30.AccountingSection;
import com.blackhillsoftware.smf.smf30.AppcCumulativeResourceSection;
import com.blackhillsoftware.smf.smf30.AppcResourceSection;
import com.blackhillsoftware.smf.smf30.ArmSection;
import com.blackhillsoftware.smf.smf30.CompletionSection;
import com.blackhillsoftware.smf.smf30.ContainerSection;
import com.blackhillsoftware.smf.smf30.CounterSection;
import com.blackhillsoftware.smf.smf30.CryptoCountersSection;
import com.blackhillsoftware.smf.smf30.ExcpSection;
import com.blackhillsoftware.smf.smf30.Header;
import com.blackhillsoftware.smf.smf30.IdentificationSection;
import com.blackhillsoftware.smf.smf30.IoActivitySection;
import com.blackhillsoftware.smf.smf30.MultisystemEnclaveRemoteSystemDataSection;
import com.blackhillsoftware.smf.smf30.NnpiCountersSection;
import com.blackhillsoftware.smf.smf30.OperatorSection;
import com.blackhillsoftware.smf.smf30.PerformanceSection;
import com.blackhillsoftware.smf.smf30.ProcessorAccountingSection;
import com.blackhillsoftware.smf.smf30.StorageSection;
import com.blackhillsoftware.smf.smf30.SubsystemSection;
import com.blackhillsoftware.smf.smf30.UnixProcessSection;
import com.blackhillsoftware.smf.smf30.UsageDataSection;
import com.blackhillsoftware.smf.smf30.ZEdcUsageStatisticsSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Smf30Record
extends SmfRecord {
    private Header m_header = null;
    private SubsystemSection m_subsystemSection = null;
    private IdentificationSection m_identificationSection = null;
    private IoActivitySection m_ioActivitySection = null;
    private CompletionSection m_completionSection = null;
    private ProcessorAccountingSection m_processorAccountingSection = null;
    private StorageSection m_storageSection = null;
    private PerformanceSection m_performanceSection = null;
    private OperatorSection m_operatorSection = null;
    private AppcResourceSection m_appcResourceSection = null;
    private AppcCumulativeResourceSection m_appcCumulativeResourceSection = null;
    private ContainerSection m_containerSection = null;
    private List<IoActivitySection> m_ioActivitySections = null;
    private List<CompletionSection> m_completionSections = null;
    private List<ProcessorAccountingSection> m_processorAccountingSections = null;
    private List<AccountingSection> m_accountingSections = null;
    private List<StorageSection> m_storageSections = null;
    private List<PerformanceSection> m_performanceSections = null;
    private List<OperatorSection> m_operatorSections = null;
    private List<ExcpSection> m_excpSections = null;
    private List<AppcResourceSection> m_appcResourceSections = null;
    private List<AppcCumulativeResourceSection> m_appcCumulativeResourceSections = null;
    private List<UnixProcessSection> m_unixProcessSections = null;
    private List<UsageDataSection> m_usageDataSections = null;
    private List<ArmSection> m_armSections = null;
    private List<MultisystemEnclaveRemoteSystemDataSection> m_multisystemEnclaveRemoteSystemDataSections = null;
    private List<CounterSection> m_counterSections = null;
    private List<ZEdcUsageStatisticsSection> m_zEdcUsageStatisticsSections = null;
    private List<CryptoCountersSection> m_CryptoCountersSection = null;
    private List<NnpiCountersSection> m_NnpiCountersSection = null;

    public Smf30Record(byte[] data) {
        super(data);
        if (this.recordType() != 30) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf30Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 30) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf30Record from(SmfRecord record) {
        return new Smf30Record(record);
    }

    public static Smf30Record from(byte[] data) {
        return new Smf30Record(data);
    }

    public Header header() {
        if (this.m_header == null) {
            Header tempHeader = new Header(this.data);
            this.m_header = Header.create(this.data, 0, tempHeader.smf30sof());
        }
        return this.m_header;
    }

    public SubsystemSection subSystemSection() {
        if (this.m_subsystemSection == null) {
            Triplet t = this.header().smf30sofTriplet();
            this.m_subsystemSection = SubsystemSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_subsystemSection;
    }

    public IdentificationSection identificationSection() {
        if (this.m_identificationSection == null) {
            Triplet t = this.header().smf30iofTriplet();
            this.m_identificationSection = IdentificationSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_identificationSection;
    }

    public List<IoActivitySection> ioActivitySections() {
        this.m_ioActivitySections = Util.sectionsFromTriplet(this.m_ioActivitySections, this.data, this.header().smf30uofTriplet(), IoActivitySection::create);
        return this.m_ioActivitySections;
    }

    public IoActivitySection ioActivitySection() {
        if (this.m_ioActivitySection == null) {
            Triplet t = this.header().smf30uofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_ioActivitySection = IoActivitySection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_ioActivitySection;
    }

    public List<CompletionSection> completionSections() {
        this.m_completionSections = Util.sectionsFromTriplet(this.m_completionSections, this.data, this.header().smf30tofTriplet(), CompletionSection::create);
        return this.m_completionSections;
    }

    public CompletionSection completionSection() {
        if (this.m_completionSection == null) {
            Triplet t = this.header().smf30tofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_completionSection = CompletionSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_completionSection;
    }

    public List<ProcessorAccountingSection> processorAccountingSections() {
        this.m_processorAccountingSections = Util.sectionsFromTriplet(this.m_processorAccountingSections, this.data, this.header().smf30cofTriplet(), ProcessorAccountingSection::create);
        return this.m_processorAccountingSections;
    }

    public ProcessorAccountingSection processorAccountingSection() {
        if (this.m_processorAccountingSection == null) {
            Triplet t = this.header().smf30cofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_processorAccountingSection = ProcessorAccountingSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_processorAccountingSection;
    }

    public List<AccountingSection> accountingSections() {
        if (this.m_accountingSections != null) {
            return this.m_accountingSections;
        }
        Triplet t = this.header().smf30aofTriplet();
        if (t.getCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<AccountingSection> result = new ArrayList<AccountingSection>(t.getCount());
        int sectionoffset = t.getOffset();
        for (int i = 0; i < t.getCount(); ++i) {
            int fieldlen = Util.ConvertUnsignedBinary1(this.data, sectionoffset);
            result.add(AccountingSection.create(this.data, sectionoffset, fieldlen + 1));
            sectionoffset += fieldlen + 1;
        }
        this.m_accountingSections = Collections.unmodifiableList(result);
        return this.m_accountingSections;
    }

    public List<StorageSection> storageSections() {
        this.m_storageSections = Util.sectionsFromTriplet(this.m_storageSections, this.data, this.header().smf30rofTriplet(), StorageSection::create);
        return this.m_storageSections;
    }

    public StorageSection storageSection() {
        if (this.m_storageSection == null) {
            Triplet t = this.header().smf30rofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_storageSection = StorageSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_storageSection;
    }

    public List<PerformanceSection> performanceSections() {
        this.m_performanceSections = Util.sectionsFromTriplet(this.m_performanceSections, this.data, this.header().smf30pofTriplet(), PerformanceSection::create);
        return this.m_performanceSections;
    }

    public PerformanceSection performanceSection() {
        if (this.m_performanceSection == null) {
            Triplet t = this.header().smf30pofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_performanceSection = PerformanceSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_performanceSection;
    }

    public List<OperatorSection> operatorSections() {
        this.m_operatorSections = Util.sectionsFromTriplet(this.m_operatorSections, this.data, this.header().smf30oofTriplet(), OperatorSection::create);
        return this.m_operatorSections;
    }

    public OperatorSection operatorSection() {
        if (this.m_operatorSection == null) {
            Triplet t = this.header().smf30oofTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_operatorSection = OperatorSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_operatorSection;
    }

    public List<ExcpSection> excpSections() {
        this.m_excpSections = Util.sectionsFromTriplet(this.m_excpSections, this.data, this.header().smf30eofTriplet(), ExcpSection::create);
        return this.m_excpSections;
    }

    public List<AppcResourceSection> appcResourceSections() {
        this.m_appcResourceSections = Util.sectionsFromTriplet(this.m_appcResourceSections, this.data, this.header().smf30droTriplet(), AppcResourceSection::create);
        return this.m_appcResourceSections;
    }

    public AppcResourceSection appcResourceSection() {
        if (this.m_appcResourceSection == null) {
            Triplet t = this.header().smf30droTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_appcResourceSection = AppcResourceSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_appcResourceSection;
    }

    public List<AppcCumulativeResourceSection> appcCumulativeResourceSections() {
        this.m_appcCumulativeResourceSections = Util.sectionsFromTriplet(this.m_appcCumulativeResourceSections, this.data, this.header().smf30aroTriplet(), AppcCumulativeResourceSection::create);
        return this.m_appcCumulativeResourceSections;
    }

    public AppcCumulativeResourceSection appcCumulativeResourceSection() {
        if (this.m_appcCumulativeResourceSection == null) {
            Triplet t = this.header().smf30aroTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_appcCumulativeResourceSection = AppcCumulativeResourceSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_appcCumulativeResourceSection;
    }

    public List<UnixProcessSection> unixProcessSections() {
        this.m_unixProcessSections = Util.sectionsFromTriplet(this.m_unixProcessSections, this.data, this.header().smf30opoTriplet(), UnixProcessSection::create);
        return this.m_unixProcessSections;
    }

    public List<UsageDataSection> usageDataSections() {
        this.m_usageDataSections = Util.sectionsFromTriplet(this.m_usageDataSections, this.data, this.header().smf30udoTriplet(), UsageDataSection::create);
        return this.m_usageDataSections;
    }

    public List<ArmSection> armSections() {
        this.m_armSections = Util.sectionsFromTriplet(this.m_armSections, this.data, this.header().smf30rmoTriplet(), ArmSection::create);
        return this.m_armSections;
    }

    public List<MultisystemEnclaveRemoteSystemDataSection> multiSystemEnclaveRemoteSystemDataSections() {
        this.m_multisystemEnclaveRemoteSystemDataSections = Util.sectionsFromTriplet(this.m_multisystemEnclaveRemoteSystemDataSections, this.data, this.header().smf30mofTriplet(), MultisystemEnclaveRemoteSystemDataSection::create);
        return this.m_multisystemEnclaveRemoteSystemDataSections;
    }

    public List<CounterSection> counterSections() {
        this.m_counterSections = Util.sectionsFromTriplet(this.m_counterSections, this.data, this.header().smf30cdoTriplet(), CounterSection::create);
        return this.m_counterSections;
    }

    public List<ZEdcUsageStatisticsSection> zEdcUsageStatisticsSections() {
        this.m_zEdcUsageStatisticsSections = Util.sectionsFromTriplet(this.m_zEdcUsageStatisticsSections, this.data, this.header().smf30usoTriplet(), ZEdcUsageStatisticsSection::create);
        return this.m_zEdcUsageStatisticsSections;
    }

    public List<CryptoCountersSection> cryptoCountersSection() {
        this.m_CryptoCountersSection = Util.sectionsFromTriplet(this.m_CryptoCountersSection, this.data, this.header().smf30cpoTriplet(), CryptoCountersSection::create);
        return this.m_CryptoCountersSection;
    }

    public List<NnpiCountersSection> nnpiCountersSections() {
        this.m_NnpiCountersSection = Util.sectionsFromTriplet(this.m_NnpiCountersSection, this.data, this.header().smf30npoTriplet(), NnpiCountersSection::create);
        return this.m_NnpiCountersSection;
    }

    public ContainerSection containerSection() {
        if (this.m_containerSection == null) {
            Triplet t = this.header().smf30cnoTriplet();
            if (t.getCount() == 0) {
                return null;
            }
            this.m_containerSection = ContainerSection.create(this.data, t.getOffset(), t.getLength());
        }
        return this.m_containerSection;
    }
}

