/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf30;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class StorageSection
extends SmfData {
    public static final int SMF30VQR = 128;
    public static final int SMF30UCL = 64;
    public static final int SMF30UCM = 32;
    public static final int SMF30SIN = 16;
    public static final int SMF30NHU = 8;
    public static final int SMF30_RsvdHBB77B0_Exists = 4;
    public static final int SMF30SL1 = 128;
    public static final int SMF30SL2 = 64;
    public static final int SMF30SL3 = 32;
    public static final int SMF30SL4 = 16;
    public static final int SMF30SL5 = 8;
    public static final int SMF30SL6 = 4;
    public static final int SMF30_UserKeyCommonAuditEnabled = 128;
    public static final int SMF30_UserKeyCsaUsage = 64;
    public static final int SMF30_UserKeyCadsUsage = 32;
    public static final int SMF30_UserKeyChangKeyUsage = 16;
    public static final int SMF30_UserKeyRuCsaUsage = 8;
    public static final int SMF30_RUCSAEarlyUsage = 4;

    private StorageSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf30sfl() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf30vqr() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 128);
    }

    public boolean smf30ucl() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 64);
    }

    public boolean smf30ucm() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 32);
    }

    public boolean smf30sin() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 16);
    }

    public boolean smf30nhu() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 8);
    }

    public boolean smf30RsvdHBB77B0Exists() {
        return Util.ConvertFlag(this.data, this.smf30sfl(), 4);
    }

    public int smf30spk() {
        return Util.ConvertUnsignedBits(this.data, 3, 0, 4);
    }

    public int smf30prv() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int smf30sys() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public long smf30pgi() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf30pia() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf30pgo() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf30poa() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf30cpm() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf30nsw() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf30psi() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf30pso() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf30vpi() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf30vpo() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf30vpr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf30cpi() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf30hpi() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf30lpi() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf30hpo() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf30pst() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf30psc() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf30pscAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf30rgb() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf30erg() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long smf30arb() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf30ear() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf30urb() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf30eur() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf30rgn() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf30dsv() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long smf30pie() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long smf30poe() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smf30bia() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf30boa() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf30bie() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf30boe() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf30kia() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long smf30koa() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long smf30kie() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long smf30koe() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long smf30psf() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger smf30psfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long smf30pai() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long smf30pei() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long smf30ers() {
        return Util.ConvertUnsignedBinary8(this.data, 160);
    }

    public BigInteger smf30ersAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 160);
    }

    public long smf30mem() {
        return Util.ConvertUnsignedBinary8(this.data, 168);
    }

    public BigInteger smf30memAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public int smf30mes() {
        return Util.ConvertUnsignedBinary1(this.data, 176);
    }

    public int smf30slm() {
        return Util.ConvertUnsignedBinary1(this.data, 177);
    }

    public boolean smf30sl1() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 128);
    }

    public boolean smf30sl2() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 64);
    }

    public boolean smf30sl3() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 32);
    }

    public boolean smf30sl4() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 16);
    }

    public boolean smf30sl5() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 8);
    }

    public boolean smf30sl6() {
        return Util.ConvertFlag(this.data, this.smf30slm(), 4);
    }

    public int smf30RaxFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 178);
    }

    @Deprecated
    public int smf30Raxflags() {
        return Util.ConvertUnsignedBinary1(this.data, 178);
    }

    public boolean smf30UserKeyCommonAuditEnabled() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 128);
    }

    public boolean smf30UserKeyCsaUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 64);
    }

    public boolean smf30UserKeyCadsUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 32);
    }

    public boolean smf30UserKeyChangKeyUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 16);
    }

    public boolean smf30UserKeyRuCsaUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 8);
    }

    @Deprecated
    public boolean smf30Userkeyrucsausage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 8);
    }

    public boolean smf30RuCsaEarlyUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 4);
    }

    @Deprecated
    public boolean smf30RUCSAEarlyUsage() {
        return Util.ConvertFlag(this.data, this.smf30RaxFlags(), 4);
    }

    public long smf30hvr() {
        return Util.ConvertUnsignedBinary8(this.data, 184);
    }

    public BigInteger smf30hvrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public long smf30hva() {
        return Util.ConvertUnsignedBinary8(this.data, 192);
    }

    public BigInteger smf30hvaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 192);
    }

    public long smf30hvo() {
        return Util.ConvertUnsignedBinary8(this.data, 200);
    }

    public BigInteger smf30hvoAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 200);
    }

    public long smf30hvh() {
        return Util.ConvertUnsignedBinary8(this.data, 208);
    }

    public BigInteger smf30hvhAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 208);
    }

    public long smf30hso() {
        return Util.ConvertUnsignedBinary8(this.data, 216);
    }

    public BigInteger smf30hsoAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public long smf30hsh() {
        return Util.ConvertUnsignedBinary8(this.data, 224);
    }

    public BigInteger smf30hshAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public long smf30tih() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long smf30tiu() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long smf30tis() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long smf30NumberOfDataSpacesHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long smf30UserDataSpaceCreateReqCount() {
        return Util.ConvertUnsignedBinary8(this.data, 248);
    }

    public BigInteger smf30UserDataSpaceCreateReqCountAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 248);
    }

    public long smf30DMemRequested2G() {
        return Util.ConvertUnsignedBinary8(this.data, 256);
    }

    public BigInteger smf30DMemRequested2GAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 256);
    }

    public long smf30DMemMinRequested2G() {
        return Util.ConvertUnsignedBinary8(this.data, 264);
    }

    public BigInteger smf30DMemMinRequested2GAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 264);
    }

    public long smf30DMemAssigned2G() {
        return Util.ConvertUnsignedBinary8(this.data, 272);
    }

    public BigInteger smf30DMemAssigned2GAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 272);
    }

    public long smf30DMemNumInUseAs2G() {
        return Util.ConvertUnsignedBinary8(this.data, 280);
    }

    public BigInteger smf30DMemNumInUseAs2GAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 280);
    }

    public long smf30DMemNumInUseAsFixed1M() {
        return Util.ConvertUnsignedBinary8(this.data, 288);
    }

    public BigInteger smf30DMemNumInUseAsFixed1MAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public long smf30DMemNumInUseAsPageable1M() {
        return Util.ConvertUnsignedBinary8(this.data, 296);
    }

    public BigInteger smf30DMemNumInUseAsPageable1MAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public long smf30DMemNumInUseAs4K() {
        return Util.ConvertUnsignedBinary8(this.data, 304);
    }

    public BigInteger smf30DMemNumInUseAs4KAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public long smf30DMemNumInUseAsDATTables() {
        return Util.ConvertUnsignedBinary8(this.data, 312);
    }

    public BigInteger smf30DMemNumInUseAsDATTablesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 312);
    }

    public long smf30DMemNumInUseAs4KHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 320);
    }

    public BigInteger smf30DMemNumInUseAs4KHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 320);
    }

    public long smf30DMemNumInUseAsPageable1MHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 328);
    }

    public BigInteger smf30DMemNumInUseAsPageable1MHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 328);
    }

    public long smf30DMemNumInUseAsFixed1MHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 336);
    }

    public BigInteger smf30DMemNumInUseAsFixed1MHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 336);
    }

    public long smf30DMemNumInUseAs2GHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 344);
    }

    public BigInteger smf30DMemNumInUseAs2GHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 344);
    }

    public long smf30DMemNumInUseAsDATTablesHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 352);
    }

    public BigInteger smf30DMemNumInUseAsDATTablesHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public long smf30DMemNumInUseHwm() {
        return Util.ConvertUnsignedBinary8(this.data, 360);
    }

    public BigInteger smf30DMemNumInUseHwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public long smf30DMemNum2GFailed() {
        return Util.ConvertUnsignedBinary8(this.data, 368);
    }

    public BigInteger smf30DMemNum2GFailedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 368);
    }

    public long smf30DMemNum1MFailed() {
        return Util.ConvertUnsignedBinary8(this.data, 376);
    }

    public BigInteger smf30DMemNum1MFailedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 376);
    }

    public long smf30DMemNum4KFailed() {
        return Util.ConvertUnsignedBinary8(this.data, 384);
    }

    public BigInteger smf30DMemNum4KFailedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 384);
    }

    public long smf30NumInUseAs2GHWM() {
        return Util.ConvertUnsignedBinary8(this.data, 392);
    }

    public BigInteger smf30NumInUseAs2GHWMAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 392);
    }

    public long smf30Num2GFailed() {
        return Util.ConvertUnsignedBinary8(this.data, 400);
    }

    public BigInteger smf30Num2GFailedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 400);
    }

    public long smf30ObtainsHomeSpace() {
        return Util.ConvertUnsignedBinary8(this.data, 408);
    }

    public BigInteger smf30ObtainsHomeSpaceAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 408);
    }

    public long smf30Iarv64ObtainsHomeSpace() {
        return Util.ConvertUnsignedBinary8(this.data, 416);
    }

    public BigInteger smf30Iarv64ObtainsHomeSpaceAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 416);
    }

    public long smf30FramesFirstReferenceBacking() {
        return Util.ConvertUnsignedBinary8(this.data, 424);
    }

    public BigInteger smf30FramesFirstReferenceBackingAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 424);
    }

    public long smf30SumReal1M() {
        return Util.ConvertUnsignedBinary8(this.data, 432);
    }

    public BigInteger smf30SumReal1MAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 432);
    }

    public BigInteger smf30SumSquaresReal1M() {
        return Util.ConvertBigInteger(this.data, 440, 16);
    }

    public long smf30NumSamples() {
        return Util.ConvertUnsignedBinary8(this.data, 456);
    }

    public BigInteger smf30NumSamplesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 456);
    }

    public long smf30HwmHVReal1M() {
        return Util.ConvertUnsignedBinary8(this.data, 464);
    }

    public BigInteger smf30HwmHVReal1MAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 464);
    }

    public static StorageSection create(byte[] Data2, int offset, int length) {
        return new StorageSection(Data2, offset, length);
    }

    static enum Field {
        smf30sfl(2, 1),
        smf30spk(3, 0),
        smf30prv(4, 2),
        smf30sys(6, 2),
        smf30pgi(8, 4),
        smf30pia(8, 4),
        smf30pgo(12, 4),
        smf30poa(12, 4),
        smf30cpm(16, 4),
        smf30nsw(20, 4),
        smf30psi(24, 4),
        smf30pso(28, 4),
        smf30vpi(32, 4),
        smf30vpo(36, 4),
        smf30vpr(40, 4),
        smf30cpi(44, 4),
        smf30hpi(48, 4),
        smf30lpi(52, 4),
        smf30hpo(56, 4),
        smf30pst(60, 4),
        smf30psc(64, 8),
        smf30rgb(72, 4),
        smf30erg(76, 4),
        smf30arb(80, 4),
        smf30ear(84, 4),
        smf30urb(88, 4),
        smf30eur(92, 4),
        smf30rgn(96, 4),
        smf30dsv(100, 4),
        smf30pie(104, 4),
        smf30poe(108, 4),
        smf30bia(112, 4),
        smf30boa(116, 4),
        smf30bie(120, 4),
        smf30boe(124, 4),
        smf30kia(128, 4),
        smf30koa(132, 4),
        smf30kie(136, 4),
        smf30koe(140, 4),
        smf30psf(144, 8),
        smf30pai(152, 4),
        smf30pei(156, 4),
        smf30ers(160, 8),
        smf30mem(168, 8),
        smf30mes(176, 1),
        smf30slm(177, 1),
        smf30RaxFlags(178, 1),
        smf30hvr(184, 8),
        smf30hva(192, 8),
        smf30hvo(200, 8),
        smf30hvh(208, 8),
        smf30hso(216, 8),
        smf30hsh(224, 8),
        smf30tih(232, 4),
        smf30tiu(236, 4),
        smf30tis(240, 4),
        smf30NumberOfDataSpacesHwm(244, 4),
        smf30UserDataSpaceCreateReqCount(248, 8),
        smf30DMemRequested2G(256, 8),
        smf30DMemMinRequested2G(264, 8),
        smf30DMemAssigned2G(272, 8),
        smf30DMemNumInUseAs2G(280, 8),
        smf30DMemNumInUseAsFixed1M(288, 8),
        smf30DMemNumInUseAsPageable1M(296, 8),
        smf30DMemNumInUseAs4K(304, 8),
        smf30DMemNumInUseAsDATTables(312, 8),
        smf30DMemNumInUseAs4KHwm(320, 8),
        smf30DMemNumInUseAsPageable1MHwm(328, 8),
        smf30DMemNumInUseAsFixed1MHwm(336, 8),
        smf30DMemNumInUseAs2GHwm(344, 8),
        smf30DMemNumInUseAsDATTablesHwm(352, 8),
        smf30DMemNumInUseHwm(360, 8),
        smf30DMemNum2GFailed(368, 8),
        smf30DMemNum1MFailed(376, 8),
        smf30DMemNum4KFailed(384, 8),
        smf30NumInUseAs2GHWM(392, 8),
        smf30Num2GFailed(400, 8),
        smf30ObtainsHomeSpace(408, 8),
        smf30Iarv64ObtainsHomeSpace(416, 8),
        smf30FramesFirstReferenceBacking(424, 8),
        smf30SumReal1M(432, 8),
        smf30SumSquaresReal1M(440, 16),
        smf30NumSamples(456, 8),
        smf30HwmHVReal1M(464, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

