/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class BmfTotals
extends SmfData {
    public static final int SMF4201A_LEN = 36;

    private BmfTotals(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf42tna() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public Duration smf42tmt() {
        return Util.Binary4_Seconds(this.data, 4);
    }

    public double smf42tmtSeconds() {
        return Util.ToSeconds(this.smf42tmt());
    }

    public long smf42tmtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf42trt() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf42trh() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf42tdt() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf42tdh() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf42buf() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf42bmx() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration smf42lru() {
        return Util.Binary2x100S(this.data, 32);
    }

    public double smf42lruSeconds() {
        return Util.ToSeconds(this.smf42lru());
    }

    public long smf42lruRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf42uic() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public static BmfTotals create(byte[] Data2, int offset, int length) {
        return new BmfTotals(Data2, offset, length);
    }

    static enum Field {
        smf42tna(0, 4),
        smf42tmt(4, 4),
        smf42trt(8, 4),
        smf42trh(12, 4),
        smf42tdt(16, 4),
        smf42tdh(20, 4),
        smf42buf(24, 4),
        smf42bmx(28, 4),
        smf42lru(32, 2),
        smf42uic(34, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

