/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype16;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class DatasetSummaryBelowBar
extends SmfData {
    public static final int SMF42GAI0 = Integer.MIN_VALUE;
    public static final int SMF42GAI1 = 0x40000000;
    public static final int SMF42GA3_LEN = 168;
    public static final int SMF42GA4_LEN = 168;
    public static final int SMF42GA2_LEN = 336;
    public static final int SMF42GA6_LEN = 168;
    public static final int SMF42GA7_LEN = 168;
    public static final int SMF42GA8_LEN = 168;
    public static final int SMF42GA9_LEN = 168;
    public static final int SMF42GA5_LEN = 672;
    public static final int SMF42FX5_LEN = 128;
    public static final int SMF42FX7_LEN = 64;
    public static final int SMF420GA_LEN = 1488;

    private DatasetSummaryBelowBar(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf42gaa() {
        return Util.Binary4_Seconds(this.data, 0);
    }

    public double smf42gaaSeconds() {
        return Util.ToSeconds(this.smf42gaa());
    }

    public long smf42gaaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public String smf42gab() {
        return Util.ConvertEbcdic(this.data, 16, 44);
    }

    public String smf42gac() {
        return Util.ConvertEbcdic(this.data, 64, 44);
    }

    public int smf42gad() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public String smf42gae() {
        if (this.data.length >= 114 + this.smf42gad()) {
            return Util.ConvertEbcdic(this.data, 114, this.smf42gad());
        }
        return null;
    }

    public int smf42a03() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public String smf42gaf() {
        if (this.data.length >= 146 + this.smf42a03()) {
            return Util.ConvertEbcdic(this.data, 146, this.smf42a03());
        }
        return null;
    }

    public String smf42gah() {
        return Util.ConvertEbcdic(this.data, 178, 30);
    }

    public long smf42gai() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public boolean smf42gai0() {
        return Util.ConvertFlag(this.data, this.smf42gai(), Integer.MIN_VALUE);
    }

    public boolean smf42gai1() {
        return Util.ConvertFlag(this.data, this.smf42gai(), 0x40000000L);
    }

    public String smf42gaj() {
        return Util.ConvertEbcdic(this.data, 212, 12);
    }

    public long smf42gak() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public long smf42gal() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long smf42gam() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public int smf42gz1() {
        return Util.ConvertUnsignedBinary2(this.data, 236);
    }

    public int smf42gz2() {
        return Util.ConvertUnsignedBinary2(this.data, 238);
    }

    public String smf42gan() {
        return Util.ConvertEbcdic(this.data, 240, 8);
    }

    public String smf42gao() {
        return Util.ConvertEbcdic(this.data, 248, 8);
    }

    public String smf42gap() {
        return Util.ConvertEbcdic(this.data, 256, 16);
    }

    public long smf42gca() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long smf42gcb() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long smf42gcc() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public long smf42gcd() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public long smf42gce() {
        return Util.ConvertUnsignedBinary4(this.data, 288);
    }

    public long smf42gcf() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long smf42gcg() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public long smf42gch() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public long smf42gci() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public long smf42gcj() {
        return Util.ConvertUnsignedBinary4(this.data, 308);
    }

    public long smf42gck() {
        return Util.ConvertUnsignedBinary4(this.data, 312);
    }

    public long smf42gcl() {
        return Util.ConvertUnsignedBinary4(this.data, 316);
    }

    public long smf42gcm() {
        return Util.ConvertUnsignedBinary4(this.data, 320);
    }

    public long smf42gcn() {
        return Util.ConvertUnsignedBinary4(this.data, 324);
    }

    public long smf42gco() {
        return Util.ConvertUnsignedBinary4(this.data, 328);
    }

    public long smf42gcp() {
        return Util.ConvertUnsignedBinary4(this.data, 332);
    }

    public long smf42gcq() {
        return Util.ConvertUnsignedBinary8(this.data, 336);
    }

    public BigInteger smf42gcqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 336);
    }

    public long smf42gcr() {
        return Util.ConvertUnsignedBinary4(this.data, 344);
    }

    public long smf42gcs() {
        return Util.ConvertUnsignedBinary4(this.data, 348);
    }

    public long smf42gct() {
        return Util.ConvertUnsignedBinary8(this.data, 352);
    }

    public BigInteger smf42gctAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public long smf42gcu() {
        return Util.ConvertUnsignedBinary8(this.data, 360);
    }

    public BigInteger smf42gcuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public Duration smf42gcw() {
        return Util.Binary8MSSeconds(this.data, 384);
    }

    public double smf42gcwSeconds() {
        return Util.ToSeconds(this.smf42gcw());
    }

    public BigInteger smf42gcwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 384);
    }

    public Duration smf42gcx() {
        return Util.Binary4MS(this.data, 392);
    }

    public double smf42gcxSeconds() {
        return Util.ToSeconds(this.smf42gcx());
    }

    public long smf42gcxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 392);
    }

    public Duration smf42gcy() {
        return Util.Binary4MS(this.data, 396);
    }

    public double smf42gcySeconds() {
        return Util.ToSeconds(this.smf42gcy());
    }

    public long smf42gcyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long smf42gda() {
        return Util.ConvertUnsignedBinary4(this.data, 440);
    }

    public long smf42gdb() {
        return Util.ConvertUnsignedBinary4(this.data, 444);
    }

    public long smf42gdc() {
        return Util.ConvertUnsignedBinary4(this.data, 448);
    }

    public long smf42gdd() {
        return Util.ConvertUnsignedBinary4(this.data, 452);
    }

    public long smf42gde() {
        return Util.ConvertUnsignedBinary4(this.data, 456);
    }

    public long smf42gdf() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public long smf42gdg() {
        return Util.ConvertUnsignedBinary4(this.data, 464);
    }

    public long smf42gdh() {
        return Util.ConvertUnsignedBinary4(this.data, 468);
    }

    public long smf42gdi() {
        return Util.ConvertUnsignedBinary4(this.data, 472);
    }

    public long smf42gdj() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public long smf42gdk() {
        return Util.ConvertUnsignedBinary4(this.data, 480);
    }

    public long smf42gdl() {
        return Util.ConvertUnsignedBinary4(this.data, 484);
    }

    public long smf42gdm() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public long smf42gdn() {
        return Util.ConvertUnsignedBinary4(this.data, 492);
    }

    public long smf42gdo() {
        return Util.ConvertUnsignedBinary4(this.data, 496);
    }

    public long smf42gdp() {
        return Util.ConvertUnsignedBinary4(this.data, 500);
    }

    public long smf42gdq() {
        return Util.ConvertUnsignedBinary8(this.data, 504);
    }

    public BigInteger smf42gdqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 504);
    }

    public long smf42gdr() {
        return Util.ConvertUnsignedBinary4(this.data, 512);
    }

    public long smf42gds() {
        return Util.ConvertUnsignedBinary4(this.data, 516);
    }

    public long smf42gdt() {
        return Util.ConvertUnsignedBinary8(this.data, 520);
    }

    public BigInteger smf42gdtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 520);
    }

    public long smf42gdu() {
        return Util.ConvertUnsignedBinary8(this.data, 528);
    }

    public BigInteger smf42gduAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 528);
    }

    public Duration smf42gdw() {
        return Util.Binary8MSSeconds(this.data, 552);
    }

    public double smf42gdwSeconds() {
        return Util.ToSeconds(this.smf42gdw());
    }

    public BigInteger smf42gdwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 552);
    }

    public Duration smf42gdx() {
        return Util.Binary4MS(this.data, 560);
    }

    public double smf42gdxSeconds() {
        return Util.ToSeconds(this.smf42gdx());
    }

    public long smf42gdxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 560);
    }

    public Duration smf42gdy() {
        return Util.Binary4MS(this.data, 564);
    }

    public double smf42gdySeconds() {
        return Util.ToSeconds(this.smf42gdy());
    }

    public long smf42gdyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    public long smf42gea() {
        return Util.ConvertUnsignedBinary4(this.data, 608);
    }

    public long smf42geb() {
        return Util.ConvertUnsignedBinary4(this.data, 612);
    }

    public long smf42gec() {
        return Util.ConvertUnsignedBinary4(this.data, 616);
    }

    public long smf42ged() {
        return Util.ConvertUnsignedBinary4(this.data, 620);
    }

    public long smf42gee() {
        return Util.ConvertUnsignedBinary4(this.data, 624);
    }

    public long smf42gef() {
        return Util.ConvertUnsignedBinary4(this.data, 628);
    }

    public long smf42geg() {
        return Util.ConvertUnsignedBinary4(this.data, 632);
    }

    public long smf42geh() {
        return Util.ConvertUnsignedBinary4(this.data, 636);
    }

    public long smf42gei() {
        return Util.ConvertUnsignedBinary4(this.data, 640);
    }

    public long smf42gej() {
        return Util.ConvertUnsignedBinary4(this.data, 644);
    }

    public long smf42gek() {
        return Util.ConvertUnsignedBinary4(this.data, 648);
    }

    public long smf42gel() {
        return Util.ConvertUnsignedBinary4(this.data, 652);
    }

    public long smf42gem() {
        return Util.ConvertUnsignedBinary4(this.data, 656);
    }

    public long smf42gen() {
        return Util.ConvertUnsignedBinary4(this.data, 660);
    }

    public long smf42geo() {
        return Util.ConvertUnsignedBinary4(this.data, 664);
    }

    public long smf42gep() {
        return Util.ConvertUnsignedBinary4(this.data, 668);
    }

    public long smf42geq() {
        return Util.ConvertUnsignedBinary8(this.data, 672);
    }

    public BigInteger smf42geqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 672);
    }

    public long smf42ger() {
        return Util.ConvertUnsignedBinary4(this.data, 680);
    }

    public long smf42ges() {
        return Util.ConvertUnsignedBinary4(this.data, 684);
    }

    public long smf42get() {
        return Util.ConvertUnsignedBinary8(this.data, 688);
    }

    public BigInteger smf42getAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 688);
    }

    public long smf42geu() {
        return Util.ConvertUnsignedBinary8(this.data, 696);
    }

    public BigInteger smf42geuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 696);
    }

    public Duration smf42gew() {
        return Util.Binary8MSSeconds(this.data, 720);
    }

    public double smf42gewSeconds() {
        return Util.ToSeconds(this.smf42gew());
    }

    public BigInteger smf42gewRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 720);
    }

    public Duration smf42gex() {
        return Util.Binary4MS(this.data, 728);
    }

    public double smf42gexSeconds() {
        return Util.ToSeconds(this.smf42gex());
    }

    public long smf42gexRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 728);
    }

    public Duration smf42gey() {
        return Util.Binary4MS(this.data, 732);
    }

    public double smf42geySeconds() {
        return Util.ToSeconds(this.smf42gey());
    }

    public long smf42geyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 732);
    }

    public long smf42gfa() {
        return Util.ConvertUnsignedBinary4(this.data, 776);
    }

    public long smf42gfb() {
        return Util.ConvertUnsignedBinary4(this.data, 780);
    }

    public long smf42gfc() {
        return Util.ConvertUnsignedBinary4(this.data, 784);
    }

    public long smf42gfd() {
        return Util.ConvertUnsignedBinary4(this.data, 788);
    }

    public long smf42gfe() {
        return Util.ConvertUnsignedBinary4(this.data, 792);
    }

    public long smf42gff() {
        return Util.ConvertUnsignedBinary4(this.data, 796);
    }

    public long smf42gfg() {
        return Util.ConvertUnsignedBinary4(this.data, 800);
    }

    public long smf42gfh() {
        return Util.ConvertUnsignedBinary4(this.data, 804);
    }

    public long smf42gfi() {
        return Util.ConvertUnsignedBinary4(this.data, 808);
    }

    public long smf42gfj() {
        return Util.ConvertUnsignedBinary4(this.data, 812);
    }

    public long smf42gfk() {
        return Util.ConvertUnsignedBinary4(this.data, 816);
    }

    public long smf42gfl() {
        return Util.ConvertUnsignedBinary4(this.data, 820);
    }

    public long smf42gfm() {
        return Util.ConvertUnsignedBinary4(this.data, 824);
    }

    public long smf42gfn() {
        return Util.ConvertUnsignedBinary4(this.data, 828);
    }

    public long smf42gfo() {
        return Util.ConvertUnsignedBinary4(this.data, 832);
    }

    public long smf42gfp() {
        return Util.ConvertUnsignedBinary4(this.data, 836);
    }

    public long smf42gfq() {
        return Util.ConvertUnsignedBinary8(this.data, 840);
    }

    public BigInteger smf42gfqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 840);
    }

    public long smf42gfr() {
        return Util.ConvertUnsignedBinary4(this.data, 848);
    }

    public long smf42gfs() {
        return Util.ConvertUnsignedBinary4(this.data, 852);
    }

    public long smf42gft() {
        return Util.ConvertUnsignedBinary8(this.data, 856);
    }

    public BigInteger smf42gftAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 856);
    }

    public long smf42gfu() {
        return Util.ConvertUnsignedBinary8(this.data, 864);
    }

    public BigInteger smf42gfuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 864);
    }

    public Duration smf42gfw() {
        return Util.Binary8MSSeconds(this.data, 888);
    }

    public double smf42gfwSeconds() {
        return Util.ToSeconds(this.smf42gfw());
    }

    public BigInteger smf42gfwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 888);
    }

    public Duration smf42gfx() {
        return Util.Binary4MS(this.data, 896);
    }

    public double smf42gfxSeconds() {
        return Util.ToSeconds(this.smf42gfx());
    }

    public long smf42gfxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 896);
    }

    public Duration smf42gfy() {
        return Util.Binary4MS(this.data, 900);
    }

    public double smf42gfySeconds() {
        return Util.ToSeconds(this.smf42gfy());
    }

    public long smf42gfyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 900);
    }

    public long smf42gga() {
        return Util.ConvertUnsignedBinary4(this.data, 944);
    }

    public long smf42ggb() {
        return Util.ConvertUnsignedBinary4(this.data, 948);
    }

    public long smf42ggc() {
        return Util.ConvertUnsignedBinary4(this.data, 952);
    }

    public long smf42ggd() {
        return Util.ConvertUnsignedBinary4(this.data, 956);
    }

    public long smf42gge() {
        return Util.ConvertUnsignedBinary4(this.data, 960);
    }

    public long smf42ggf() {
        return Util.ConvertUnsignedBinary4(this.data, 964);
    }

    public long smf42ggg() {
        return Util.ConvertUnsignedBinary4(this.data, 968);
    }

    public long smf42ggh() {
        return Util.ConvertUnsignedBinary4(this.data, 972);
    }

    public long smf42ggi() {
        return Util.ConvertUnsignedBinary4(this.data, 976);
    }

    public long smf42ggj() {
        return Util.ConvertUnsignedBinary4(this.data, 980);
    }

    public long smf42ggk() {
        return Util.ConvertUnsignedBinary4(this.data, 984);
    }

    public long smf42ggl() {
        return Util.ConvertUnsignedBinary4(this.data, 988);
    }

    public long smf42ggm() {
        return Util.ConvertUnsignedBinary4(this.data, 992);
    }

    public long smf42ggn() {
        return Util.ConvertUnsignedBinary4(this.data, 996);
    }

    public long smf42ggo() {
        return Util.ConvertUnsignedBinary4(this.data, 1000);
    }

    public long smf42ggp() {
        return Util.ConvertUnsignedBinary4(this.data, 1004);
    }

    public long smf42ggq() {
        return Util.ConvertUnsignedBinary8(this.data, 1008);
    }

    public BigInteger smf42ggqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1008);
    }

    public long smf42ggr() {
        return Util.ConvertUnsignedBinary4(this.data, 1016);
    }

    public long smf42ggs() {
        return Util.ConvertUnsignedBinary4(this.data, 1020);
    }

    public long smf42ggt() {
        return Util.ConvertUnsignedBinary8(this.data, 1024);
    }

    public BigInteger smf42ggtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1024);
    }

    public long smf42ggu() {
        return Util.ConvertUnsignedBinary8(this.data, 1032);
    }

    public BigInteger smf42gguAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1032);
    }

    public Duration smf42ggw() {
        return Util.Binary8MSSeconds(this.data, 1056);
    }

    public double smf42ggwSeconds() {
        return Util.ToSeconds(this.smf42ggw());
    }

    public BigInteger smf42ggwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1056);
    }

    public Duration smf42ggx() {
        return Util.Binary4MS(this.data, 1064);
    }

    public double smf42ggxSeconds() {
        return Util.ToSeconds(this.smf42ggx());
    }

    public long smf42ggxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1064);
    }

    public Duration smf42ggy() {
        return Util.Binary4MS(this.data, 1068);
    }

    public double smf42ggySeconds() {
        return Util.ToSeconds(this.smf42ggy());
    }

    public long smf42ggyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1068);
    }

    public long smf42gha() {
        return Util.ConvertUnsignedBinary4(this.data, 1112);
    }

    public long smf42ghb() {
        return Util.ConvertUnsignedBinary4(this.data, 1116);
    }

    public long smf42ghc() {
        return Util.ConvertUnsignedBinary4(this.data, 1120);
    }

    public long smf42ghd() {
        return Util.ConvertUnsignedBinary4(this.data, 1124);
    }

    public long smf42ghe() {
        return Util.ConvertUnsignedBinary4(this.data, 1128);
    }

    public long smf42ghf() {
        return Util.ConvertUnsignedBinary4(this.data, 1132);
    }

    public long smf42ghg() {
        return Util.ConvertUnsignedBinary4(this.data, 1136);
    }

    public long smf42ghh() {
        return Util.ConvertUnsignedBinary4(this.data, 1140);
    }

    public long smf42ghi() {
        return Util.ConvertUnsignedBinary4(this.data, 1144);
    }

    public long smf42ghj() {
        return Util.ConvertUnsignedBinary4(this.data, 1148);
    }

    public long smf42ghk() {
        return Util.ConvertUnsignedBinary4(this.data, 1152);
    }

    public long smf42ghl() {
        return Util.ConvertUnsignedBinary4(this.data, 1156);
    }

    public long smf42ghm() {
        return Util.ConvertUnsignedBinary4(this.data, 1160);
    }

    public long smf42ghn() {
        return Util.ConvertUnsignedBinary4(this.data, 1164);
    }

    public long smf42gho() {
        return Util.ConvertUnsignedBinary4(this.data, 1168);
    }

    public long smf42ghp() {
        return Util.ConvertUnsignedBinary4(this.data, 1172);
    }

    public long smf42ghq() {
        return Util.ConvertUnsignedBinary8(this.data, 1176);
    }

    public BigInteger smf42ghqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1176);
    }

    public long smf42ghr() {
        return Util.ConvertUnsignedBinary4(this.data, 1184);
    }

    public long smf42ghs() {
        return Util.ConvertUnsignedBinary4(this.data, 1188);
    }

    public long smf42ght() {
        return Util.ConvertUnsignedBinary8(this.data, 1192);
    }

    public BigInteger smf42ghtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1192);
    }

    public long smf42ghu() {
        return Util.ConvertUnsignedBinary8(this.data, 1200);
    }

    public BigInteger smf42ghuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1200);
    }

    public Duration smf42ghw() {
        return Util.Binary8MSSeconds(this.data, 1224);
    }

    public double smf42ghwSeconds() {
        return Util.ToSeconds(this.smf42ghw());
    }

    public BigInteger smf42ghwRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1224);
    }

    public Duration smf42ghx() {
        return Util.Binary4MS(this.data, 1232);
    }

    public double smf42ghxSeconds() {
        return Util.ToSeconds(this.smf42ghx());
    }

    public long smf42ghxRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1232);
    }

    public Duration smf42ghy() {
        return Util.Binary4MS(this.data, 1236);
    }

    public double smf42ghySeconds() {
        return Util.ToSeconds(this.smf42ghy());
    }

    public long smf42ghyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 1236);
    }

    public long smf42gpa() {
        return Util.ConvertUnsignedBinary4(this.data, 1280);
    }

    public long smf42gpb() {
        return Util.ConvertUnsignedBinary4(this.data, 1284);
    }

    public long smf42gpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1288);
    }

    public long smf42gpd() {
        return Util.ConvertUnsignedBinary4(this.data, 1292);
    }

    public long smf42gpe() {
        return Util.ConvertUnsignedBinary4(this.data, 1296);
    }

    public long smf42gpf() {
        return Util.ConvertUnsignedBinary4(this.data, 1300);
    }

    public long smf42gua() {
        return Util.ConvertUnsignedBinary4(this.data, 1304);
    }

    public long smf42gub() {
        return Util.ConvertUnsignedBinary4(this.data, 1308);
    }

    public long smf42gph() {
        return Util.ConvertUnsignedBinary4(this.data, 1312);
    }

    public long smf42gpi() {
        return Util.ConvertUnsignedBinary4(this.data, 1316);
    }

    public long smf42gpj() {
        return Util.ConvertUnsignedBinary4(this.data, 1320);
    }

    public long smf42gpk() {
        return Util.ConvertUnsignedBinary4(this.data, 1324);
    }

    public long smf42gpl() {
        return Util.ConvertUnsignedBinary4(this.data, 1328);
    }

    public long smf42gpm() {
        return Util.ConvertUnsignedBinary4(this.data, 1332);
    }

    public long smf42gpn() {
        return Util.ConvertUnsignedBinary4(this.data, 1336);
    }

    public long smf42gpo() {
        return Util.ConvertUnsignedBinary4(this.data, 1340);
    }

    public long smf42gpp() {
        return Util.ConvertUnsignedBinary4(this.data, 1344);
    }

    public long smf42gpq() {
        return Util.ConvertUnsignedBinary4(this.data, 1348);
    }

    public long smf42gpr() {
        return Util.ConvertUnsignedBinary4(this.data, 1352);
    }

    public long smf42gps() {
        return Util.ConvertUnsignedBinary4(this.data, 1356);
    }

    public long smf42gpt() {
        return Util.ConvertUnsignedBinary4(this.data, 1360);
    }

    public long smf42gpu() {
        return Util.ConvertUnsignedBinary4(this.data, 1364);
    }

    public long smf42gpv() {
        return Util.ConvertUnsignedBinary4(this.data, 1368);
    }

    public long smf42gpw() {
        return Util.ConvertUnsignedBinary4(this.data, 1372);
    }

    public long smf42gud() {
        return Util.ConvertUnsignedBinary4(this.data, 1376);
    }

    public long smf42gue() {
        return Util.ConvertUnsignedBinary4(this.data, 1380);
    }

    public long smf42guf() {
        return Util.ConvertUnsignedBinary4(this.data, 1384);
    }

    public long smf42gug() {
        return Util.ConvertUnsignedBinary4(this.data, 1388);
    }

    public long smf42gsh() {
        return Util.ConvertUnsignedBinary4(this.data, 1392);
    }

    public long smf42gsi() {
        return Util.ConvertUnsignedBinary4(this.data, 1396);
    }

    public long smf42gsj() {
        return Util.ConvertUnsignedBinary4(this.data, 1400);
    }

    public long smf42gsk() {
        return Util.ConvertUnsignedBinary4(this.data, 1404);
    }

    public long smf42gra() {
        return Util.ConvertUnsignedBinary4(this.data, 1408);
    }

    public long smf42grb() {
        return Util.ConvertUnsignedBinary4(this.data, 1412);
    }

    public long smf42grc() {
        return Util.ConvertUnsignedBinary4(this.data, 1416);
    }

    public long smf42grd() {
        return Util.ConvertUnsignedBinary4(this.data, 1420);
    }

    public long smf42gre() {
        return Util.ConvertUnsignedBinary4(this.data, 1424);
    }

    public long smf42grg() {
        return Util.ConvertUnsignedBinary4(this.data, 1428);
    }

    public long smf42grh() {
        return Util.ConvertUnsignedBinary4(this.data, 1432);
    }

    public long smf42gri() {
        return Util.ConvertUnsignedBinary4(this.data, 1436);
    }

    public long smf42grw() {
        return Util.ConvertUnsignedBinary4(this.data, 1448);
    }

    public long smf42grj() {
        return Util.ConvertUnsignedBinary4(this.data, 1452);
    }

    public String smf42gy1() {
        return Util.ConvertEbcdic(this.data, 1456, 8);
    }

    public long smf42gsa() {
        return Util.ConvertUnsignedBinary4(this.data, 1456);
    }

    public long smf42gsb() {
        return Util.ConvertUnsignedBinary4(this.data, 1460);
    }

    public String smf42gaq() {
        return Util.ConvertEbcdic(this.data, 1472, 16);
    }

    public static DatasetSummaryBelowBar create(byte[] Data2, int offset, int length) {
        return new DatasetSummaryBelowBar(Data2, offset, length);
    }

    static enum Field {
        smf42gaa(0, 4),
        smf42gab(16, 44),
        smf42gac(64, 44),
        smf42gad(112, 2),
        smf42gae(114, 0),
        smf42a03(144, 2),
        smf42gaf(146, 0),
        smf42gah(178, 30),
        smf42gai(208, 4),
        smf42gaj(212, 12),
        smf42gak(224, 4),
        smf42gal(228, 4),
        smf42gam(232, 4),
        smf42gz1(236, 2),
        smf42gz2(238, 2),
        smf42gan(240, 8),
        smf42gao(248, 8),
        smf42gap(256, 16),
        smf42gca(272, 4),
        smf42gcb(276, 4),
        smf42gcc(280, 4),
        smf42gcd(284, 4),
        smf42gce(288, 4),
        smf42gcf(292, 4),
        smf42gcg(296, 4),
        smf42gch(300, 4),
        smf42gci(304, 4),
        smf42gcj(308, 4),
        smf42gck(312, 4),
        smf42gcl(316, 4),
        smf42gcm(320, 4),
        smf42gcn(324, 4),
        smf42gco(328, 4),
        smf42gcp(332, 4),
        smf42gcq(336, 8),
        smf42gcr(344, 4),
        smf42gcs(348, 4),
        smf42gct(352, 8),
        smf42gcu(360, 8),
        smf42gcw(384, 8),
        smf42gcx(392, 4),
        smf42gcy(396, 4),
        smf42gda(440, 4),
        smf42gdb(444, 4),
        smf42gdc(448, 4),
        smf42gdd(452, 4),
        smf42gde(456, 4),
        smf42gdf(460, 4),
        smf42gdg(464, 4),
        smf42gdh(468, 4),
        smf42gdi(472, 4),
        smf42gdj(476, 4),
        smf42gdk(480, 4),
        smf42gdl(484, 4),
        smf42gdm(488, 4),
        smf42gdn(492, 4),
        smf42gdo(496, 4),
        smf42gdp(500, 4),
        smf42gdq(504, 8),
        smf42gdr(512, 4),
        smf42gds(516, 4),
        smf42gdt(520, 8),
        smf42gdu(528, 8),
        smf42gdw(552, 8),
        smf42gdx(560, 4),
        smf42gdy(564, 4),
        smf42gea(608, 4),
        smf42geb(612, 4),
        smf42gec(616, 4),
        smf42ged(620, 4),
        smf42gee(624, 4),
        smf42gef(628, 4),
        smf42geg(632, 4),
        smf42geh(636, 4),
        smf42gei(640, 4),
        smf42gej(644, 4),
        smf42gek(648, 4),
        smf42gel(652, 4),
        smf42gem(656, 4),
        smf42gen(660, 4),
        smf42geo(664, 4),
        smf42gep(668, 4),
        smf42geq(672, 8),
        smf42ger(680, 4),
        smf42ges(684, 4),
        smf42get(688, 8),
        smf42geu(696, 8),
        smf42gew(720, 8),
        smf42gex(728, 4),
        smf42gey(732, 4),
        smf42gfa(776, 4),
        smf42gfb(780, 4),
        smf42gfc(784, 4),
        smf42gfd(788, 4),
        smf42gfe(792, 4),
        smf42gff(796, 4),
        smf42gfg(800, 4),
        smf42gfh(804, 4),
        smf42gfi(808, 4),
        smf42gfj(812, 4),
        smf42gfk(816, 4),
        smf42gfl(820, 4),
        smf42gfm(824, 4),
        smf42gfn(828, 4),
        smf42gfo(832, 4),
        smf42gfp(836, 4),
        smf42gfq(840, 8),
        smf42gfr(848, 4),
        smf42gfs(852, 4),
        smf42gft(856, 8),
        smf42gfu(864, 8),
        smf42gfw(888, 8),
        smf42gfx(896, 4),
        smf42gfy(900, 4),
        smf42gga(944, 4),
        smf42ggb(948, 4),
        smf42ggc(952, 4),
        smf42ggd(956, 4),
        smf42gge(960, 4),
        smf42ggf(964, 4),
        smf42ggg(968, 4),
        smf42ggh(972, 4),
        smf42ggi(976, 4),
        smf42ggj(980, 4),
        smf42ggk(984, 4),
        smf42ggl(988, 4),
        smf42ggm(992, 4),
        smf42ggn(996, 4),
        smf42ggo(1000, 4),
        smf42ggp(1004, 4),
        smf42ggq(1008, 8),
        smf42ggr(1016, 4),
        smf42ggs(1020, 4),
        smf42ggt(1024, 8),
        smf42ggu(1032, 8),
        smf42ggw(1056, 8),
        smf42ggx(1064, 4),
        smf42ggy(1068, 4),
        smf42gha(1112, 4),
        smf42ghb(1116, 4),
        smf42ghc(1120, 4),
        smf42ghd(1124, 4),
        smf42ghe(1128, 4),
        smf42ghf(1132, 4),
        smf42ghg(1136, 4),
        smf42ghh(1140, 4),
        smf42ghi(1144, 4),
        smf42ghj(1148, 4),
        smf42ghk(1152, 4),
        smf42ghl(1156, 4),
        smf42ghm(1160, 4),
        smf42ghn(1164, 4),
        smf42gho(1168, 4),
        smf42ghp(1172, 4),
        smf42ghq(1176, 8),
        smf42ghr(1184, 4),
        smf42ghs(1188, 4),
        smf42ght(1192, 8),
        smf42ghu(1200, 8),
        smf42ghw(1224, 8),
        smf42ghx(1232, 4),
        smf42ghy(1236, 4),
        smf42gpa(1280, 4),
        smf42gpb(1284, 4),
        smf42gpc(1288, 4),
        smf42gpd(1292, 4),
        smf42gpe(1296, 4),
        smf42gpf(1300, 4),
        smf42gua(1304, 4),
        smf42gub(1308, 4),
        smf42gph(1312, 4),
        smf42gpi(1316, 4),
        smf42gpj(1320, 4),
        smf42gpk(1324, 4),
        smf42gpl(1328, 4),
        smf42gpm(1332, 4),
        smf42gpn(1336, 4),
        smf42gpo(1340, 4),
        smf42gpp(1344, 4),
        smf42gpq(1348, 4),
        smf42gpr(1352, 4),
        smf42gps(1356, 4),
        smf42gpt(1360, 4),
        smf42gpu(1364, 4),
        smf42gpv(1368, 4),
        smf42gpw(1372, 4),
        smf42gud(1376, 4),
        smf42gue(1380, 4),
        smf42guf(1384, 4),
        smf42gug(1388, 4),
        smf42gsh(1392, 4),
        smf42gsi(1396, 4),
        smf42gsj(1400, 4),
        smf42gsk(1404, 4),
        smf42gra(1408, 4),
        smf42grb(1412, 4),
        smf42grc(1416, 4),
        smf42grd(1420, 4),
        smf42gre(1424, 4),
        smf42grg(1428, 4),
        smf42grh(1432, 4),
        smf42gri(1436, 4),
        smf42grw(1448, 4),
        smf42grj(1452, 4),
        smf42gy1(1456, 8),
        smf42gsa(1456, 4),
        smf42gsb(1460, 4),
        smf42gaq(1472, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

