/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype22;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class RmmAudit
extends SmfData {
    public static final int SMF42MLIS = 128;
    public static final int SMF42MJRN = 64;
    public static final int SMF420MA_LEN = 76;

    private RmmAudit(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf42mjbn() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public LocalTime smf42mrst() {
        return Util.Binary4x100STime(this.data, 8);
    }

    public long smf42mrstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public LocalDate smf42mrsd() {
        return Util.SMFDate(this.data, 12);
    }

    public int smf42mrsdRawValue() {
        return Util.ConvertPacked4(this.data, 12);
    }

    public String smf42muid() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf42mact() {
        return Util.ConvertEbcdic(this.data, 24, 1);
    }

    public int smf42mfg1() {
        return Util.ConvertUnsignedBinary1(this.data, 25);
    }

    public boolean smf42mlis() {
        return Util.ConvertFlag(this.data, this.smf42mfg1(), 128);
    }

    public boolean smf42mjrn() {
        return Util.ConvertFlag(this.data, this.smf42mfg1(), 64);
    }

    public int smf42mcvtsflg() {
        return Util.ConvertUnsignedBinary1(this.data, 26);
    }

    public int smf42mcenable() {
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public ZoneOffset smf42mldto() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 28);
    }

    public long smf42mldtoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 28);
    }

    public long smf42mcjnrecn() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf42mjnrecnum() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smf42mcupdvsi() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smf42mcvsicnt() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public String smf42mcvrlctk() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public long smf42mcvrscnt() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf42mcvrsrun() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public String smf42mcsyncts() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public LocalDate smf42mcsyncdt() {
        return Util.SMFDate(this.data, 68);
    }

    public int smf42mcsyncdtRawValue() {
        return Util.ConvertPacked4(this.data, 68);
    }

    public LocalTime smf42mcsynctm() {
        return Util.Binary4x100STime(this.data, 72);
    }

    public long smf42mcsynctmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public static RmmAudit create(byte[] Data2, int offset, int length) {
        return new RmmAudit(Data2, offset, length);
    }

    static enum Field {
        smf42mjbn(0, 8),
        smf42mrst(8, 4),
        smf42mrsd(12, 4),
        smf42muid(16, 8),
        smf42mact(24, 1),
        smf42mfg1(25, 1),
        smf42mcvtsflg(26, 1),
        smf42mcenable(27, 1),
        smf42mldto(28, 8),
        smf42mcjnrecn(36, 4),
        smf42mjnrecnum(40, 4),
        smf42mcupdvsi(44, 4),
        smf42mcvsicnt(48, 4),
        smf42mcvrlctk(52, 8),
        smf42mcvrscnt(60, 4),
        smf42mcvrsrun(64, 4),
        smf42mcsyncts(68, 8),
        smf42mcsyncdt(68, 4),
        smf42mcsynctm(72, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

