/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype5;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf42.subtype5.BackgroundActivity;
import com.blackhillsoftware.smf.smf42.subtype5.SystemIo;
import com.blackhillsoftware.smf.smf42.subtype5.VolumeMetrics;
import com.blackhillsoftware.smf.smf42.subtype5.VtocDataIoStatistics;
import com.blackhillsoftware.smf.smf42.subtype5.VtocIndexIoStatistics;
import com.blackhillsoftware.smf.smf42.subtype5.VvdsIoStatistics;
import java.util.List;

public final class VolumeHeader
extends SmfData {
    public static final int S42VTONL = 128;
    public static final int S42VTSMS = 64;
    public static final int S42VTTP = 32;
    private VtocDataIoStatistics m_vtocDataIoStatistics = null;
    private VtocIndexIoStatistics m_vtocIndexIoStatistics = null;
    private VvdsIoStatistics m_vvdsIoStatistics = null;
    private List<VolumeMetrics> m_VolumeMetrics = null;
    private List<SystemIo> m_SystemIo = null;
    private List<BackgroundActivity> m_BackgroundActivity = null;

    private VolumeHeader(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        if (this.s42vtvdo() != 0) {
            this.m_vtocDataIoStatistics = VtocDataIoStatistics.create(Data2, this.s42vtvdo(), this.s42vtvdl());
        }
        if (this.s42vtvxo() != 0) {
            this.m_vtocIndexIoStatistics = VtocIndexIoStatistics.create(Data2, this.s42vtvxo(), this.s42vtvxl());
        }
        if (this.s42vtvvo() != 0) {
            this.m_vvdsIoStatistics = VvdsIoStatistics.create(Data2, this.s42vtvvo(), this.s42vtvvl());
        }
    }

    public int s42vtnxt() {
        return Util.ConvertSignedBinary4(this.data, 0);
    }

    public String s42vtser() {
        return Util.ConvertEbcdic(this.data, 4, 6);
    }

    public int s42vtadr() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int s42vtfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public boolean s42vtonl() {
        return Util.ConvertFlag(this.data, this.s42vtfl1(), 128);
    }

    public boolean s42vtsms() {
        return Util.ConvertFlag(this.data, this.s42vtfl1(), 64);
    }

    public boolean s42vttp() {
        return Util.ConvertFlag(this.data, this.s42vtfl1(), 32);
    }

    public long s42vtunc() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public int s42vtvdo() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int s42vtvdl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int s42vtvxo() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int s42vtvxl() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int s42vtvvo() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    public int s42vtvvl() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int s42vtmco() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    public int s42vtmcl() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int s42vtmcn() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public int s42vtsyo() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public int s42vtsyl() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int s42vtsyn() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int s42vtbgo() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public int s42vtbgl() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int s42vtbgn() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public VtocDataIoStatistics vtocDataIoStatistics() {
        return this.m_vtocDataIoStatistics;
    }

    public VtocIndexIoStatistics vtocIndexIoStatistics() {
        return this.m_vtocIndexIoStatistics;
    }

    public VvdsIoStatistics vvdsIoStatistics() {
        return this.m_vvdsIoStatistics;
    }

    public List<VolumeMetrics> volumeMetrics() {
        this.m_VolumeMetrics = Util.sectionsFromTriplet(this.m_VolumeMetrics, this.data, () -> this.s42vtmco(), () -> this.s42vtmcl(), () -> this.s42vtmcn(), VolumeMetrics::create);
        return this.m_VolumeMetrics;
    }

    public List<SystemIo> SystemIo() {
        this.m_SystemIo = Util.sectionsFromTriplet(this.m_SystemIo, this.data, () -> this.s42vtsyo(), () -> this.s42vtsyl(), () -> this.s42vtsyn(), SystemIo::create);
        return this.m_SystemIo;
    }

    public List<BackgroundActivity> backgroundActivity() {
        this.m_BackgroundActivity = Util.sectionsFromTriplet(this.m_BackgroundActivity, this.data, () -> this.s42vtbgo(), () -> this.s42vtbgl(), () -> this.s42vtbgn(), BackgroundActivity::create);
        return this.m_BackgroundActivity;
    }

    public static VolumeHeader create(byte[] Data2, int offset, int length) {
        return new VolumeHeader(Data2, offset, length);
    }

    static enum Field {
        s42vtnxt(0, 4),
        s42vtser(4, 6),
        s42vtadr(10, 2),
        s42vtfl1(12, 1),
        s42vtunc(20, 4),
        s42vtvdo(24, 4),
        s42vtvdl(28, 2),
        s42vtvxo(32, 4),
        s42vtvxl(36, 2),
        s42vtvvo(40, 4),
        s42vtvvl(44, 2),
        s42vtmco(48, 4),
        s42vtmcl(52, 2),
        s42vtmcn(54, 2),
        s42vtsyo(56, 4),
        s42vtsyl(60, 2),
        s42vtsyn(62, 2),
        s42vtbgo(64, 4),
        s42vtbgl(68, 2),
        s42vtbgn(70, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

