/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype5;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class VolumeMetrics
extends SmfData {
    public static final int S42VRERA = 128;

    private VolumeMetrics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long s42vrid1() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long s42vrid2() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long s42vrid3() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long s42vrid4() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long s42vrid5() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long s42vrid6() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration s42vridm() {
        return Util.Binary4US(this.data, 28);
    }

    public double s42vridmSeconds() {
        return Util.ToSeconds(this.s42vridm());
    }

    public long s42vridmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public ZonedDateTime s42vridt() {
        return Util.Binary8xStckTime(this.data, 32);
    }

    public BigInteger s42vridtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public Duration s42vrida() {
        return Util.Binary4US(this.data, 40);
    }

    public double s42vridaSeconds() {
        return Util.ToSeconds(this.s42vrida());
    }

    public long s42vridaRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public Duration s42vrbsy() {
        return Util.Binary2Seconds(this.data, 44);
    }

    public double s42vrbsySeconds() {
        return Util.ToSeconds(this.s42vrbsy());
    }

    public int s42vrbsyRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public long s42vrrsp() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long s42vrrsn() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration s42vrres() {
        return Util.Binary4US(this.data, 56);
    }

    public double s42vrresSeconds() {
        return Util.ToSeconds(this.s42vrres());
    }

    public long s42vrresRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public Duration s42vrrex() {
        return Util.Binary4US(this.data, 60);
    }

    public double s42vrrexSeconds() {
        return Util.ToSeconds(this.s42vrrex());
    }

    public long s42vrrexRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public Duration s42vrrsr() {
        return Util.Binary4US(this.data, 64);
    }

    public double s42vrrsrSeconds() {
        return Util.ToSeconds(this.s42vrrsr());
    }

    public long s42vrrsrRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long s42vrer1() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long s42vrer2() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long s42vrer3() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long s42vrer4() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long s42vrer5() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public int s42vrer6() {
        return Util.ConvertUnsignedBinary1(this.data, 88);
    }

    public boolean s42vrera() {
        return Util.ConvertFlag(this.data, this.s42vrer6(), 128);
    }

    public static VolumeMetrics create(byte[] Data2, int offset, int length) {
        return new VolumeMetrics(Data2, offset, length);
    }

    static enum Field {
        s42vrid1(0, 4),
        s42vrid2(4, 4),
        s42vrid3(8, 4),
        s42vrid4(12, 4),
        s42vrid5(16, 4),
        s42vrid6(20, 4),
        s42vridm(28, 4),
        s42vridt(32, 8),
        s42vrida(40, 4),
        s42vrbsy(44, 2),
        s42vrrsp(48, 4),
        s42vrrsn(52, 4),
        s42vrres(56, 4),
        s42vrrex(60, 4),
        s42vrrsr(64, 4),
        s42vrer1(68, 4),
        s42vrer2(72, 4),
        s42vrer3(76, 4),
        s42vrer4(80, 4),
        s42vrer5(84, 4),
        s42vrer6(88, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

