/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf42.subtype6;

import java.util.HashMap;
import java.util.Map;

public enum S42Dstype {
    OTHER(0),
    PHYSICAL_SEQUENTIAL(1),
    PDS(2),
    PDSE(3),
    DIRECT_ACCESS(4),
    ISAM(5),
    EXCP(6),
    EXTENDED_PHYSICAL_SEQUENTIAL(7),
    HFS(10),
    KSDS_DATA(16),
    KSDS_INDEX(17),
    VARIABLE_RRDS_DATA(18),
    VARIABLE_RRDS_INDEX(19),
    FIXED_RRDS(20),
    LINEAR(21),
    ESDS(22),
    UNKNOWN(-1);

    private static Map<Integer, S42Dstype> valueMap;
    private final transient int dsType;

    private S42Dstype(int id) {
        this.dsType = id;
    }

    public static S42Dstype forDstypeId(int id) {
        S42Dstype result = valueMap.get(id);
        if (result == null) {
            return UNKNOWN;
        }
        return result;
    }

    public int dsTypeId() {
        return this.dsType;
    }

    static {
        valueMap = new HashMap<Integer, S42Dstype>();
        for (S42Dstype x : S42Dstype.values()) {
            if (x.dsTypeId() == -1) continue;
            valueMap.put(x.dsType, x);
        }
    }
}

