/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf6.MultiBinsCounterSection;
import com.blackhillsoftware.smf.smf6.MultiBinsHeaderSection;
import java.util.ArrayList;
import java.util.List;

public final class ApaPrintingSection
extends SmfData {
    private MultiBinsHeaderSection m_multiBinsHeaderSection = null;
    private List<MultiBinsCounterSection> m_multiBinsCounterSection = null;
    public static final int SMF6BIN1 = 128;
    public static final int SMF6BIN2 = 64;
    public static final int SMF6BIN3 = 32;
    public static final int SMF6BIN4 = 16;
    public static final int SMF6DUPS = 128;
    public static final int SMF6DUPT = 64;
    public static final int SMF6SYSA = 32;
    public static final int SMF6DPGL = 16;
    public static final int SMF6SUCC = 8;
    public static final int SMF6SPGL = 4;
    public static final int SMF6SOER = 2;
    public static final int SMF6IGER = 1;
    public static final int SMF6SLIG = 128;
    public static final int SMF6JHPP = 64;
    public static final int SMF6JTPP = 32;
    public static final int SMF6DPLS = 16;
    public static final int SMF6UPAS = 8;
    public static final int SMF6APA1 = 1;

    private ApaPrintingSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public MultiBinsHeaderSection multiBinsHeaderSection() {
        if (this.m_multiBinsHeaderSection == null) {
            this.m_multiBinsHeaderSection = MultiBinsHeaderSection.create(this.data, this.smf6bnof(), MultiBinsHeaderSection.findLength());
        }
        return this.m_multiBinsHeaderSection;
    }

    public List<MultiBinsCounterSection> multiBinsCounterSections() {
        if (this.m_multiBinsCounterSection == null) {
            MultiBinsHeaderSection multiBinHeader = this.multiBinsHeaderSection();
            this.m_multiBinsCounterSection = new ArrayList<MultiBinsCounterSection>(multiBinHeader.smf6bnum());
            int offset = this.smf6bnof() + MultiBinsHeaderSection.findLength();
            int length = MultiBinsCounterSection.findLength();
            for (int i = 0; i < multiBinHeader.smf6bnum(); ++i) {
                this.m_multiBinsCounterSection.add(MultiBinsCounterSection.create(this.data, offset, length));
                offset += length;
            }
        }
        return this.m_multiBinsCounterSection;
    }

    public int smf6ln4() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf6bnof() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf6res() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public long smf6font() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf6lfnt() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf6ovly() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf6loly() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf6pgsg() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf6lpsg() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smf6imps() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smf6feet() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf6pgdf() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smf6fmdf() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public int smf6bin() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public boolean smf6bin1() {
        return Util.ConvertFlag(this.data, this.smf6bin(), 128);
    }

    public boolean smf6bin2() {
        return Util.ConvertFlag(this.data, this.smf6bin(), 64);
    }

    public boolean smf6bin3() {
        return Util.ConvertFlag(this.data, this.smf6bin(), 32);
    }

    public boolean smf6bin4() {
        return Util.ConvertFlag(this.data, this.smf6bin(), 16);
    }

    public int smf6pgop() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public boolean smf6dups() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 128);
    }

    public boolean smf6dupt() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 64);
    }

    public boolean smf6sysa() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 32);
    }

    public boolean smf6dpgl() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 16);
    }

    public boolean smf6succ() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 8);
    }

    public boolean smf6spgl() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 4);
    }

    public boolean smf6soer() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 2);
    }

    public boolean smf6iger() {
        return Util.ConvertFlag(this.data, this.smf6pgop(), 1);
    }

    public int smf6flg3() {
        return Util.ConvertUnsignedBinary1(this.data, 46);
    }

    public boolean smf6slig() {
        return Util.ConvertFlag(this.data, this.smf6flg3(), 128);
    }

    public boolean smf6jhpp() {
        return Util.ConvertFlag(this.data, this.smf6flg3(), 64);
    }

    public boolean smf6jtpp() {
        return Util.ConvertFlag(this.data, this.smf6flg3(), 32);
    }

    public boolean smf6dpls() {
        return Util.ConvertFlag(this.data, this.smf6flg3(), 16);
    }

    public boolean smf6upas() {
        return Util.ConvertFlag(this.data, this.smf6flg3(), 8);
    }

    public int smf6apal() {
        return Util.ConvertUnsignedBinary1(this.data, 47);
    }

    public long smf6nsol() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf6nsfo() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smf6nsps() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public String smf6fdnm() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public String smf6pdnm() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public String smf6ptdv() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String smf6ocnm() {
        return Util.ConvertEbcdic(this.data, 84, 32);
    }

    public String smf6setu() {
        return Util.ConvertEbcdic(this.data, 84, 8);
    }

    public long smf6lpge() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf6dsht() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf6ssht() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf6nup1() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long smf6nup2() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long smf6nup3() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long smf6nup4() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public static ApaPrintingSection create(byte[] Data2, int offset, int length) {
        return new ApaPrintingSection(Data2, offset, length);
    }

    static enum Field {
        smf6ln4(0, 2),
        smf6bnof(2, 2),
        smf6res(2, 2),
        smf6font(4, 4),
        smf6lfnt(8, 4),
        smf6ovly(12, 4),
        smf6loly(16, 4),
        smf6pgsg(20, 4),
        smf6lpsg(24, 4),
        smf6imps(28, 4),
        smf6feet(32, 4),
        smf6pgdf(36, 4),
        smf6fmdf(40, 4),
        smf6bin(44, 1),
        smf6pgop(45, 1),
        smf6flg3(46, 1),
        smf6apal(47, 1),
        smf6nsol(48, 4),
        smf6nsfo(52, 4),
        smf6nsps(56, 4),
        smf6fdnm(60, 8),
        smf6pdnm(68, 8),
        smf6ptdv(76, 8),
        smf6ocnm(84, 32),
        smf6setu(84, 8),
        smf6lpge(116, 4),
        smf6dsht(120, 4),
        smf6ssht(124, 4),
        smf6nup1(128, 4),
        smf6nup2(132, 4),
        smf6nup3(136, 4),
        smf6nup4(140, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

