/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf6;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;

public final class FileTransferSection
extends SmfData {
    public static final int SMF6FTL1 = 1;
    public static final int SMF6FTL2 = 2;
    public static final int SMF6FTL3 = 3;

    private FileTransferSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf6ln6() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public long smf6byte() {
        return Util.ConvertUnsignedBinary4(this.data, 2);
    }

    public InetAddress smf6ipv4() {
        return Util.ConvertInetV4Address(this.data, 6);
    }

    public BigInteger smf6ipv4RawValue() {
        return Util.ConvertBigInteger(this.data, 6, 4);
    }

    public int smf6ip1() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public int smf6ip2() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public int smf6ip3() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf6ip4() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public int smf6ftl() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public int smf6port() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public int smf6pqln() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public String smf6prtq() {
        if (this.data.length >= 24 + this.smf6pqln()) {
            return Util.ConvertEbcdic(this.data, 24, this.smf6pqln());
        }
        return null;
    }

    public long smf6bytd() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf6bytdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf6hwrd() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smf6lwrd() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public InetAddress smf6ipv6() {
        return Util.ConvertInetV6Address(this.data, 56);
    }

    public BigInteger smf6ipv6RawValue() {
        return Util.ConvertBigInteger(this.data, 56, 16);
    }

    public int smf6uril() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public String smf6uri() {
        if (this.data.length >= 74 + this.smf6uril()) {
            return Util.ConvertEbcdic(this.data, 74, this.smf6uril());
        }
        return null;
    }

    public int smf6actl() {
        return Util.ConvertUnsignedBinary2(this.data, 332);
    }

    public String smf6acct() {
        if (this.data.length >= 334 + this.smf6actl()) {
            return Util.ConvertEbcdic(this.data, 334, this.smf6actl());
        }
        return null;
    }

    public static FileTransferSection create(byte[] Data2, int offset, int length) {
        return new FileTransferSection(Data2, offset, length);
    }

    static enum Field {
        smf6ln6(0, 2),
        smf6byte(2, 4),
        smf6ipv4(6, 4),
        smf6ip1(6, 1),
        smf6ip2(7, 1),
        smf6ip3(8, 1),
        smf6ip4(9, 1),
        smf6ftl(10, 1),
        smf6port(12, 2),
        smf6pqln(22, 2),
        smf6prtq(24, 0),
        smf6bytd(48, 8),
        smf6hwrd(48, 4),
        smf6lwrd(52, 4),
        smf6ipv6(56, 16),
        smf6uril(72, 2),
        smf6uri(74, 0),
        smf6actl(332, 2),
        smf6acct(334, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

