/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf66;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf60.EntryType;
import com.blackhillsoftware.smf.smf66.CatalogRecord;
import com.blackhillsoftware.smf.smf66.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf66Record
extends SmfRecord {
    public static final int SMF66SLF = 24;
    public static final int SMF66PRD = 40;
    public static final int SMF66DAT = 50;

    public Smf66Record(byte[] data) {
        super(data);
        this.checkRecord();
    }

    public Smf66Record(SmfRecord record) {
        super(record);
        this.checkRecord();
    }

    public static Smf66Record from(SmfRecord record) {
        return new Smf66Record(record);
    }

    public static Smf66Record from(byte[] data) {
        return new Smf66Record(data);
    }

    private void checkRecord() {
        if (this.recordType() != 66) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        if (this.smf66pno() > 1) {
            throw new IllegalArgumentException("Multiple product sections found: " + Integer.toString(this.smf66pno()));
        }
        if (this.smf66dno() > 1) {
            throw new IllegalArgumentException("Multiple data sections found: " + Integer.toString(this.smf66dno()));
        }
    }

    public int smf66len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf66seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf66sys() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf66rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf66tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf66tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf66dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf66dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf66cpu() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf66sid() {
        return Util.ConvertEbcdic(this.data, 14, 2);
    }

    public String smf66mod() {
        return Util.ConvertEbcdic(this.data, 16, 2);
    }

    public String smf66sub() {
        return Util.ConvertEbcdic(this.data, 22, 2);
    }

    public int smf66pof() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smf66pln() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf66pno() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf66dof() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int smf66dln() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf66dno() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public String smf66ver() {
        return Util.ConvertEbcdic(this.data, 40, 2);
    }

    public String smf66pnm() {
        return Util.ConvertEbcdic(this.data, 42, 8);
    }

    public String smf66jnm() {
        return Util.ConvertEbcdic(this.data, 50, 8);
    }

    public LocalTime smf66rst() {
        return Util.Binary4x100STime(this.data, 58);
    }

    public long smf66rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 58);
    }

    public LocalDate smf66rdt() {
        return Util.SMFDate(this.data, 62);
    }

    public int smf66rdtRawValue() {
        return Util.ConvertPacked4(this.data, 62);
    }

    public String smf66uid() {
        return Util.ConvertEbcdic(this.data, 66, 8);
    }

    public String smf66fnc() {
        return Util.ConvertEbcdic(this.data, 74, 1);
    }

    public String smf66cnm() {
        return Util.ConvertEbcdic(this.data, 75, 44);
    }

    public int smf66typ() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public EntryType smf66EntryType() {
        return EntryType.fromInt(this.smf66typ());
    }

    public String smf66enm() {
        return Util.ConvertEbcdic(this.data, 120, 44);
    }

    public String smf66nnm() {
        return Util.ConvertEbcdic(this.data, 164, 44);
    }

    public CatalogRecord smf65crc() {
        int offset = this.smf66dof() + this.smf66dln();
        int length = CatalogRecord.smf66crl(this.data, offset);
        return CatalogRecord.create(this.data, offset, length);
    }

    public Timestamp timestamp() {
        int offset = this.smf66dof() + this.smf66dln();
        offset += CatalogRecord.smf66crl(this.data, offset);
        int length = Timestamp.Field.smf66ets.length();
        return Timestamp.create(this.data, offset, length);
    }

    static enum Field {
        smf66len(0, 2),
        smf66seg(2, 2),
        smf66sys(4, 1),
        smf66rty(5, 1),
        smf66tme(6, 4),
        smf66dte(10, 4),
        smf66cpu(14, 4),
        smf66sid(14, 2),
        smf66mod(16, 2),
        smf66sub(22, 2),
        smf66pof(24, 4),
        smf66pln(28, 2),
        smf66pno(30, 2),
        smf66dof(32, 4),
        smf66dln(36, 2),
        smf66dno(38, 2),
        smf66ver(40, 2),
        smf66pnm(42, 8),
        smf66jnm(50, 8),
        smf66rst(58, 4),
        smf66rdt(62, 4),
        smf66uid(66, 8),
        smf66fnc(74, 1),
        smf66cnm(75, 44),
        smf66typ(119, 1),
        smf66enm(120, 44),
        smf66nnm(164, 44),
        smf66crc(208, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

