/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class CpuDataSection
extends SmfData {
    public static final int SMF70MTI = 16;
    public static final int SMF70DCI = 8;
    public static final int SMF70PAR = 4;
    public static final int SMF70VAC = 2;
    public static final int SMF70STA = 1;
    public static final int SMF70VON = 128;
    public static final int SMF70TCP = 0;
    public static final int SMF70TIF = 1;
    public static final int SMF70TSU = 2;

    private CpuDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf70wat() {
        return Util.Binary8StckInterval(this.data, 0);
    }

    public double smf70watSeconds() {
        return Util.ToSeconds(this.smf70wat());
    }

    public long smf70watRawValue() {
        return Util.ConvertSignedBinary8(this.data, 0);
    }

    public int smf70cid() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int smf70cnf() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean smf70mti() {
        return Util.ConvertFlag(this.data, this.smf70cnf(), 16);
    }

    public boolean smf70dci() {
        return Util.ConvertFlag(this.data, this.smf70cnf(), 8);
    }

    public boolean smf70par() {
        return Util.ConvertFlag(this.data, this.smf70cnf(), 4);
    }

    public boolean smf70vac() {
        return Util.ConvertFlag(this.data, this.smf70cnf(), 2);
    }

    public boolean smf70sta() {
        return Util.ConvertFlag(this.data, this.smf70cnf(), 1);
    }

    public int smf70rv3() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public int smf70ser() {
        return Util.ConvertUnsignedBinary3(this.data, 12);
    }

    public int smf70typ() {
        return Util.ConvertUnsignedBinary1(this.data, 15);
    }

    public long smf70slh() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf70tpi() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf70vfs() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf70v() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public boolean smf70von() {
        return Util.ConvertFlag(this.data, this.smf70v(), 128);
    }

    public String smf70cpm() {
        return Util.ConvertEbcdic(this.data, 29, 3);
    }

    public Duration smf70pat() {
        return Util.Binary8StckInterval(this.data, 32);
    }

    public double smf70patSeconds() {
        return Util.ToSeconds(this.smf70pat());
    }

    public long smf70patRawValue() {
        return Util.ConvertSignedBinary8(this.data, 32);
    }

    public long smf70tcb() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf70tcbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf70srb() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf70srbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf70nio() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf70nioAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf70sig() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf70sigAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf70wtd() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf70wtdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf70wts() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf70wtu() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public Duration smf70wti() {
        return Util.Binary4MS(this.data, 88);
    }

    public double smf70wtiSeconds() {
        return Util.ToSeconds(this.smf70wti());
    }

    public long smf70wtiRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public boolean smf70tcp() {
        return Util.ConvertEquateValue(this.data, this.smf70typ(), 0);
    }

    public boolean smf70tif() {
        return Util.ConvertEquateValue(this.data, this.smf70typ(), 1);
    }

    public boolean smf70tsu() {
        return Util.ConvertEquateValue(this.data, this.smf70typ(), 2);
    }

    public static CpuDataSection create(byte[] Data2, int offset, int length) {
        return new CpuDataSection(Data2, offset, length);
    }

    static enum Field {
        smf70wat(0, 8),
        smf70cid(8, 2),
        smf70cnf(10, 1),
        smf70rv3(11, 1),
        smf70ser(12, 3),
        smf70typ(15, 1),
        smf70slh(16, 4),
        smf70tpi(20, 4),
        smf70vfs(24, 4),
        smf70v(28, 1),
        smf70cpm(29, 3),
        smf70pat(32, 8),
        smf70tcb(40, 8),
        smf70srb(48, 8),
        smf70nio(56, 8),
        smf70sig(64, 8),
        smf70wtd(72, 8),
        smf70wts(80, 4),
        smf70wtu(84, 4),
        smf70wti(88, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

