/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype1;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class PrismLogicalProcessorDataSection
extends SmfData {
    public static final int SMF70WSA = 128;
    public static final int SMF70WSC = 64;
    public static final int SMF70RSC = 32;
    public static final int SMF70CAP = 16;
    public static final int SMF70CPC = 8;
    public static final int SMF70LPO = 4;
    public static final int SMF70HCC = 2;
    public static final int SMF70HGC = 1;
    public static final int SMF70POI = 192;
    public static final int SMF70POC = 32;
    public static final int SMF70TopoC = 128;

    private PrismLogicalProcessorDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf70pdt() {
        return Util.Binary8USSeconds(this.data, 0);
    }

    public double smf70pdtSeconds() {
        return Util.ToSeconds(this.smf70pdt());
    }

    public BigInteger smf70pdtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public int smf70vpa() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int smf70bps() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int smf70vpf() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public boolean smf70wsa() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 128);
    }

    public boolean smf70wsc() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 64);
    }

    public boolean smf70rsc() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 32);
    }

    public boolean smf70cap() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 16);
    }

    public boolean smf70cpc() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 8);
    }

    public boolean smf70lpo() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 4);
    }

    public boolean smf70hcc() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 2);
    }

    public boolean smf70hgc() {
        return Util.ConvertFlag(this.data, this.smf70vpf(), 1);
    }

    public int smf70pof() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public boolean smf70poc() {
        return Util.ConvertFlag(this.data, this.smf70pof(), 32);
    }

    public int smf70cix() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public Duration smf70edt() {
        return Util.Binary8USSeconds(this.data, 16);
    }

    public double smf70edtSeconds() {
        return Util.ToSeconds(this.smf70edt());
    }

    public BigInteger smf70edtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf70acs() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf70mis() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf70mas() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public long smf70nsi() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smf70nsa() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration smf70ont() {
        return Util.Binary8USSeconds(this.data, 40);
    }

    public double smf70ontSeconds() {
        return Util.ToSeconds(this.smf70ont());
    }

    public BigInteger smf70ontRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public Duration smf70wst() {
        return Util.Binary8USSeconds(this.data, 48);
    }

    public double smf70wstSeconds() {
        return Util.ToSeconds(this.smf70wst());
    }

    public BigInteger smf70wstRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf70pma() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smf70nsw() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smf70pow() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smf70nca() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long smf70hwCapLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long smf70hwgrCapLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public Duration smf70mtit() {
        return Util.Binary8USSeconds(this.data, 80);
    }

    public double smf70mtitSeconds() {
        return Util.ToSeconds(this.smf70mtit());
    }

    public BigInteger smf70mtitRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public int smf70lpf() {
        return Util.ConvertUnsignedBinary1(this.data, 88);
    }

    public boolean smf70topoC() {
        return Util.ConvertFlag(this.data, this.smf70lpf(), 128);
    }

    public int smf70maxNL() {
        return Util.ConvertUnsignedBinary1(this.data, 89);
    }

    public int smf70cordL1() {
        return Util.ConvertUnsignedBinary1(this.data, 90);
    }

    public int smf70cordL2() {
        return Util.ConvertUnsignedBinary1(this.data, 91);
    }

    public int smf70cordL3() {
        return Util.ConvertUnsignedBinary1(this.data, 92);
    }

    public int smf70cordL4() {
        return Util.ConvertUnsignedBinary1(this.data, 93);
    }

    public int smf70cordL5() {
        return Util.ConvertUnsignedBinary1(this.data, 94);
    }

    public int smf70cordL6() {
        return Util.ConvertUnsignedBinary1(this.data, 95);
    }

    public static PrismLogicalProcessorDataSection create(byte[] Data2, int offset, int length) {
        return new PrismLogicalProcessorDataSection(Data2, offset, length);
    }

    static enum Field {
        smf70pdt(0, 8),
        smf70vpa(8, 2),
        smf70bps(10, 2),
        smf70vpf(12, 1),
        smf70pof(13, 1),
        smf70cix(14, 2),
        smf70edt(16, 8),
        smf70acs(24, 4),
        smf70mis(28, 2),
        smf70mas(30, 2),
        smf70nsi(32, 4),
        smf70nsa(36, 4),
        smf70ont(40, 8),
        smf70wst(48, 8),
        smf70pma(56, 4),
        smf70nsw(60, 4),
        smf70pow(64, 4),
        smf70nca(68, 4),
        smf70hwCapLimit(72, 4),
        smf70hwgrCapLimit(76, 4),
        smf70mtit(80, 8),
        smf70lpf(88, 1),
        smf70maxNL(89, 1),
        smf70cordL1(90, 1),
        smf70cordL2(91, 1),
        smf70cordL3(92, 1),
        smf70cordL4(93, 1),
        smf70cordL5(94, 1),
        smf70cordL6(95, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

