/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype2;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf70.subtype2.CryptographicTimersCounters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CryptographicAcceleratorDataSection
extends SmfData {
    private List<CryptographicTimersCounters> m_r7024tc = null;
    public static final int R7021KM = 128;
    public static final int R7022KM = 64;
    public static final int R7021KC = 32;
    public static final int R7022KC = 16;
    public static final int R7023KM = 8;
    public static final int R7023KC = 4;
    public static final int R702NENG = 5;

    private CryptographicAcceleratorDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<CryptographicTimersCounters> r7024tc() {
        if (this.m_r7024tc != null) {
            return this.m_r7024tc;
        }
        if (this.r7024en() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<CryptographicTimersCounters> result = new ArrayList<CryptographicTimersCounters>((int)this.r7024en());
        int length = Field._R7024TC.length() / 5;
        for (int i = 0; i < (int)this.r7024en(); ++i) {
            result.add(CryptographicTimersCounters.create(this.data, Field._R7024TC.offset() + length * i, length, this.r7024sf()));
        }
        this.m_r7024tc = Collections.unmodifiableList(result);
        return this.m_r7024tc;
    }

    public int r7024ax() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int r7024ct() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int r7024msk() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r7021km() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 128);
    }

    public boolean r7022km() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 64);
    }

    public boolean r7021kc() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 32);
    }

    public boolean r7022kc() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 16);
    }

    public boolean r7023km() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 8);
    }

    public boolean r7023kc() {
        return Util.ConvertFlag(this.data, this.r7024msk(), 4);
    }

    public int r7024mt() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public long r7024en() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public double r7024sf() {
        return Util.ConvertLongFPHex(this.data, 8);
    }

    byte[] _R7024TC() {
        if (this.data.length >= 336) {
            byte[] result = new byte[320];
            System.arraycopy(this.data, 16, result, 0, 320);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(16) + " Data length: " + Integer.toString(320));
    }

    public Duration r7023met() {
        return Util.LongFPHex_SecondsScaled(this.data, 336, this.r7024sf());
    }

    public double r7023metSeconds() {
        return this.r7023metRawValue() * this.r7024sf();
    }

    public double r7023metRawValue() {
        return Util.ConvertLongFPHex(this.data, 336);
    }

    public double r7023mec() {
        return Util.ConvertLongFPHex(this.data, 344);
    }

    public Duration r7023crt() {
        return Util.LongFPHex_SecondsScaled(this.data, 352, this.r7024sf());
    }

    public double r7023crtSeconds() {
        return this.r7023crtRawValue() * this.r7024sf();
    }

    public double r7023crtRawValue() {
        return Util.ConvertLongFPHex(this.data, 352);
    }

    public double r7023crc() {
        return Util.ConvertLongFPHex(this.data, 360);
    }

    public int r7024scope() {
        return Util.ConvertUnsignedBinary1(this.data, 368);
    }

    public int r7024did() {
        return Util.ConvertUnsignedBinary1(this.data, 369);
    }

    public static CryptographicAcceleratorDataSection create(byte[] Data2, int offset, int length) {
        return new CryptographicAcceleratorDataSection(Data2, offset, length);
    }

    static enum Field {
        r7024ax(0, 1),
        r7024ct(1, 1),
        r7024msk(2, 1),
        r7024mt(3, 1),
        r7024en(4, 4),
        r7024sf(8, 8),
        _R7024TC(16, 320),
        r7023met(336, 8),
        r7023mec(344, 8),
        r7023crt(352, 8),
        r7023crc(360, 8),
        r7024scope(368, 1),
        r7024did(369, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

