/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf70.subtype2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class CryptographicPkcs11CoprocessorDataSection
extends SmfData {
    public static final int R7025SA = 128;
    public static final int R7025FA = 64;
    public static final int R7025SP = 32;
    public static final int R7025SC = 16;
    public static final int R7025AG = 8;

    private CryptographicPkcs11CoprocessorDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r7025ax() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int r7025ct() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int r7025msk() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean r7025sa() {
        return Util.ConvertFlag(this.data, this.r7025msk(), 128);
    }

    public boolean r7025fa() {
        return Util.ConvertFlag(this.data, this.r7025msk(), 64);
    }

    public boolean r7025sp() {
        return Util.ConvertFlag(this.data, this.r7025msk(), 32);
    }

    public boolean r7025sc() {
        return Util.ConvertFlag(this.data, this.r7025msk(), 16);
    }

    public boolean r7025ag() {
        return Util.ConvertFlag(this.data, this.r7025msk(), 8);
    }

    public int r7025mt() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public double r7025sf() {
        return Util.ConvertLongFPHex(this.data, 8);
    }

    public Duration r7025sat() {
        return Util.LongFPHex_SecondsScaled(this.data, 16, this.r7025sf());
    }

    public double r7025satSeconds() {
        return this.r7025satRawValue() * this.r7025sf();
    }

    public double r7025satRawValue() {
        return Util.ConvertLongFPHex(this.data, 16);
    }

    public double r7025sac() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public Duration r7025fat() {
        return Util.LongFPHex_SecondsScaled(this.data, 32, this.r7025sf());
    }

    public double r7025fatSeconds() {
        return this.r7025fatRawValue() * this.r7025sf();
    }

    public double r7025fatRawValue() {
        return Util.ConvertLongFPHex(this.data, 32);
    }

    public double r7025fac() {
        return Util.ConvertLongFPHex(this.data, 40);
    }

    public Duration r7025spt() {
        return Util.LongFPHex_SecondsScaled(this.data, 48, this.r7025sf());
    }

    public double r7025sptSeconds() {
        return this.r7025sptRawValue() * this.r7025sf();
    }

    public double r7025sptRawValue() {
        return Util.ConvertLongFPHex(this.data, 48);
    }

    public double r7025spc() {
        return Util.ConvertLongFPHex(this.data, 56);
    }

    public Duration r7025sct() {
        return Util.LongFPHex_SecondsScaled(this.data, 64, this.r7025sf());
    }

    public double r7025sctSeconds() {
        return this.r7025sctRawValue() * this.r7025sf();
    }

    public double r7025sctRawValue() {
        return Util.ConvertLongFPHex(this.data, 64);
    }

    public double r7025scc() {
        return Util.ConvertLongFPHex(this.data, 72);
    }

    public Duration r7025agt() {
        return Util.LongFPHex_SecondsScaled(this.data, 80, this.r7025sf());
    }

    public double r7025agtSeconds() {
        return this.r7025agtRawValue() * this.r7025sf();
    }

    public double r7025agtRawValue() {
        return Util.ConvertLongFPHex(this.data, 80);
    }

    public double r7025agc() {
        return Util.ConvertLongFPHex(this.data, 88);
    }

    public int r7025scope() {
        return Util.ConvertUnsignedBinary1(this.data, 96);
    }

    public int r7025did() {
        return Util.ConvertUnsignedBinary1(this.data, 97);
    }

    public static CryptographicPkcs11CoprocessorDataSection create(byte[] Data2, int offset, int length) {
        return new CryptographicPkcs11CoprocessorDataSection(Data2, offset, length);
    }

    static enum Field {
        r7025ax(0, 1),
        r7025ct(1, 1),
        r7025msk(2, 1),
        r7025mt(3, 1),
        r7025sf(8, 8),
        r7025sat(16, 8),
        r7025sac(24, 8),
        r7025fat(32, 8),
        r7025fac(40, 8),
        r7025spt(48, 8),
        r7025spc(56, 8),
        r7025sct(64, 8),
        r7025scc(72, 8),
        r7025agt(80, 8),
        r7025agc(88, 8),
        r7025scope(96, 1),
        r7025did(97, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

