/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf71;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF71RRF = 128;
    public static final int SMF71SUT = 64;
    public static final int SMF71V4 = 16;
    public static final int SMF71ESA = 8;
    public static final int SMF71VXA = 4;
    public static final int SMF71OS = 2;
    public static final int SMF71BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf71len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf71seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf71flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf71rrf() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 128);
    }

    public boolean smf71sut() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 64);
    }

    public boolean smf71v4() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 16);
    }

    public boolean smf71esa() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 8);
    }

    public boolean smf71vxa() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 4);
    }

    public boolean smf71os() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 2);
    }

    public boolean smf71bfy() {
        return Util.ConvertFlag(this.data, this.smf71flg(), 1);
    }

    public int smf71rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf71tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf71tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf71dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf71dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf71sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf71ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf71sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf71trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf71prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf71prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf71prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf71pds() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf71pdl() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf71pdn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf71sws() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf71swl() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf71swn() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf71len(0, 2),
        smf71seg(2, 2),
        smf71flg(4, 1),
        smf71rty(5, 1),
        smf71tme(6, 4),
        smf71dte(10, 4),
        smf71sid(14, 4),
        smf71ssi(18, 4),
        smf71sty(22, 2),
        smf71trn(24, 2),
        smf71prs(28, 4),
        smf71prl(32, 2),
        smf71prn(34, 2),
        smf71pds(36, 4),
        smf71pdl(40, 2),
        smf71pdn(42, 2),
        smf71sws(44, 4),
        smf71swl(48, 2),
        smf71swn(50, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

