/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf71;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf71.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF71CNV = 128;
    public static final int SMF71ISS = 64;
    public static final int SMF71M3R = 32;
    public static final int SMF71ISM = 16;
    public static final int SMF71RCL = 8;
    public static final int SMF71RCH = 4;
    public static final int SMF71AltVM = 2;
    public static final int SMF71IIP = 64;
    public static final int SMF71EED = 32;
    public static final int SMF71BOO = 7;
    public static final int SMF71QES = 128;
    public static final int SMF71CNE = 64;
    public static final int SMF71DRC = 32;
    public static final int SMF71EME = 16;
    public static final int SMF71PRI = 8;
    public static final int SMF71PRP = 4;
    public static final int SMF71PED = 2;
    public static final int SMF71PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf71ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf71rao(), this.smf71ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf71mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf71prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf71ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf71istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf71dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf71datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf71int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf71intSeconds() {
        return Util.ToSeconds(this.smf71int());
    }

    public int smf71intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf71mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf71sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf71rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf71fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf71cnv() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 128, Field.smf71fla.length, 0);
    }

    public boolean smf71iss() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 64, Field.smf71fla.length, 0);
    }

    public boolean smf71m3r() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 32, Field.smf71fla.length, 0);
    }

    public boolean smf71ism() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 16, Field.smf71fla.length, 0);
    }

    public boolean smf71rcl() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 8, Field.smf71fla.length, 0);
    }

    public boolean smf71rch() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 4, Field.smf71fla.length, 0);
    }

    public boolean smf71altVm() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 2, Field.smf71fla.length, 0);
    }

    public boolean smf71iip() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 64, Field.smf71fla.length, 1);
    }

    public boolean smf71eed() {
        return Util.ConvertFlag(this.data, this.smf71fla(), 32, Field.smf71fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf71iip() || this.smf71eed()) {
            return BoostClass.from(this.smf71fla() & 7);
        }
        return null;
    }

    public String smf71rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf71cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf71cycSeconds() {
        return Util.ToSeconds(this.smf71cyc());
    }

    public int smf71cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf71mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf71iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf71prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf71qes() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 128);
    }

    public boolean smf71cne() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 64);
    }

    public boolean smf71drc() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 32);
    }

    public boolean smf71eme() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 16);
    }

    public boolean smf71pri() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 8);
    }

    public boolean smf71prp() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 4);
    }

    public boolean smf71ped() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 2);
    }

    public boolean smf71pe2() {
        return Util.ConvertFlag(this.data, this.smf71prf(), 1);
    }

    public int smf71ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf71srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf71iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf71ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf71lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf71lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf71rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf71ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf71ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf71oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf71oilSeconds() {
        return Util.ToSeconds(this.smf71oil());
    }

    public int smf71oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf71syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf71synSeconds() {
        return Util.ToSeconds(this.smf71syn());
    }

    public int smf71synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf71gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf71gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf71xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf71snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf71mfv(0, 2),
        smf71prd(2, 8),
        smf71ist(10, 4),
        smf71dat(14, 4),
        smf71int(18, 4),
        smf71mfl(22, 2),
        smf71sam(24, 4),
        smf71rv2(28, 2),
        smf71fla(30, 2),
        smf71rls(32, 4),
        smf71cyc(36, 4),
        smf71mvs(40, 8),
        smf71iml(48, 1),
        smf71prf(49, 1),
        smf71ptn(50, 1),
        smf71srl(51, 1),
        smf71iet(52, 8),
        smf71lgo(60, 8),
        smf71rao(68, 4),
        smf71ral(72, 2),
        smf71ran(74, 2),
        smf71oil(76, 2),
        smf71syn(78, 2),
        smf71gie(80, 8),
        smf71xnm(88, 8),
        smf71snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

