/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf72;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF72RRF = 128;
    public static final int SMF72SUT = 64;
    public static final int SMF72V4 = 16;
    public static final int SMF72ESA = 8;
    public static final int SMF72VXA = 4;
    public static final int SMF72OS = 2;
    public static final int SMF72BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf72len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf72seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf72flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf72rrf() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 128);
    }

    public boolean smf72sut() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 64);
    }

    public boolean smf72v4() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 16);
    }

    public boolean smf72esa() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 8);
    }

    public boolean smf72vxa() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 4);
    }

    public boolean smf72os() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 2);
    }

    public boolean smf72bfy() {
        return Util.ConvertFlag(this.data, this.smf72flg(), 1);
    }

    public int smf72rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf72tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf72tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf72dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf72dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf72sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf72ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf72sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf72trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf72prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf72prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf72prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf72wls() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf72wll() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf72wln() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf72pgs() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf72pgl() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf72pgn() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf72sws() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf72swl() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf72swn() {
        if (this.smf72sty() != 1 && this.smf72sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 1 || smf72sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf72wms() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf72wml() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf72wmn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf72sss() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf72ssl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf72ssn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf72rgs() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf72rgl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf72rgn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf72scs() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf72scl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf72scn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf72rts() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf72rtl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf72rtn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf72wrs() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf72wrl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf72wrn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf72dns() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 84);
    }

    public int smf72dnl() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int smf72dnn() {
        if (this.smf72sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public int smf72cps() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf72cpl() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf72cpn() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf72sps() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf72spl() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf72spn() {
        if (this.smf72sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf72ses() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf72sel() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf72sen() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf72cms() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf72cml() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf72cmn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf72eds() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf72edl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf72edn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf72las() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf72lal() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf72lan() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf72sms() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf72sml() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf72smn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf72los() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf72lol() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf72lon() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf72cos() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 84);
    }

    public int smf72col() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int smf72con() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public int smf72crs() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 92);
    }

    public int smf72crl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int smf72crn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public int smf72lcs() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 100);
    }

    public int smf72lcl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public int smf72lcn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public int smf72lrs() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 108);
    }

    public int smf72lrl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public int smf72lrn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public int smf72tds() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 116);
    }

    public int smf72tdl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 120);
    }

    public int smf72tdn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public int smf72yds() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 124);
    }

    public int smf72ydl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 128);
    }

    public int smf72ydn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 130);
    }

    public int smf72sds() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 132);
    }

    public int smf72sdl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 136);
    }

    public int smf72sdn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public int smf72qss() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 140);
    }

    public int smf72qsl() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public int smf72qsn() {
        if (this.smf72sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf72sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 146);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf72len(0, 2),
        smf72seg(2, 2),
        smf72flg(4, 1),
        smf72rty(5, 1),
        smf72tme(6, 4),
        smf72dte(10, 4),
        smf72sid(14, 4),
        smf72ssi(18, 4),
        smf72sty(22, 2),
        smf72trn(24, 2),
        smf72prs(28, 4),
        smf72prl(32, 2),
        smf72prn(34, 2),
        smf72wls(36, 4),
        smf72wll(40, 2),
        smf72wln(42, 2),
        smf72pgs(44, 4),
        smf72pgl(48, 2),
        smf72pgn(50, 2),
        smf72sws(52, 4),
        smf72swl(56, 2),
        smf72swn(58, 2),
        smf72wms(36, 4),
        smf72wml(40, 2),
        smf72wmn(42, 2),
        smf72sss(44, 4),
        smf72ssl(48, 2),
        smf72ssn(50, 2),
        smf72rgs(52, 4),
        smf72rgl(56, 2),
        smf72rgn(58, 2),
        smf72scs(60, 4),
        smf72scl(64, 2),
        smf72scn(66, 2),
        smf72rts(68, 4),
        smf72rtl(72, 2),
        smf72rtn(74, 2),
        smf72wrs(76, 4),
        smf72wrl(80, 2),
        smf72wrn(82, 2),
        smf72dns(84, 4),
        smf72dnl(88, 2),
        smf72dnn(90, 2),
        smf72cps(36, 4),
        smf72cpl(40, 2),
        smf72cpn(42, 2),
        smf72sps(44, 4),
        smf72spl(48, 2),
        smf72spn(50, 2),
        smf72ses(36, 4),
        smf72sel(40, 2),
        smf72sen(42, 2),
        smf72cms(44, 4),
        smf72cml(48, 2),
        smf72cmn(50, 2),
        smf72eds(52, 4),
        smf72edl(56, 2),
        smf72edn(58, 2),
        smf72las(60, 4),
        smf72lal(64, 2),
        smf72lan(66, 2),
        smf72sms(68, 4),
        smf72sml(72, 2),
        smf72smn(74, 2),
        smf72los(76, 4),
        smf72lol(80, 2),
        smf72lon(82, 2),
        smf72cos(84, 4),
        smf72col(88, 2),
        smf72con(90, 2),
        smf72crs(92, 4),
        smf72crl(96, 2),
        smf72crn(98, 2),
        smf72lcs(100, 4),
        smf72lcl(104, 2),
        smf72lcn(106, 2),
        smf72lrs(108, 4),
        smf72lrl(112, 2),
        smf72lrn(114, 2),
        smf72tds(116, 4),
        smf72tdl(120, 2),
        smf72tdn(122, 2),
        smf72yds(124, 4),
        smf72ydl(128, 2),
        smf72ydn(130, 2),
        smf72sds(132, 4),
        smf72sdl(136, 2),
        smf72sdn(138, 2),
        smf72qss(140, 4),
        smf72qsl(144, 2),
        smf72qsn(146, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

