/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf72;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf72.ReassemblyArea;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ProductSection
extends SmfData {
    private ReassemblyArea m_reassemblyArea = null;
    public static final int SMF72CNV = 128;
    public static final int SMF72ISS = 64;
    public static final int SMF72M3R = 32;
    public static final int SMF72ISM = 16;
    public static final int SMF72RCL = 8;
    public static final int SMF72RCH = 4;
    public static final int SMF72AltVM = 2;
    public static final int SMF72IIP = 64;
    public static final int SMF72EED = 32;
    public static final int SMF72BOO = 7;
    public static final int SMF72QES = 128;
    public static final int SMF72CNE = 64;
    public static final int SMF72DRC = 32;
    public static final int SMF72EME = 16;
    public static final int SMF72PRI = 8;
    public static final int SMF72PRP = 4;
    public static final int SMF72PED = 2;
    public static final int SMF72PE2 = 1;

    private ProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ReassemblyArea reassemblyArea() {
        if (this.m_reassemblyArea == null && this.smf72ran() == 1) {
            this.m_reassemblyArea = ReassemblyArea.create(this.data, this.smf72rao(), this.smf72ral());
        }
        return this.m_reassemblyArea;
    }

    public int smf72mfv() {
        return Util.ConvertPacked2(this.data, 0);
    }

    public String smf72prd() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public LocalTime smf72ist() {
        return Util.Packed_HHMMSS(this.data, 10);
    }

    public int smf72istRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public LocalDate smf72dat() {
        return Util.SMFDate(this.data, 14);
    }

    public int smf72datRawValue() {
        return Util.ConvertPacked4(this.data, 14);
    }

    public Duration smf72int() {
        return Util.Packed_MMSSTTT(this.data, 18);
    }

    public double smf72intSeconds() {
        return Util.ToSeconds(this.smf72int());
    }

    public int smf72intRawValue() {
        return Util.ConvertPacked4(this.data, 18);
    }

    public int smf72mfl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smf72sam() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int smf72rv2() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf72fla() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public boolean smf72cnv() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 128, Field.smf72fla.length, 0);
    }

    public boolean smf72iss() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 64, Field.smf72fla.length, 0);
    }

    public boolean smf72m3r() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 32, Field.smf72fla.length, 0);
    }

    public boolean smf72ism() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 16, Field.smf72fla.length, 0);
    }

    public boolean smf72rcl() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 8, Field.smf72fla.length, 0);
    }

    public boolean smf72rch() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 4, Field.smf72fla.length, 0);
    }

    public boolean smf72altVm() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 2, Field.smf72fla.length, 0);
    }

    public boolean smf72iip() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 64, Field.smf72fla.length, 1);
    }

    public boolean smf72eed() {
        return Util.ConvertFlag(this.data, this.smf72fla(), 32, Field.smf72fla.length, 1);
    }

    public BoostClass boostClass() {
        if (this.smf72iip() || this.smf72eed()) {
            return BoostClass.from(this.smf72fla() & 7);
        }
        return null;
    }

    public String smf72rls() {
        return Util.ConvertEbcdic(this.data, 32, 4);
    }

    public Duration smf72cyc() {
        return Util.Packed_MMSSTTT(this.data, 36);
    }

    public double smf72cycSeconds() {
        return Util.ToSeconds(this.smf72cyc());
    }

    public int smf72cycRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public String smf72mvs() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public int smf72iml() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public int smf72prf() {
        return Util.ConvertUnsignedBinary1(this.data, 49);
    }

    public boolean smf72qes() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 128);
    }

    public boolean smf72cne() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 64);
    }

    public boolean smf72drc() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 32);
    }

    public boolean smf72eme() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 16);
    }

    public boolean smf72pri() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 8);
    }

    public boolean smf72prp() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 4);
    }

    public boolean smf72ped() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 2);
    }

    public boolean smf72pe2() {
        return Util.ConvertFlag(this.data, this.smf72prf(), 1);
    }

    public int smf72ptn() {
        return Util.ConvertUnsignedBinary1(this.data, 50);
    }

    public int smf72srl() {
        return Util.ConvertUnsignedBinary1(this.data, 51);
    }

    public ZonedDateTime smf72iet() {
        return Util.Binary8xStckTime(this.data, 52);
    }

    public BigInteger smf72ietRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public ZoneOffset smf72lgo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 60);
    }

    public long smf72lgoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public int smf72rao() {
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf72ral() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf72ran() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public Duration smf72oil() {
        return Util.Binary2Seconds(this.data, 76);
    }

    public double smf72oilSeconds() {
        return Util.ToSeconds(this.smf72oil());
    }

    public int smf72oilRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public Duration smf72syn() {
        return Util.Binary2Seconds(this.data, 78);
    }

    public double smf72synSeconds() {
        return Util.ToSeconds(this.smf72syn());
    }

    public int smf72synRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public ZonedDateTime smf72gie() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger smf72gieRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String smf72xnm() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String smf72snm() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public static ProductSection create(byte[] Data2, int offset, int length) {
        return new ProductSection(Data2, offset, length);
    }

    static enum Field {
        smf72mfv(0, 2),
        smf72prd(2, 8),
        smf72ist(10, 4),
        smf72dat(14, 4),
        smf72int(18, 4),
        smf72mfl(22, 2),
        smf72sam(24, 4),
        smf72rv2(28, 2),
        smf72fla(30, 2),
        smf72rls(32, 4),
        smf72cyc(36, 4),
        smf72mvs(40, 8),
        smf72iml(48, 1),
        smf72prf(49, 1),
        smf72ptn(50, 1),
        smf72srl(51, 1),
        smf72iet(52, 8),
        smf72lgo(60, 8),
        smf72rao(68, 4),
        smf72ral(72, 2),
        smf72ran(74, 2),
        smf72oil(76, 2),
        smf72syn(78, 2),
        smf72gie(80, 8),
        smf72xnm(88, 8),
        smf72snm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

