/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf72.subtype3;

import com.blackhillsoftware.smf.Importance;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Utils;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf72.subtype3.ResponseTimeDistributionDataSection;
import com.blackhillsoftware.smf.smf72.subtype3.WorkloadManagerControlSection;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;

public final class ServiceReportClassPeriodDataSection
extends SmfData {
    private WorkloadManagerControlSection m_controlsection;
    private List<ResponseTimeDistributionDataSection> m_responseTimeMap;
    private String goalDescription = null;
    private double m_performanceIndex = -1.0;
    public static final int R723CRPH = 128;
    public static final int R723CCIMP = 64;
    public static final int R723CRCA = 128;
    public static final int R723CRTA = 64;
    public static final int R723CEDA = 32;
    public static final int R723CMIL = 128;
    public static final int R723CSEC = 64;
    public static final int R723CMIN = 32;
    public static final int R723CHOU = 16;
    public static final int R723CPRC = 128;
    public static final int R723CAVG = 64;
    public static final int R723CVEL = 32;
    public static final int R723CDSC = 16;
    public static final int R723CSTM = 8;

    private ServiceReportClassPeriodDataSection(byte[] Data2, int offset, int length, WorkloadManagerControlSection controlsection, List<ResponseTimeDistributionDataSection> responseTimeDistributionDataSections) {
        super(Data2, offset, length);
        this.m_controlsection = controlsection;
        this.m_responseTimeMap = responseTimeDistributionDataSections;
    }

    public WorkloadManagerControlSection controlSection() {
        return this.m_controlsection;
    }

    ResponseTimeDistributionDataSection responseTimeMap() {
        return this.m_responseTimeMap.get(0);
    }

    ResponseTimeDistributionDataSection responseTimeDistributionDataSection() {
        return this.m_responseTimeMap.get(this.r723crtx());
    }

    public Importance importance() {
        if (this.r723cdsc()) {
            return Importance.DISCRETIONARY;
        }
        if (this.r723cstm()) {
            return Importance.SYSTEM;
        }
        switch (this.r723cimp()) {
            case 1: {
                return Importance.I1;
            }
            case 2: {
                return Importance.I2;
            }
            case 3: {
                return Importance.I3;
            }
            case 4: {
                return Importance.I4;
            }
            case 5: {
                return Importance.I5;
            }
        }
        throw new IllegalArgumentException("Unknown importance");
    }

    public double velocity() {
        return ServiceReportClassPeriodDataSection.velocity(Collections.singleton(this));
    }

    public static double velocity(Iterable<ServiceReportClassPeriodDataSection> sections) {
        double result = 0.0;
        double using = 0.0;
        double total = 0.0;
        for (ServiceReportClassPeriodDataSection s : sections) {
            using += (double)s.r723ctou();
            total += (double)s.r723ctot();
        }
        if (using + total > 0.0) {
            result = using / (using + total) * 100.0;
        }
        return result;
    }

    public Duration goalResponseTime() {
        if (this.r723cavg() || this.r723cprc()) {
            long value = this.r723cval();
            if (this.r723cmil()) {
                return Duration.ofMillis(value);
            }
            if (this.r723csec()) {
                return Duration.ofSeconds(value);
            }
            if (this.r723cmin()) {
                return Duration.ofMinutes(value);
            }
            if (this.r723chou()) {
                return Duration.ofHours(value);
            }
            throw new NotAvailableException("Response time type not recognized");
        }
        return Duration.ZERO;
    }

    public String goalDescription() {
        if (this.goalDescription != null) {
            return this.goalDescription;
        }
        if (this.r723cstm()) {
            this.goalDescription = "System Goal";
        } else if (this.r723cdsc()) {
            this.goalDescription = "Discretionary";
        } else if (this.r723cprc()) {
            this.goalDescription = this.goalResponseTime().getSeconds() < 60L ? Integer.toString(this.r723cpct()) + "% complete in " + Double.toString(Util.ToSeconds(this.goalResponseTime())) + " s" : Integer.toString(this.r723cpct()) + "% complete in " + this.goalResponseTime();
        } else if (this.r723cavg()) {
            this.goalDescription = this.goalResponseTime().getSeconds() < 60L ? "Average Response Time " + Double.toString(Util.ToSeconds(this.goalResponseTime())) + " s" : "Average Response Time " + this.goalResponseTime();
        } else if (this.r723cvel()) {
            this.goalDescription = "Velocity " + Long.toString(this.r723cval());
        }
        return this.goalDescription;
    }

    boolean sameGoal(ServiceReportClassPeriodDataSection s) {
        if (this == s) {
            return true;
        }
        return !(this.r723crtf() != s.r723crtf() || this.r723crgf() != s.r723crgf() || this.r723cval() != s.r723cval() || this.r723cpct() != s.r723cpct() || this.controlSection().r723mrcl() != s.controlSection().r723mrcl() || this.controlSection().r723mrcl() && this.r723crph() || s.controlSection().r723mrcl() && s.r723crph());
    }

    public double performanceIndex() {
        if (this.m_performanceIndex == -1.0) {
            this.m_performanceIndex = ServiceReportClassPeriodDataSection.performanceIndex(Collections.singleton(this));
        }
        return this.m_performanceIndex;
    }

    public static double performanceIndex(Iterable<ServiceReportClassPeriodDataSection> sections) {
        ServiceReportClassPeriodDataSection firstsection = null;
        long using = 0L;
        long total = 0L;
        Duration elapsed = Duration.ZERO;
        long completed = 0L;
        long[] buckets = new long[14];
        for (ServiceReportClassPeriodDataSection section : sections) {
            if (firstsection == null) {
                firstsection = section;
            }
            if (!firstsection.sameGoal(section)) {
                throw new IllegalArgumentException(String.format("Classes do not have the same goal, or report class is heterogeneous: %n %s Period %s Activation time: %s %n %s Period %s Activation time: %s", firstsection.controlSection().r723mcnm(), firstsection.r723cper(), firstsection.controlSection().r723mtpa(), section.controlSection().r723mcnm(), section.r723cper(), section.controlSection().r723mtpa()));
            }
            if (firstsection.r723cvel()) {
                using += section.r723ctou();
                total += section.r723ctot();
                continue;
            }
            if (firstsection.r723cavg()) {
                completed += section.r723crcp();
                elapsed = elapsed.plus(section.r723ctet());
                continue;
            }
            if (!firstsection.r723cprc()) continue;
            completed += section.r723crcp();
            ResponseTimeDistributionDataSection rtds = section.responseTimeDistributionDataSection();
            for (int i = 0; i < buckets.length; ++i) {
                int n = i;
                buckets[n] = buckets[n] + rtds.get(i);
            }
        }
        if (firstsection == null) {
            return 0.0;
        }
        if (firstsection.r723cvel()) {
            if (using > 0L) {
                return (double)firstsection.r723cval() / ((double)using / (double)(using + total) * 100.0);
            }
        } else if (firstsection.r723cavg()) {
            if (completed > 0L) {
                Duration average = elapsed.dividedBy(completed);
                return Utils.divideDurations(average, firstsection.goalResponseTime());
            }
        } else if (firstsection.r723cprc() && completed > 0L) {
            long goaltransactions = (long)Math.ceil((float)completed * (float)firstsection.r723cpct() / 100.0f);
            ResponseTimeDistributionDataSection map = firstsection.responseTimeMap();
            long cumulativetransactions = 0L;
            for (int i = 0; i < 13; ++i) {
                if ((cumulativetransactions += buckets[i]) < goaltransactions) continue;
                return (double)map.get(i) / 100.0;
            }
            return (double)map.get(12) / 100.0;
        }
        return 0.0;
    }

    public int r723crtx() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int r723cwmx() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int r723cwmn() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int r723crs1() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public boolean r723crph() {
        return Util.ConvertFlag(this.data, this.r723crs1(), 128);
    }

    public boolean r723ccimp() {
        return Util.ConvertFlag(this.data, this.r723crs1(), 64);
    }

    public int r723cadf() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public boolean r723crca() {
        return Util.ConvertFlag(this.data, this.r723cadf(), 128);
    }

    public boolean r723crta() {
        return Util.ConvertFlag(this.data, this.r723cadf(), 64);
    }

    public boolean r723ceda() {
        return Util.ConvertFlag(this.data, this.r723cadf(), 32);
    }

    public String r723coal() {
        return Util.ConvertEbcdic(this.data, 8, 1);
    }

    public int r723cper() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int r723crtf() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean r723cmil() {
        return Util.ConvertFlag(this.data, this.r723crtf(), 128);
    }

    public boolean r723csec() {
        return Util.ConvertFlag(this.data, this.r723crtf(), 64);
    }

    public boolean r723cmin() {
        return Util.ConvertFlag(this.data, this.r723crtf(), 32);
    }

    public boolean r723chou() {
        return Util.ConvertFlag(this.data, this.r723crtf(), 16);
    }

    public int r723crgf() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public boolean r723cprc() {
        return Util.ConvertFlag(this.data, this.r723crgf(), 128);
    }

    public boolean r723cavg() {
        return Util.ConvertFlag(this.data, this.r723crgf(), 64);
    }

    public boolean r723cvel() {
        return Util.ConvertFlag(this.data, this.r723crgf(), 32);
    }

    public boolean r723cdsc() {
        return Util.ConvertFlag(this.data, this.r723crgf(), 16);
    }

    public boolean r723cstm() {
        return Util.ConvertFlag(this.data, this.r723crgf(), 8);
    }

    public int r723crs4() {
        return Util.ConvertUnsignedBinary1(this.data, 11);
    }

    public long r723cval() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int r723cpct() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int r723cimp() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public long r723cdur() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public double r723csrv() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public double r723ccpu() {
        return Util.ConvertLongFPHex(this.data, 32);
    }

    public double r723cioc() {
        return Util.ConvertLongFPHex(this.data, 40);
    }

    public double r723cmso() {
        return Util.ConvertLongFPHex(this.data, 48);
    }

    public double r723csrb() {
        return Util.ConvertLongFPHex(this.data, 56);
    }

    public double r723cpir() {
        return Util.ConvertLongFPHex(this.data, 64);
    }

    public double r723chpi() {
        return Util.ConvertLongFPHex(this.data, 72);
    }

    public double r723cbpi() {
        return Util.ConvertLongFPHex(this.data, 80);
    }

    public double r723cpie() {
        return Util.ConvertLongFPHex(this.data, 88);
    }

    public double r723cbpe() {
        return Util.ConvertLongFPHex(this.data, 96);
    }

    public double r723cbka() {
        return Util.ConvertLongFPHex(this.data, 104);
    }

    public double r723cbke() {
        return Util.ConvertLongFPHex(this.data, 112);
    }

    public Duration r723cprs() {
        return Util.LongFpHex_1024_US(this.data, 120);
    }

    public double r723cprsSeconds() {
        return Util.ToSeconds(this.r723cprs());
    }

    public double r723cprsRawValue() {
        return Util.ConvertLongFPHex(this.data, 120);
    }

    public Duration r723cers() {
        return Util.LongFpHex_1024_US(this.data, 128);
    }

    public double r723cersSeconds() {
        return Util.ToSeconds(this.r723cers());
    }

    public double r723cersRawValue() {
        return Util.ConvertLongFPHex(this.data, 128);
    }

    public Duration r723ctrr() {
        return Util.LongFpHex_1024_US(this.data, 136);
    }

    public double r723ctrrSeconds() {
        return Util.ToSeconds(this.r723ctrr());
    }

    public double r723ctrrRawValue() {
        return Util.ConvertLongFPHex(this.data, 136);
    }

    public Duration r723ctat() {
        return Util.LongFpHex_1024_US(this.data, 144);
    }

    public double r723ctatSeconds() {
        return Util.ToSeconds(this.r723ctat());
    }

    public double r723ctatRawValue() {
        return Util.ConvertLongFPHex(this.data, 144);
    }

    public Duration r723crct() {
        return Util.LongFpHex_US(this.data, 152);
    }

    public double r723crctSeconds() {
        return Util.ToSeconds(this.r723crct());
    }

    public double r723crctRawValue() {
        return Util.ConvertLongFPHex(this.data, 152);
    }

    public Duration r723ciit() {
        return Util.LongFpHex_US(this.data, 160);
    }

    public double r723ciitSeconds() {
        return Util.ToSeconds(this.r723ciit());
    }

    public double r723ciitRawValue() {
        return Util.ConvertLongFPHex(this.data, 160);
    }

    public Duration r723chst() {
        return Util.LongFpHex_US(this.data, 168);
    }

    public double r723chstSeconds() {
        return Util.ToSeconds(this.r723chst());
    }

    public double r723chstRawValue() {
        return Util.ConvertLongFPHex(this.data, 168);
    }

    public long r723cswc() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long r723ccrm() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long r723crcp() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long r723carc() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long r723cncp() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long r723canc() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public Duration r723ctet() {
        return Util.LongFpHex_1024_US(this.data, 200);
    }

    public double r723ctetSeconds() {
        return Util.ToSeconds(this.r723ctet());
    }

    public double r723ctetRawValue() {
        return Util.ConvertLongFPHex(this.data, 200);
    }

    public Duration r723cxet() {
        return Util.LongFpHex_1024_US(this.data, 208);
    }

    public double r723cxetSeconds() {
        return Util.ToSeconds(this.r723cxet());
    }

    public double r723cxetRawValue() {
        return Util.ConvertLongFPHex(this.data, 208);
    }

    public double r723cetsSecondsSq() {
        return Util.LongFpHex_1024_US_Squared(this.data, 216);
    }

    public double r723cetsRawValue() {
        return Util.ConvertLongFPHex(this.data, 216);
    }

    public long r723ccus() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public long r723ctot() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long r723ccde() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long r723ccca() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long r723cswi() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long r723cmpl() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long r723capr() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public long r723caco() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long r723caxm() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long r723cvio() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long r723chsp() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long r723cchs() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public long r723cunk() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long r723cidl() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long r723cpde() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public long r723cpqu() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public long r723csac() {
        return Util.ConvertUnsignedBinary4(this.data, 288);
    }

    public Duration r723csrs() {
        return Util.LongFpHex_1024_US(this.data, 292);
    }

    public double r723csrsSeconds() {
        return Util.ToSeconds(this.r723csrs());
    }

    public double r723csrsRawValue() {
        return Util.ConvertLongFPHex(this.data, 292);
    }

    public double r723cspa() {
        return Util.ConvertLongFPHex(this.data, 300);
    }

    public double r723cspe() {
        return Util.ConvertLongFPHex(this.data, 308);
    }

    public Duration r723cict() {
        return Util.LongFpHex_128_US(this.data, 316);
    }

    public double r723cictSeconds() {
        return Util.ToSeconds(this.r723cict());
    }

    public double r723cictRawValue() {
        return Util.ConvertLongFPHex(this.data, 316);
    }

    public Duration r723ciwt() {
        return Util.LongFpHex_128_US(this.data, 324);
    }

    public double r723ciwtSeconds() {
        return Util.ToSeconds(this.r723ciwt());
    }

    public double r723ciwtRawValue() {
        return Util.ConvertLongFPHex(this.data, 324);
    }

    public Duration r723cidt() {
        return Util.LongFpHex_128_US(this.data, 332);
    }

    public double r723cidtSeconds() {
        return Util.ToSeconds(this.r723cidt());
    }

    public double r723cidtRawValue() {
        return Util.ConvertLongFPHex(this.data, 332);
    }

    public long r723circ() {
        return Util.ConvertUnsignedBinary4(this.data, 340);
    }

    public long r723ctou() {
        return Util.ConvertUnsignedBinary4(this.data, 344);
    }

    public long r723ciou() {
        return Util.ConvertUnsignedBinary4(this.data, 348);
    }

    public long r723ciod() {
        return Util.ConvertUnsignedBinary4(this.data, 352);
    }

    public long r723cq() {
        return Util.ConvertUnsignedBinary4(this.data, 356);
    }

    public long r723cspv() {
        return Util.ConvertUnsignedBinary4(this.data, 360);
    }

    public long r723csvi() {
        return Util.ConvertUnsignedBinary4(this.data, 364);
    }

    public long r723cshs() {
        return Util.ConvertUnsignedBinary4(this.data, 368);
    }

    public long r723csmp() {
        return Util.ConvertUnsignedBinary4(this.data, 372);
    }

    public long r723cssw() {
        return Util.ConvertUnsignedBinary4(this.data, 376);
    }

    public long r723cndi() {
        return Util.ConvertUnsignedBinary4(this.data, 380);
    }

    public long r723ctdq() {
        return Util.ConvertUnsignedBinary4(this.data, 384);
    }

    public double r723ctsa() {
        return Util.ConvertLongFPHex(this.data, 388);
    }

    public Duration r723ciot() {
        return Util.LongFpHex_128_US(this.data, 396);
    }

    public double r723ciotSeconds() {
        return Util.ToSeconds(this.r723ciot());
    }

    public double r723ciotRawValue() {
        return Util.ConvertLongFPHex(this.data, 396);
    }

    public Duration r723cqdt() {
        return Util.LongFpHex_1024_US(this.data, 404);
    }

    public double r723cqdtSeconds() {
        return Util.ToSeconds(this.r723cqdt());
    }

    public double r723cqdtRawValue() {
        return Util.ConvertLongFPHex(this.data, 404);
    }

    public Duration r723cadt() {
        return Util.LongFpHex_1024_US(this.data, 412);
    }

    public double r723cadtSeconds() {
        return Util.ToSeconds(this.r723cadt());
    }

    public double r723cadtRawValue() {
        return Util.ConvertLongFPHex(this.data, 412);
    }

    public Duration r723ccvt() {
        return Util.LongFpHex_1024_US(this.data, 420);
    }

    public double r723ccvtSeconds() {
        return Util.ToSeconds(this.r723ccvt());
    }

    public double r723ccvtRawValue() {
        return Util.ConvertLongFPHex(this.data, 420);
    }

    public Duration r723ciqt() {
        return Util.LongFpHex_1024_US(this.data, 428);
    }

    public double r723ciqtSeconds() {
        return Util.ToSeconds(this.r723ciqt());
    }

    public double r723ciqtRawValue() {
        return Util.ConvertLongFPHex(this.data, 428);
    }

    public Duration r723ciea() {
        return Util.LongFpHex_1024_US(this.data, 436);
    }

    public double r723cieaSeconds() {
        return Util.ToSeconds(this.r723ciea());
    }

    public double r723cieaRawValue() {
        return Util.ConvertLongFPHex(this.data, 436);
    }

    public Duration r723cxea() {
        return Util.LongFpHex_1024_US(this.data, 444);
    }

    public double r723cxeaSeconds() {
        return Util.ToSeconds(this.r723cxea());
    }

    public double r723cxeaRawValue() {
        return Util.ConvertLongFPHex(this.data, 444);
    }

    public Duration r723cfea() {
        return Util.LongFpHex_1024_US(this.data, 452);
    }

    public double r723cfeaSeconds() {
        return Util.ToSeconds(this.r723cfea());
    }

    public double r723cfeaRawValue() {
        return Util.ConvertLongFPHex(this.data, 452);
    }

    public long r723camu() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public long r723camd() {
        return Util.ConvertUnsignedBinary4(this.data, 464);
    }

    public long r723apu() {
        return Util.ConvertUnsignedBinary4(this.data, 468);
    }

    public long r723apd() {
        return Util.ConvertUnsignedBinary4(this.data, 472);
    }

    public long r723fqd() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public String r723plsc() {
        return Util.ConvertEbcdic(this.data, 480, 8);
    }

    public long r723rcod() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public long r723rcou() {
        return Util.ConvertUnsignedBinary4(this.data, 492);
    }

    public Duration r723ectc() {
        return Util.LongFpHex_1024_US(this.data, 496);
    }

    public double r723ectcSeconds() {
        return Util.ToSeconds(this.r723ectc());
    }

    public double r723ectcRawValue() {
        return Util.ConvertLongFPHex(this.data, 496);
    }

    public long r723ifau() {
        return Util.ConvertUnsignedBinary4(this.data, 504);
    }

    public long r723ifcu() {
        return Util.ConvertUnsignedBinary4(this.data, 508);
    }

    public long r723ifad() {
        return Util.ConvertUnsignedBinary4(this.data, 512);
    }

    public Duration r723ifat() {
        return Util.LongFpHex_US(this.data, 516);
    }

    public double r723ifatSeconds() {
        return Util.ToSeconds(this.r723ifat());
    }

    public double r723ifatRawValue() {
        return Util.ConvertLongFPHex(this.data, 516);
    }

    public Duration r723ifct() {
        return Util.LongFpHex_US(this.data, 524);
    }

    public double r723ifctSeconds() {
        return Util.ToSeconds(this.r723ifct());
    }

    public double r723ifctRawValue() {
        return Util.ConvertLongFPHex(this.data, 524);
    }

    public long r723supu() {
        return Util.ConvertUnsignedBinary4(this.data, 532);
    }

    public long r723sucu() {
        return Util.ConvertUnsignedBinary4(this.data, 536);
    }

    public long r723supd() {
        return Util.ConvertUnsignedBinary4(this.data, 540);
    }

    public double r723csup() {
        return Util.ConvertLongFPHex(this.data, 544);
    }

    public double r723csuc() {
        return Util.ConvertLongFPHex(this.data, 552);
    }

    public double r723cifa() {
        return Util.ConvertLongFPHex(this.data, 560);
    }

    public double r723cifc() {
        return Util.ConvertLongFPHex(this.data, 568);
    }

    public Duration r723tpdp() {
        return Util.LongFpHex_1024_US(this.data, 576);
    }

    public double r723tpdpSeconds() {
        return Util.ToSeconds(this.r723tpdp());
    }

    public double r723tpdpRawValue() {
        return Util.ConvertLongFPHex(this.data, 576);
    }

    public Duration r723cpdp() {
        return Util.LongFpHex_1024_US(this.data, 584);
    }

    public double r723cpdpSeconds() {
        return Util.ToSeconds(this.r723cpdp());
    }

    public double r723cpdpRawValue() {
        return Util.ConvertLongFPHex(this.data, 584);
    }

    public Duration r723lpdp() {
        return Util.LongFpHex_1024_US(this.data, 592);
    }

    public double r723lpdpSeconds() {
        return Util.ToSeconds(this.r723lpdp());
    }

    public double r723lpdpRawValue() {
        return Util.ConvertLongFPHex(this.data, 592);
    }

    public Duration r723spdp() {
        return Util.LongFpHex_1024_US(this.data, 600);
    }

    public double r723spdpSeconds() {
        return Util.ToSeconds(this.r723spdp());
    }

    public double r723spdpRawValue() {
        return Util.ConvertLongFPHex(this.data, 600);
    }

    public Duration r723rtdm() {
        return Util.Binary4MS(this.data, 608);
    }

    public double r723rtdmSeconds() {
        return Util.ToSeconds(this.r723rtdm());
    }

    public long r723rtdmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 608);
    }

    public long r723rtdc() {
        return Util.ConvertUnsignedBinary4(this.data, 612);
    }

    public ZonedDateTime r723rtdt() {
        return Util.Binary8xStckTime(this.data, 616);
    }

    public BigInteger r723rtdtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 616);
    }

    public double r723tsucp() {
        return Util.ConvertLongFPHex(this.data, 624);
    }

    public double r723tsusp() {
        return Util.ConvertLongFPHex(this.data, 632);
    }

    public double r723tsuocp() {
        return Util.ConvertLongFPHex(this.data, 640);
    }

    public double r723msucp() {
        return Util.ConvertLongFPHex(this.data, 648);
    }

    public double r723msusp() {
        return Util.ConvertLongFPHex(this.data, 656);
    }

    public double r723msuocp() {
        return Util.ConvertLongFPHex(this.data, 664);
    }

    public double r723asucp() {
        return Util.ConvertLongFPHex(this.data, 672);
    }

    public double r723asusp() {
        return Util.ConvertLongFPHex(this.data, 680);
    }

    public double r723asuocp() {
        return Util.ConvertLongFPHex(this.data, 688);
    }

    public double r723bsucp() {
        return Util.ConvertLongFPHex(this.data, 696);
    }

    public double r723bsusp() {
        return Util.ConvertLongFPHex(this.data, 704);
    }

    public double r723bsuocp() {
        return Util.ConvertLongFPHex(this.data, 712);
    }

    public Duration r723ctetx() {
        return Util.LongFpHex_US(this.data, 720);
    }

    public double r723ctetxSeconds() {
        return Util.ToSeconds(this.r723ctetx());
    }

    public double r723ctetxRawValue() {
        return Util.ConvertLongFPHex(this.data, 720);
    }

    public Duration r723cxetx() {
        return Util.LongFpHex_US(this.data, 728);
    }

    public double r723cxetxSeconds() {
        return Util.ToSeconds(this.r723cxetx());
    }

    public double r723cxetxRawValue() {
        return Util.ConvertLongFPHex(this.data, 728);
    }

    public double r723cetsxSecondsSq() {
        return Util.LongFpHex_US_Squared(this.data, 736);
    }

    public double r723cetsxRawValue() {
        return Util.ConvertLongFPHex(this.data, 736);
    }

    public Duration r723cqdtx() {
        return Util.LongFpHex_US(this.data, 744);
    }

    public double r723cqdtxSeconds() {
        return Util.ToSeconds(this.r723cqdtx());
    }

    public double r723cqdtxRawValue() {
        return Util.ConvertLongFPHex(this.data, 744);
    }

    public Duration r723cadtx() {
        return Util.LongFpHex_US(this.data, 752);
    }

    public double r723cadtxSeconds() {
        return Util.ToSeconds(this.r723cadtx());
    }

    public double r723cadtxRawValue() {
        return Util.ConvertLongFPHex(this.data, 752);
    }

    public Duration r723ccvtx() {
        return Util.LongFpHex_US(this.data, 760);
    }

    public double r723ccvtxSeconds() {
        return Util.ToSeconds(this.r723ccvtx());
    }

    public double r723ccvtxRawValue() {
        return Util.ConvertLongFPHex(this.data, 760);
    }

    public Duration r723ciqtx() {
        return Util.LongFpHex_US(this.data, 768);
    }

    public double r723ciqtxSeconds() {
        return Util.ToSeconds(this.r723ciqtx());
    }

    public double r723ciqtxRawValue() {
        return Util.ConvertLongFPHex(this.data, 768);
    }

    public long r723enctrxnum() {
        return Util.ConvertUnsignedBinary4(this.data, 792);
    }

    public long r723enctrxcalls() {
        return Util.ConvertUnsignedBinary4(this.data, 796);
    }

    public Duration r723enctrxet() {
        return Util.LongFpHex_US(this.data, 800);
    }

    public double r723enctrxetSeconds() {
        return Util.ToSeconds(this.r723enctrxet());
    }

    public double r723enctrxetRawValue() {
        return Util.ConvertLongFPHex(this.data, 800);
    }

    public double r723enctrxets() {
        return Util.ConvertLongFPHex(this.data, 808);
    }

    public static ServiceReportClassPeriodDataSection create(byte[] Data2, int offset, int length, WorkloadManagerControlSection controlsection, List<ResponseTimeDistributionDataSection> responseTimeDistributionDataSections) {
        return new ServiceReportClassPeriodDataSection(Data2, offset, length, controlsection, responseTimeDistributionDataSections);
    }

    static enum Field {
        r723crtx(0, 2),
        r723cwmx(2, 2),
        r723cwmn(4, 2),
        r723crs1(6, 1),
        r723cadf(7, 1),
        r723coal(8, 1),
        r723cper(8, 1),
        r723crtf(9, 1),
        r723crgf(10, 1),
        r723crs4(11, 1),
        r723cval(12, 4),
        r723cpct(16, 2),
        r723cimp(18, 2),
        r723cdur(20, 4),
        r723csrv(24, 8),
        r723ccpu(32, 8),
        r723cioc(40, 8),
        r723cmso(48, 8),
        r723csrb(56, 8),
        r723cpir(64, 8),
        r723chpi(72, 8),
        r723cbpi(80, 8),
        r723cpie(88, 8),
        r723cbpe(96, 8),
        r723cbka(104, 8),
        r723cbke(112, 8),
        r723cprs(120, 8),
        r723cers(128, 8),
        r723ctrr(136, 8),
        r723ctat(144, 8),
        r723crct(152, 8),
        r723ciit(160, 8),
        r723chst(168, 8),
        r723cswc(176, 4),
        r723ccrm(180, 4),
        r723crcp(184, 4),
        r723carc(188, 4),
        r723cncp(192, 4),
        r723canc(196, 4),
        r723ctet(200, 8),
        r723cxet(208, 8),
        r723cets(216, 8),
        r723ccus(224, 4),
        r723ctot(228, 4),
        r723ccde(232, 4),
        r723ccca(236, 4),
        r723cswi(240, 4),
        r723cmpl(244, 4),
        r723capr(248, 4),
        r723caco(252, 4),
        r723caxm(256, 4),
        r723cvio(260, 4),
        r723chsp(264, 4),
        r723cchs(268, 4),
        r723cunk(272, 4),
        r723cidl(276, 4),
        r723cpde(280, 4),
        r723cpqu(284, 4),
        r723csac(288, 4),
        r723csrs(292, 8),
        r723cspa(300, 8),
        r723cspe(308, 8),
        r723cict(316, 8),
        r723ciwt(324, 8),
        r723cidt(332, 8),
        r723circ(340, 4),
        r723ctou(344, 4),
        r723ciou(348, 4),
        r723ciod(352, 4),
        r723cq(356, 4),
        r723cspv(360, 4),
        r723csvi(364, 4),
        r723cshs(368, 4),
        r723csmp(372, 4),
        r723cssw(376, 4),
        r723cndi(380, 4),
        r723ctdq(384, 4),
        r723ctsa(388, 8),
        r723ciot(396, 8),
        r723cqdt(404, 8),
        r723cadt(412, 8),
        r723ccvt(420, 8),
        r723ciqt(428, 8),
        r723ciea(436, 8),
        r723cxea(444, 8),
        r723cfea(452, 8),
        r723camu(460, 4),
        r723camd(464, 4),
        r723apu(468, 4),
        r723apd(472, 4),
        r723fqd(476, 4),
        r723plsc(480, 8),
        r723rcod(488, 4),
        r723rcou(492, 4),
        r723ectc(496, 8),
        r723ifau(504, 4),
        r723ifcu(508, 4),
        r723ifad(512, 4),
        r723ifat(516, 8),
        r723ifct(524, 8),
        r723supu(532, 4),
        r723sucu(536, 4),
        r723supd(540, 4),
        r723csup(544, 8),
        r723csuc(552, 8),
        r723cifa(560, 8),
        r723cifc(568, 8),
        r723tpdp(576, 8),
        r723cpdp(584, 8),
        r723lpdp(592, 8),
        r723spdp(600, 8),
        r723rtdm(608, 4),
        r723rtdc(612, 4),
        r723rtdt(616, 8),
        r723tsucp(624, 8),
        r723tsusp(632, 8),
        r723tsuocp(640, 8),
        r723msucp(648, 8),
        r723msusp(656, 8),
        r723msuocp(664, 8),
        r723asucp(672, 8),
        r723asusp(680, 8),
        r723asuocp(688, 8),
        r723bsucp(696, 8),
        r723bsusp(704, 8),
        r723bsuocp(712, 8),
        r723ctetx(720, 8),
        r723cxetx(728, 8),
        r723cetsx(736, 8),
        r723cqdtx(744, 8),
        r723cadtx(752, 8),
        r723ccvtx(760, 8),
        r723ciqtx(768, 8),
        r723enctrxnum(792, 4),
        r723enctrxcalls(796, 4),
        r723enctrxet(800, 8),
        r723enctrxets(808, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

