/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Header
extends SmfData {
    public static final int SMF74RRF = 128;
    public static final int SMF74SUT = 64;
    public static final int SMF74V4 = 16;
    public static final int SMF74ESA = 8;
    public static final int SMF74VXA = 4;
    public static final int SMF74OS = 2;
    public static final int SMF74BFY = 1;

    private Header(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Header(byte[] Data2) {
        super(Data2);
    }

    public int smf74len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf74seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf74flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf74rrf() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 128);
    }

    public boolean smf74sut() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 64);
    }

    public boolean smf74v4() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 16);
    }

    public boolean smf74esa() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 8);
    }

    public boolean smf74vxa() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 4);
    }

    public boolean smf74os() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 2);
    }

    public boolean smf74bfy() {
        return Util.ConvertFlag(this.data, this.smf74flg(), 1);
    }

    public int smf74rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf74tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf74tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf74dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf74dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf74sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf74ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf74sty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf74trn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf74prs() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf74prl() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf74prn() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf74dcs() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf74dcl() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf74dcn() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf74dds() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf74ddl() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf74ddn() {
        if (this.smf74sty() != 1) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 1");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf742co() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf742cl() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf742cn() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf742so() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf742sl() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf742sn() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf742po() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf742pl() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf742pn() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf742mo() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf742ml() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf742mn() {
        if (this.smf74sty() != 2) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 2");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf743po() {
        if (this.smf74sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 3");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf743pl() {
        if (this.smf74sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf743pn() {
        if (this.smf74sty() != 3) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 3");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf744fo() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf744fl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf744fn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf744xo() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf744xl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf744xn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf744go() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf744gl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf744gn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf744qo() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf744ql() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf744qn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf744so() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf744sl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf744sn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf744po() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf744pl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf744pn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf744co() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 84);
    }

    public int smf744cl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public int smf744cn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public int smf744ro() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 92);
    }

    public int smf744rl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 96);
    }

    public int smf744rn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 98);
    }

    public int smf744ho() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 100);
    }

    public int smf744hl() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 104);
    }

    public int smf744hn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public int smf744mo() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 108);
    }

    public int smf744ml() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public int smf744mn() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public int smf744ao() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertSignedBinary4(this.data, 116);
    }

    public int smf744al() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 120);
    }

    public int smf744an() {
        if (this.smf74sty() != 4) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 4");
        }
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public int smf745co() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf745cl() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf745cn() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf745do() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf745dl() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf745dn() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf745xo() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf745xl() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf745xn() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf745so() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf745sl() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf745sn() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf7451o() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf7451l() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf7451n() {
        if (this.smf74sty() != 5) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 5");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf746do() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf746dl() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf746dn() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf746bo() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf746bl() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf746bn() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf746fo() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf746fl() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf746fn() {
        if (this.smf74sty() != 6) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 6");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf747go() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf747gl() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf747gn() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf747so() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf747sl() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf747sn() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf747po() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf747pl() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf747pn() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf747co() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf747cl() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf747cn() {
        if (this.smf74sty() != 7) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 7");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf748co() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf748cl() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf748cn() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf748lo() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf748ll() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf748ln() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf748xo() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf748xl() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf748xn() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf748ro() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf748rl() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf748rn() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf748ao() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf748al() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf748an() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf748so() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf748sl() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf748sn() {
        if (this.smf74sty() != 8) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 8");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf749po() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf749pl() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf749pn() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf749do() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf749dl() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf749dn() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public int smf749fo() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 52);
    }

    public int smf749fl() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf749fn() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int smf7491o() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int smf7491l() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int smf7491n() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public int smf749so() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 68);
    }

    public int smf749sl() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public int smf749sn() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int smf749ro() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertSignedBinary4(this.data, 76);
    }

    public int smf749rl() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf749rn() {
        if (this.smf74sty() != 9) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 9");
        }
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public int smf7410do() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf7410dl() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf7410dn() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf7410co() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf7410cl() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf7410cn() {
        if (this.smf74sty() != 10) {
            throw new NotAvailableException("This method is only supported when smf74sty() == 10");
        }
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public static Header create(byte[] Data2, int offset, int length) {
        return new Header(Data2, offset, length);
    }

    static enum Field {
        smf74len(0, 2),
        smf74seg(2, 2),
        smf74flg(4, 1),
        smf74rty(5, 1),
        smf74tme(6, 4),
        smf74dte(10, 4),
        smf74sid(14, 4),
        smf74ssi(18, 4),
        smf74sty(22, 2),
        smf74trn(24, 2),
        smf74prs(28, 4),
        smf74prl(32, 2),
        smf74prn(34, 2),
        smf74dcs(36, 4),
        smf74dcl(40, 2),
        smf74dcn(42, 2),
        smf74dds(44, 4),
        smf74ddl(48, 2),
        smf74ddn(50, 2),
        smf742co(36, 4),
        smf742cl(40, 2),
        smf742cn(42, 2),
        smf742so(44, 4),
        smf742sl(48, 2),
        smf742sn(50, 2),
        smf742po(52, 4),
        smf742pl(56, 2),
        smf742pn(58, 2),
        smf742mo(60, 4),
        smf742ml(64, 2),
        smf742mn(66, 2),
        smf743po(36, 4),
        smf743pl(40, 2),
        smf743pn(42, 2),
        smf744fo(36, 4),
        smf744fl(40, 2),
        smf744fn(42, 2),
        smf744xo(44, 4),
        smf744xl(48, 2),
        smf744xn(50, 2),
        smf744go(52, 4),
        smf744gl(56, 2),
        smf744gn(58, 2),
        smf744qo(60, 4),
        smf744ql(64, 2),
        smf744qn(66, 2),
        smf744so(68, 4),
        smf744sl(72, 2),
        smf744sn(74, 2),
        smf744po(76, 4),
        smf744pl(80, 2),
        smf744pn(82, 2),
        smf744co(84, 4),
        smf744cl(88, 2),
        smf744cn(90, 2),
        smf744ro(92, 4),
        smf744rl(96, 2),
        smf744rn(98, 2),
        smf744ho(100, 4),
        smf744hl(104, 2),
        smf744hn(106, 2),
        smf744mo(108, 4),
        smf744ml(112, 2),
        smf744mn(114, 2),
        smf744ao(116, 4),
        smf744al(120, 2),
        smf744an(122, 2),
        smf745co(36, 4),
        smf745cl(40, 2),
        smf745cn(42, 2),
        smf745do(44, 4),
        smf745dl(48, 2),
        smf745dn(50, 2),
        smf745xo(52, 4),
        smf745xl(56, 2),
        smf745xn(58, 2),
        smf745so(60, 4),
        smf745sl(64, 2),
        smf745sn(66, 2),
        smf7451o(68, 4),
        smf7451l(72, 2),
        smf7451n(74, 2),
        smf746do(36, 4),
        smf746dl(40, 2),
        smf746dn(42, 2),
        smf746bo(44, 4),
        smf746bl(48, 2),
        smf746bn(50, 2),
        smf746fo(52, 4),
        smf746fl(56, 2),
        smf746fn(58, 2),
        smf747go(36, 4),
        smf747gl(40, 2),
        smf747gn(42, 2),
        smf747so(44, 4),
        smf747sl(48, 2),
        smf747sn(50, 2),
        smf747po(52, 4),
        smf747pl(56, 2),
        smf747pn(58, 2),
        smf747co(60, 4),
        smf747cl(64, 2),
        smf747cn(66, 2),
        smf748co(36, 4),
        smf748cl(40, 2),
        smf748cn(42, 2),
        smf748lo(44, 4),
        smf748ll(48, 2),
        smf748ln(50, 2),
        smf748xo(52, 4),
        smf748xl(56, 2),
        smf748xn(58, 2),
        smf748ro(60, 4),
        smf748rl(64, 2),
        smf748rn(66, 2),
        smf748ao(68, 4),
        smf748al(72, 2),
        smf748an(74, 2),
        smf748so(76, 4),
        smf748sl(80, 2),
        smf748sn(82, 2),
        smf749po(36, 4),
        smf749pl(40, 2),
        smf749pn(42, 2),
        smf749do(44, 4),
        smf749dl(48, 2),
        smf749dn(50, 2),
        smf749fo(52, 4),
        smf749fl(56, 2),
        smf749fn(58, 2),
        smf7491o(60, 4),
        smf7491l(64, 2),
        smf7491n(66, 2),
        smf749so(68, 4),
        smf749sl(72, 2),
        smf749sn(74, 2),
        smf749ro(76, 4),
        smf749rl(80, 2),
        smf749rn(82, 2),
        smf7410do(36, 4),
        smf7410dl(40, 2),
        smf7410dn(42, 2),
        smf7410co(44, 4),
        smf7410cl(48, 2),
        smf7410cn(50, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

