/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class XcfMemberDataSection
extends SmfData {
    public static final int R742MACT = 128;
    public static final int R742MIAC = 64;
    public static final int R742MRES = 32;
    public static final int R742MPAR = 16;
    public static final int R742MNOQ = 8;
    public static final int R742MCRE = 2;
    public static final int R742MACV = 3;
    public static final int R742MQUI = 4;
    public static final int R742MFLD = 5;
    public static final int R742MSSM = 128;
    public static final int R742MTRM = 64;
    public static final int R742MMSM = 16;
    public static final int R742MMSD = 8;
    public static final int R742MREM = 2;

    private XcfMemberDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String r742msys() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String r742mgrp() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String r742mmem() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public int r742mstf() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public boolean r742mact() {
        return Util.ConvertFlag(this.data, this.r742mstf(), 128);
    }

    public boolean r742miac() {
        return Util.ConvertFlag(this.data, this.r742mstf(), 64);
    }

    public boolean r742mres() {
        return Util.ConvertFlag(this.data, this.r742mstf(), 32);
    }

    public boolean r742mpar() {
        return Util.ConvertFlag(this.data, this.r742mstf(), 16);
    }

    public boolean r742mnoq() {
        return Util.ConvertFlag(this.data, this.r742mstf(), 8);
    }

    public int r742mst1() {
        return Util.ConvertUnsignedBinary1(this.data, 33);
    }

    public int r742mst2() {
        return Util.ConvertUnsignedBinary1(this.data, 34);
    }

    public boolean r742mssm() {
        return Util.ConvertFlag(this.data, this.r742mst2(), 128);
    }

    public boolean r742mtrm() {
        return Util.ConvertFlag(this.data, this.r742mst2(), 64);
    }

    public boolean r742mmsm() {
        return Util.ConvertFlag(this.data, this.r742mst2(), 16);
    }

    public boolean r742mmsd() {
        return Util.ConvertFlag(this.data, this.r742mst2(), 8);
    }

    public boolean r742mrem() {
        return Util.ConvertFlag(this.data, this.r742mst2(), 2);
    }

    public long r742msnt() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r742mrcv() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long r742mint() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public String r742mjob() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public static XcfMemberDataSection create(byte[] Data2, int offset, int length) {
        return new XcfMemberDataSection(Data2, offset, length);
    }

    static enum Field {
        r742msys(0, 8),
        r742mgrp(8, 8),
        r742mmem(16, 16),
        r742mstf(32, 1),
        r742mst1(33, 1),
        r742mst2(34, 1),
        r742msnt(36, 4),
        r742mrcv(40, 4),
        r742mint(44, 4),
        r742mjob(48, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

