/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CfLocalCouplingFacilityDataSection
extends SmfData {
    private final int smf74mfv;
    private final int smf74srl;
    public static final int R744FCEI = 128;
    public static final int R744FADI = 64;
    public static final int R744FPEC = 32;
    public static final int R744FDYD = 16;
    public static final int R744FTHN = 8;
    public static final int R744FNOHW = 4;
    public static final int R744FCHO = 128;
    private List<String> m_r744ftap = null;
    int[] m_r744fidp = null;

    private CfLocalCouplingFacilityDataSection(byte[] Data2, int offset, int length, int smf74mfv, int smf74srl) {
        super(Data2, offset, length);
        this.smf74mfv = smf74mfv;
        this.smf74srl = smf74srl;
    }

    public String r744fnam() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String r744fsys() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public int r744fflg() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public boolean r744fcei() {
        return Util.ConvertFlag(this.data, this.r744fflg(), 128);
    }

    public boolean r744fadi() {
        return Util.ConvertFlag(this.data, this.r744fflg(), 64);
    }

    public boolean r744fpec() {
        return Util.ConvertFlag(this.data, this.r744fflg(), 32);
    }

    public boolean r744fdyd() {
        if (this.r744flvl() <= 14L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 14");
        }
        return Util.ConvertFlag(this.data, this.r744fflg(), 16);
    }

    public boolean r744fthn() {
        if (this.r744flvl() <= 18L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 18");
        }
        return Util.ConvertFlag(this.data, this.r744fflg(), 8);
    }

    public boolean r744fnohw() {
        return Util.ConvertFlag(this.data, this.r744fflg(), 4);
    }

    public int r744fflc() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public boolean r744fcho() {
        return Util.ConvertFlag(this.data, this.r744fflc(), 128);
    }

    public int r744famv() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public long r744fpam() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public double r744fpbc() {
        return Util.ConvertLongFPHex(this.data, 24);
    }

    public long r744fscg() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long r744fscu() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long r744fscl() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public double r744fscc() {
        return Util.ConvertLongFPHex(this.data, 44);
    }

    public double r744ftor() {
        return Util.ConvertLongFPHex(this.data, 52);
    }

    public double r744fail() {
        return Util.ConvertLongFPHex(this.data, 60);
    }

    public Duration r744ftim() {
        return Util.Binary8USSeconds(this.data, 68);
    }

    public double r744ftimSeconds() {
        return Util.ToSeconds(this.r744ftim());
    }

    public BigInteger r744ftimRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 68);
    }

    public double r744fsquSecondsSq() {
        return Util.Binary8USSquared(this.data, 76);
    }

    public BigInteger r744fsquRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public Duration r744fctm() {
        return Util.Binary8USSeconds(this.data, 84);
    }

    public double r744fctmSeconds() {
        return Util.ToSeconds(this.r744fctm());
    }

    public BigInteger r744fctmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 84);
    }

    public double r744fcsqSecondsSq() {
        return Util.Binary8USSquared(this.data, 92);
    }

    public BigInteger r744fcsqRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public String r744fmod() {
        return Util.ConvertEbcdic(this.data, 100, 6);
    }

    public String r744fver() {
        return Util.ConvertEbcdic(this.data, 106, 3);
    }

    public String r744fmpc() {
        return Util.ConvertEbcdic(this.data, 109, 2);
    }

    public int r744flpn() {
        if (this.smf74srl < 85 || this.smf74mfv < 718) {
            throw new NotAvailableException("This method is only supported when smf74srl() >= 85 && smf74mfv() >= 718");
        }
        return Util.ConvertUnsignedBinary1(this.data, 111);
    }

    public long r744flvl() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public int r744fpas() {
        return Util.ConvertUnsignedBinary1(this.data, 116);
    }

    public int r744fpis() {
        return Util.ConvertUnsignedBinary1(this.data, 117);
    }

    public int r744fpcm() {
        return Util.ConvertUnsignedBinary1(this.data, 118);
    }

    public List<String> r744ftap() {
        if (this.m_r744ftap != null) {
            return this.m_r744ftap;
        }
        ArrayList<String> result = new ArrayList<String>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(Util.ConvertEbcdic(this.data, Field.r744ftap.offset + i * Field.r744ftap.length, Field.r744ftap.length));
        }
        this.m_r744ftap = Collections.unmodifiableList(result);
        return this.m_r744ftap;
    }

    public String r744fseq() {
        return Util.ConvertEbcdic(this.data, 160, 12);
    }

    public int r744fpsn() {
        if (this.r744flvl() <= 14L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 14");
        }
        return Util.ConvertUnsignedBinary2(this.data, 172);
    }

    public int r744fpdn() {
        if (this.r744flvl() <= 14L) {
            throw new NotAvailableException("This method is only supported when r744flvl() > 14");
        }
        return Util.ConvertUnsignedBinary2(this.data, 174);
    }

    public int[] r744fidp() {
        if (this.m_r744fidp != null) {
            return this.m_r744fidp;
        }
        int[] result = new int[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = Util.ConvertUnsignedBinary1(this.data, Field.r744fidp.offset + i * Field.r744fidp.length);
        }
        this.m_r744fidp = result;
        return result;
    }

    public int r744fcpi() {
        return Util.ConvertUnsignedBinary2(this.data, 184);
    }

    public int r744fcpn() {
        return Util.ConvertUnsignedBinary2(this.data, 186);
    }

    public static CfLocalCouplingFacilityDataSection create(byte[] Data2, int offset, int length, int smf74mfv, int smf74srl) {
        return new CfLocalCouplingFacilityDataSection(Data2, offset, length, smf74mfv, smf74srl);
    }

    static enum Field {
        r744fnam(0, 8),
        r744fsys(8, 8),
        r744fflg(16, 1),
        r744fflc(17, 1),
        r744famv(19, 1),
        r744fpam(20, 4),
        r744fpbc(24, 8),
        r744fscg(32, 4),
        r744fscu(36, 4),
        r744fscl(40, 4),
        r744fscc(44, 8),
        r744ftor(52, 8),
        r744fail(60, 8),
        r744ftim(68, 8),
        r744fsqu(76, 8),
        r744fctm(84, 8),
        r744fcsq(92, 8),
        r744fmod(100, 6),
        r744fver(106, 3),
        r744fmpc(109, 2),
        r744flpn(111, 1),
        r744flvl(112, 4),
        r744fpas(116, 1),
        r744fpis(117, 1),
        r744fpcm(118, 1),
        r744ftap(120, 5),
        r744fseq(160, 12),
        r744fpsn(172, 2),
        r744fpdn(174, 2),
        r744fidp(176, 1),
        r744fcpi(184, 2),
        r744fcpn(186, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

