/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype4;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class CfProcessorUtilizationDataSection
extends SmfData {
    public static final int R744PTDE = 128;

    private CfProcessorUtilizationDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long r744pnum() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public Duration r744pbsy() {
        return Util.Binary4US(this.data, 4);
    }

    public double r744pbsySeconds() {
        return Util.ToSeconds(this.r744pbsy());
    }

    public long r744pbsyRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public Duration r744pwai() {
        return Util.Binary4US(this.data, 8);
    }

    public double r744pwaiSeconds() {
        return Util.ToSeconds(this.r744pwai());
    }

    public long r744pwaiRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public int r744ptyp() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public boolean r744ptde() {
        return Util.ConvertFlag(this.data, this.r744ptyp(), 128);
    }

    public int r744pwgt() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int r744pbsg() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public long r744pcct() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public byte[] r744ptle() {
        if (this.data.length >= 44) {
            byte[] result = new byte[16];
            System.arraycopy(this.data, 28, result, 0, 16);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(28) + " Data length: " + Integer.toString(16));
    }

    public static CfProcessorUtilizationDataSection create(byte[] Data2, int offset, int length) {
        return new CfProcessorUtilizationDataSection(Data2, offset, length);
    }

    static enum Field {
        r744pnum(0, 4),
        r744pbsy(4, 4),
        r744pwai(8, 4),
        r744ptyp(12, 1),
        r744pwgt(14, 2),
        r744pbsg(16, 1),
        r744pcct(24, 4),
        r744ptle(28, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

