/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype7;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class FcdGlobalDataSection
extends SmfData {
    public static final int R747GDCA = 128;
    public static final int R747GIAC = 64;
    public static final int R747GIOD = 32;
    public static final int R747GICV = 16;

    private FcdGlobalDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r747gcfl() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean r747gdca() {
        return Util.ConvertFlag(this.data, this.r747gcfl(), 128);
    }

    public boolean r747giac() {
        return Util.ConvertFlag(this.data, this.r747gcfl(), 64);
    }

    public boolean r747giod() {
        return Util.ConvertFlag(this.data, this.r747gcfl(), 32);
    }

    public boolean r747gicv() {
        return Util.ConvertFlag(this.data, this.r747gcfl(), 16);
    }

    public int r747gnfd() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public String r747ginm() {
        return Util.ConvertEbcdic(this.data, 4, 44);
    }

    public String r747gisf() {
        return Util.ConvertEbcdic(this.data, 48, 2);
    }

    public String r747gici() {
        return Util.ConvertEbcdic(this.data, 50, 18);
    }

    public LocalDate r747gicd() {
        return Util.EBCDIC10mm_dd_yyyy(this.data, 50);
    }

    public String r747gicdRawValue() {
        return Util.ConvertEbcdic(this.data, 50, 10);
    }

    public LocalTime r747gict() {
        return Util.EBCDIC8hh_mm_ss(this.data, 60);
    }

    public String r747gictRawValue() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public static FcdGlobalDataSection create(byte[] Data2, int offset, int length) {
        return new FcdGlobalDataSection(Data2, offset, length);
    }

    static enum Field {
        r747gcfl(0, 1),
        r747gnfd(2, 2),
        r747ginm(4, 44),
        r747gisf(48, 2),
        r747gici(50, 18),
        r747gicd(50, 10),
        r747gict(60, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

