/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf74.subtype8;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class EssControlDataSection
extends SmfData {
    public static final int R748CXVL = 128;

    private EssControlDataSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int r748clvl() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public String r748ctyp() {
        return Util.ConvertEbcdic(this.data, 1, 6);
    }

    public String r748cmdl() {
        return Util.ConvertEbcdic(this.data, 7, 3);
    }

    public String r748cser() {
        return Util.ConvertEbcdic(this.data, 10, 10);
    }

    public int r748cvsn() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    public int r748cae() {
        return Util.ConvertUnsignedBinary3(this.data, 21);
    }

    public int r748crtn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int r748csc() {
        return Util.ConvertUnsignedBinary1(this.data, 26);
    }

    public int r748cioc() {
        return Util.ConvertUnsignedBinary1(this.data, 27);
    }

    public int r748cfdv() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public String r748cvol() {
        return Util.ConvertEbcdic(this.data, 30, 6);
    }

    public String r748cdev() {
        return Util.ConvertEbcdic(this.data, 36, 2);
    }

    public int r748cflg() {
        return Util.ConvertUnsignedBinary1(this.data, 38);
    }

    public boolean r748cxvl() {
        return Util.ConvertFlag(this.data, this.r748cflg(), 128);
    }

    public int r748cscs() {
        return Util.ConvertUnsignedBinary1(this.data, 39);
    }

    public Duration r748cint() {
        return Util.Binary4_Seconds(this.data, 40);
    }

    public double r748cintSeconds() {
        return Util.ToSeconds(this.r748cint());
    }

    public long r748cintRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public int r748cftm() {
        return Util.ConvertPacked4(this.data, 44);
    }

    public int r748cfdt() {
        return Util.ConvertPacked4(this.data, 48);
    }

    public int r748cfci() {
        return Util.ConvertPacked4(this.data, 52);
    }

    public int r748cfsc() {
        return Util.ConvertUnsignedBinary1(this.data, 56);
    }

    public static EssControlDataSection create(byte[] Data2, int offset, int length) {
        return new EssControlDataSection(Data2, offset, length);
    }

    static enum Field {
        r748clvl(0, 1),
        r748ctyp(1, 6),
        r748cmdl(7, 3),
        r748cser(10, 10),
        r748cvsn(20, 1),
        r748cae(21, 3),
        r748crtn(24, 2),
        r748csc(26, 1),
        r748cioc(27, 1),
        r748cfdv(28, 2),
        r748cvol(30, 6),
        r748cdev(36, 2),
        r748cflg(38, 1),
        r748cscs(39, 1),
        r748cint(40, 4),
        r748cftm(44, 4),
        r748cfdt(48, 4),
        r748cfci(52, 4),
        r748cfsc(56, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

